/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.common.matcher;

import de.flapdoodle.os.common.matcher.LsbReleaseFileEntryMatcher;
import de.flapdoodle.os.common.matcher.LsbReleaseFileMapEntry;
import de.flapdoodle.os.common.matcher.Match;
import de.flapdoodle.os.common.matcher.MatchPattern;
import de.flapdoodle.os.common.matcher.Matcher;
import de.flapdoodle.os.common.matcher.OsReleaseFileEntryMatcher;
import de.flapdoodle.os.common.matcher.OsReleaseFileMapEntry;
import de.flapdoodle.os.common.matcher.PatternMatcher;
import java.util.Optional;

@FunctionalInterface
public interface MatcherLookup {
    public <T, M extends Match<T>> Optional<Matcher<T, M>> matcher(M var1);

    default public MatcherLookup join(final MatcherLookup other) {
        final MatcherLookup that = this;
        return new MatcherLookup(){

            @Override
            public <T, M extends Match<T>> Optional<Matcher<T, M>> matcher(M match) {
                Optional first = that.matcher(match);
                if (first.isPresent()) {
                    return first;
                }
                return other.matcher(match);
            }
        };
    }

    public static <T, M extends Match<T>> MatcherLookup forType(final Class<M> type, final Matcher<T, M> matcher) {
        return new MatcherLookup(){

            public <_T, _M extends Match<_T>> Optional<Matcher<_T, _M>> matcher(_M match) {
                if (type.isInstance(match)) {
                    return Optional.of(matcher);
                }
                return Optional.empty();
            }
        };
    }

    public static MatcherLookup failing() {
        return new MatcherLookup(){

            @Override
            public <T, M extends Match<T>> Optional<Matcher<T, M>> matcher(M match) {
                throw new IllegalArgumentException("no attribute matcher for " + match.getClass());
            }
        };
    }

    public static MatcherLookup systemDefault() {
        return MatcherLookup.forType(MatchPattern.class, new PatternMatcher()).join(MatcherLookup.forType(OsReleaseFileMapEntry.class, new OsReleaseFileEntryMatcher())).join(MatcherLookup.forType(LsbReleaseFileMapEntry.class, new LsbReleaseFileEntryMatcher())).join(MatcherLookup.failing());
    }
}

