package de.flapdoodle.os.common.attributes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SystemProperty}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSystemProperty.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSystemProperty.of()}.
 */
@Generated(from = "SystemProperty", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableSystemProperty implements SystemProperty {
  private final String name;

  private ImmutableSystemProperty(String name) {
    this.name = Objects.requireNonNull(name, "name");
  }

  private ImmutableSystemProperty(ImmutableSystemProperty original, String name) {
    this.name = name;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SystemProperty#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSystemProperty withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableSystemProperty(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSystemProperty} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSystemProperty
        && equalTo((ImmutableSystemProperty) another);
  }

  private boolean equalTo(ImmutableSystemProperty another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SystemProperty} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SystemProperty{"
        + "name=" + name
        + "}";
  }

  /**
   * Construct a new immutable {@code SystemProperty} instance.
   * @param name The value for the {@code name} attribute
   * @return An immutable SystemProperty instance
   */
  public static ImmutableSystemProperty of(String name) {
    return new ImmutableSystemProperty(name);
  }

  /**
   * Creates an immutable copy of a {@link SystemProperty} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SystemProperty instance
   */
  public static ImmutableSystemProperty copyOf(SystemProperty instance) {
    if (instance instanceof ImmutableSystemProperty) {
      return (ImmutableSystemProperty) instance;
    }
    return ImmutableSystemProperty.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSystemProperty ImmutableSystemProperty}.
   * <pre>
   * ImmutableSystemProperty.builder()
   *    .name(String) // required {@link SystemProperty#name() name}
   *    .build();
   * </pre>
   * @return A new ImmutableSystemProperty builder
   */
  public static ImmutableSystemProperty.Builder builder() {
    return new ImmutableSystemProperty.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSystemProperty ImmutableSystemProperty}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SystemProperty", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SystemProperty} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SystemProperty instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      return this;
    }

    /**
     * Initializes the value for the {@link SystemProperty#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSystemProperty ImmutableSystemProperty}.
     * @return An immutable instance of SystemProperty
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSystemProperty build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSystemProperty(null, name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build SystemProperty, some of required attributes are not set " + attributes;
    }
  }
}
