/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.linux;

import de.flapdoodle.os.Version;
import de.flapdoodle.os.common.HasPecularities;
import de.flapdoodle.os.common.Peculiarity;
import de.flapdoodle.os.common.matcher.Matchers;
import de.flapdoodle.os.common.types.OsReleaseFile;
import de.flapdoodle.os.linux.Attributes;
import java.util.List;

public enum UbuntuVersion implements Version
{
    UBUNTU_18_04(UbuntuVersion.osReleaseFileVersionMatches("18.04")),
    UBUNTU_18_10(UbuntuVersion.osReleaseFileVersionMatches("18.10")),
    UBUNTU_19_04(UbuntuVersion.osReleaseFileVersionMatches("19.04")),
    UBUNTU_19_10(UbuntuVersion.osReleaseFileVersionMatches("19.10")),
    UBUNTU_20_04(UbuntuVersion.osReleaseFileVersionMatches("20.04")),
    UBUNTU_20_10(UbuntuVersion.osReleaseFileVersionMatches("20.10"));

    private final List<Peculiarity<?>> peculiarities;

    private UbuntuVersion(Peculiarity ... peculiarities) {
        this.peculiarities = HasPecularities.asList(peculiarities);
    }

    @Override
    public List<Peculiarity<?>> pecularities() {
        return this.peculiarities;
    }

    private static Peculiarity<OsReleaseFile> osReleaseFileVersionMatches(String version) {
        return Peculiarity.of(Attributes.osReleaseFile(), Matchers.osReleaseFileEntry("VERSION_ID", ".*" + version + ".*"));
    }
}

