/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.linux;

import de.flapdoodle.os.VersionWithPriority;
import de.flapdoodle.os.common.DistinctPeculiarity;
import de.flapdoodle.os.common.HasPecularities;
import de.flapdoodle.os.common.Peculiarity;
import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.attributes.Attributes;
import de.flapdoodle.os.common.matcher.Match;
import de.flapdoodle.os.common.matcher.Matchers;
import java.util.List;

public enum AmazonVersion implements VersionWithPriority
{
    AmazonLinux(new Peculiarity[]{AmazonVersion.osVersionMatches(".*amzn1.*")}),
    AmazonLinux2(new Peculiarity[]{AmazonVersion.osVersionMatches(".*amzn2.*")});

    private final List<Peculiarity> peculiarities;

    private AmazonVersion(Peculiarity ... peculiarities) {
        this.peculiarities = HasPecularities.asList((Peculiarity[])peculiarities);
    }

    public List<Peculiarity> pecularities() {
        return this.peculiarities;
    }

    public int priority() {
        return -1;
    }

    static DistinctPeculiarity<String> osVersionMatches(String name) {
        return DistinctPeculiarity.of(AmazonVersion.osVersion(), (Match)Matchers.matchPattern((String)name));
    }

    static Attribute<String> osVersion() {
        return Attributes.systemProperty((String)"os.version");
    }
}

