/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRule;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.distribution.Distribution;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class PlatformMatchRules {
    abstract List<PlatformMatchRule> rules();

    public ImmutablePlatformMatchRules with(PlatformMatchRule rule) {
        return PlatformMatchRules.builder().rules(this.rules()).addRules(rule).build();
    }

    @Value.Auxiliary
    public Optional<DistributionPackage> packageFor(Distribution distribution) {
        for (PlatformMatchRule rule : this.rules()) {
            Optional<DistributionPackage> result;
            if (!rule.match().match(distribution) || !(result = rule.finder().packageFor(distribution)).isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public static ImmutablePlatformMatchRules empty() {
        return PlatformMatchRules.builder().build();
    }

    public static ImmutablePlatformMatchRules.Builder builder() {
        return ImmutablePlatformMatchRules.builder();
    }
}

