/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.packageresolver.AbstractPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.packageresolver.HasExplanation;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.linux.AlmaPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.AlpinePackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.AmazonPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.CentosPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.DebianFallbackToOlderVersionPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.DebianPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.DebianUsesUbuntuOnArmPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.FedoraPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.KdeNeonPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.LinuxLegacyPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.LinuxMintPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.ManjaroPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.OraclePackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.PopOSPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.RedhatFallbackToOlderVersionPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.RedhatPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.RockyPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.UbuntuFallbackToOlderVersionPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.UbuntuPackageFinder;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.ImmutableFileSet;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.CommonOS;
import de.flapdoodle.os.ImmutablePlatform;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Platform;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.linux.AlmaVersion;
import de.flapdoodle.os.linux.AlpineVersion;
import de.flapdoodle.os.linux.AmazonVersion;
import de.flapdoodle.os.linux.CentosVersion;
import de.flapdoodle.os.linux.DebianVersion;
import de.flapdoodle.os.linux.FedoraVersion;
import de.flapdoodle.os.linux.KdeNeonVersion;
import de.flapdoodle.os.linux.LinuxMintVersion;
import de.flapdoodle.os.linux.ManjaroVersion;
import de.flapdoodle.os.linux.OracleVersion;
import de.flapdoodle.os.linux.PopOSVersion;
import de.flapdoodle.os.linux.RedhatVersion;
import de.flapdoodle.os.linux.RockyVersion;
import de.flapdoodle.os.linux.UbuntuVersion;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxPackageFinder
extends AbstractPackageFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinuxPackageFinder.class);

    public LinuxPackageFinder(Command command) {
        super(command, LinuxPackageFinder.rules(command));
    }

    private static ImmutablePackageFinderRules rules(Command command) {
        ImmutableFileSet fileSet = FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
        UbuntuPackageFinder ubuntuPackageFinder = new UbuntuPackageFinder(command);
        UbuntuFallbackToOlderVersionPackageFinder ubuntuDowngradingPackageFinder = new UbuntuFallbackToOlderVersionPackageFinder(ubuntuPackageFinder);
        ImmutablePackageFinderRule ubuntuRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])UbuntuVersion.values())).finder(ubuntuPackageFinder).build();
        ImmutablePackageFinderRule ubuntuDowngradeRule = PackageFinderRule.builder().match(ubuntuDowngradingPackageFinder.platformMatch()).finder(ubuntuDowngradingPackageFinder).build();
        ImmutablePackageFinderRule linuxMintRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])LinuxMintVersion.values())).finder(new LinuxMintPackageFinder(ubuntuDowngradingPackageFinder)).build();
        ImmutablePackageFinderRule popOsRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])PopOSVersion.values())).finder(new PopOSPackageFinder(ubuntuDowngradingPackageFinder)).build();
        ImmutablePackageFinderRule kdeNeonRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])KdeNeonVersion.values())).finder(new KdeNeonPackageFinder(ubuntuDowngradingPackageFinder)).build();
        DebianPackageFinder debianPackageFinder = new DebianPackageFinder(command);
        DebianFallbackToOlderVersionPackageFinder debianDowngradingPackageFinder = new DebianFallbackToOlderVersionPackageFinder(debianPackageFinder);
        DebianUsesUbuntuOnArmPackageFinder debianUsesUbuntuOnArmPackageFinder = new DebianUsesUbuntuOnArmPackageFinder(ubuntuDowngradingPackageFinder);
        ImmutablePackageFinderRule debianRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])DebianVersion.values())).finder(debianPackageFinder).build();
        ImmutablePackageFinderRule debianDowngradeRule = PackageFinderRule.builder().match(debianDowngradingPackageFinder.platformMatch()).finder(debianDowngradingPackageFinder).build();
        ImmutablePackageFinderRule debianArmUsesUbuntuRule = PackageFinderRule.builder().match(debianUsesUbuntuOnArmPackageFinder.platformMatch()).finder(debianUsesUbuntuOnArmPackageFinder).build();
        RedhatPackageFinder redhatPackageFinder = new RedhatPackageFinder(command);
        RedhatFallbackToOlderVersionPackageFinder redhatDowngradingPackageFinder = new RedhatFallbackToOlderVersionPackageFinder(redhatPackageFinder);
        ImmutablePackageFinderRule redhatRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])RedhatVersion.values())).finder(redhatPackageFinder).build();
        ImmutablePackageFinderRule redhatDowngradeRule = PackageFinderRule.builder().match(redhatDowngradingPackageFinder.platformMatch()).finder(redhatDowngradingPackageFinder).build();
        ImmutablePackageFinderRule fedoraRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])FedoraVersion.values())).finder(new FedoraPackageFinder(redhatDowngradingPackageFinder)).build();
        ImmutablePackageFinderRule oracleRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])OracleVersion.values())).finder(new OraclePackageFinder(redhatDowngradingPackageFinder)).build();
        ImmutablePackageFinderRule centosRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])CentosVersion.values())).finder(new CentosPackageFinder(redhatDowngradingPackageFinder)).build();
        ImmutablePackageFinderRule almaRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])AlmaVersion.values())).finder(new AlmaPackageFinder(redhatDowngradingPackageFinder)).build();
        ImmutablePackageFinderRule manjaroRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])ManjaroVersion.values())).finder(new ManjaroPackageFinder(ubuntuDowngradingPackageFinder)).build();
        ImmutablePackageFinderRule rockyRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])RockyVersion.values())).finder(new RockyPackageFinder(redhatDowngradingPackageFinder)).build();
        ImmutablePackageFinderRule amazonRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])AmazonVersion.values())).finder(new AmazonPackageFinder(command)).build();
        ImmutablePackageFinderRule alpineRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])AlpineVersion.values())).finder(new AlpinePackageFinder(command)).build();
        ImmutablePackageFinderRule linuxLegacyRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux)).finder(new LinuxLegacyPackageFinder(command)).build();
        ImmutablePackageFinderRule failIfNothingMatches = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux)).finder(new FallbackToUbuntuOrFailPackageFinder(ubuntuDowngradingPackageFinder)).build();
        return PackageFinderRules.empty().withRules(ubuntuRule, ubuntuDowngradeRule, linuxMintRule, popOsRule, kdeNeonRule, debianArmUsesUbuntuRule, debianRule, debianDowngradeRule, redhatRule, redhatDowngradeRule, fedoraRule, oracleRule, centosRule, almaRule, manjaroRule, rockyRule, amazonRule, alpineRule, linuxLegacyRule, failIfNothingMatches);
    }

    static class FallbackToUbuntuOrFailPackageFinder
    implements PackageFinder,
    HasExplanation {
        private final UbuntuFallbackToOlderVersionPackageFinder ubuntuPackageFinder;
        private final UbuntuVersion fallbackUbuntuVersion = UbuntuVersion.Ubuntu_20_04;

        public FallbackToUbuntuOrFailPackageFinder(UbuntuFallbackToOlderVersionPackageFinder ubuntuPackageFinder) {
            this.ubuntuPackageFinder = ubuntuPackageFinder;
        }

        @Override
        public Optional<Package> packageFor(Distribution distribution) {
            if (distribution.platform().distribution().isPresent()) {
                return Optional.empty();
            }
            Distribution ubuntuLTSFallback = Distribution.of((de.flapdoodle.embed.process.distribution.Version)distribution.version(), (Platform)ImmutablePlatform.copyOf((Platform)distribution.platform()).withVersion((Version)this.fallbackUbuntuVersion));
            LOGGER.warn("because there is no package for " + distribution + " we fall back to " + ubuntuLTSFallback);
            Optional<Package> resolvedPackage = this.ubuntuPackageFinder.packageFor(ubuntuLTSFallback);
            if (!resolvedPackage.isPresent()) {
                throw new IllegalArgumentException("linux distribution not supported: " + distribution + "(with fallback to " + ubuntuLTSFallback + ")");
            }
            return resolvedPackage;
        }

        @Override
        public String explain() {
            return "fallback to " + this.fallbackUbuntuVersion + " using '" + this.ubuntuPackageFinder.label() + "'";
        }
    }
}

