/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.packageresolver.HasPlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.CommonOS;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import java.util.Optional;

public abstract class AbstractPackageFinder
implements PackageFinder,
HasPlatformMatchRules {
    private final Command command;
    private final PackageFinderRules rules;

    public AbstractPackageFinder(Command command, PackageFinderRules rules) {
        this.command = command;
        this.rules = rules;
    }

    @Override
    public final PackageFinderRules rules() {
        return this.rules;
    }

    @Override
    public final Optional<Package> packageFor(Distribution distribution) {
        return this.rules.packageFor(distribution);
    }

    public static PlatformMatch match(OS os, BitSize bitSize, CPUType cpuType, Version ... versions) {
        return PlatformMatch.withOs(os).withBitSize(bitSize).withCpuType(cpuType).withVersion(versions);
    }

    protected static PlatformMatch match(OS os, BitSize bitSize) {
        return PlatformMatch.withOs(os).withBitSize(bitSize);
    }

    protected static PlatformMatch match(BitSize bitSize, CPUType cpuType, Version ... versions) {
        return PlatformMatch.withOs((OS)CommonOS.Linux).withBitSize(bitSize).withCpuType(cpuType).withVersion(versions);
    }
}

