/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.packageresolver.AbstractPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.HasLabel;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.ToolVersionRange;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.CommonOS;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.linux.AmazonVersion;

public class AmazonPackageFinder
extends AbstractPackageFinder
implements HasLabel {
    public AmazonPackageFinder(Command command) {
        super(command, AmazonPackageFinder.rules(command));
    }

    @Override
    public String label() {
        return this.getClass().getSimpleName();
    }

    private static FileSet fileSetOf(Command command) {
        return FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
    }

    private static ImmutablePackageFinderRules rules(Command command) {
        FileSet fileSet = AmazonPackageFinder.fileSetOf(command);
        ImmutablePackageFinderRule devRule_AmazonLinux2023_ARM_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.ARM, new Version[]{AmazonVersion.AmazonLinux2023}).andThen(DistributionMatch.any(VersionRange.of("8.1.0-rc0"), VersionRange.of("8.1.0"), VersionRange.of("8.0.6-rc2"), VersionRange.of("8.0.0-rc9"), VersionRange.of("8.0.0-rc7"), VersionRange.of("8.0.0-rc3"), VersionRange.of("7.3.3-rc0"), VersionRange.of("7.3.0", "7.3.3"), VersionRange.of("7.2.0-rc3"), VersionRange.of("7.1.0", "7.1.1"), VersionRange.of("7.0.18-rc0"), VersionRange.of("7.0.15-rc1"), VersionRange.of("7.0.8-rc0"), VersionRange.of("7.0.3-rc1"), VersionRange.of("7.0.0-rc8"), VersionRange.of("7.0.0-rc2"), VersionRange.of("7.0.0-rc10")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-aarch64-amazon2023-{version}.tgz").isDevVersion(true).build()).build();
        ImmutablePackageFinderRule rule_AmazonLinux2023_ARM_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.ARM, new Version[]{AmazonVersion.AmazonLinux2023}).andThen(DistributionMatch.any(VersionRange.of("8.0.3", "8.0.9"), VersionRange.of("8.0.0", "8.0.1"), VersionRange.of("7.0.14", "7.0.20"), VersionRange.of("7.0.11", "7.0.12"), VersionRange.of("7.0.0", "7.0.9")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-aarch64-amazon2023-{version}.tgz").build()).build();
        ImmutablePackageFinderRule tools_AmazonLinux2023_ARM_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.ARM, new Version[]{AmazonVersion.AmazonLinux2023}).andThen(DistributionMatch.any(ToolVersionRange.of("100.12.0"), ToolVersionRange.of("100.11.0"), ToolVersionRange.of("100.10.0"), ToolVersionRange.of("100.9.0", "100.9.5"), ToolVersionRange.of("100.8.0"), ToolVersionRange.of("100.7.1", "100.7.5")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-amazon2023-aarch64-{tools.version}.tgz").build()).build();
        ImmutablePackageFinderRule devRule_AmazonLinux2023_X86_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{AmazonVersion.AmazonLinux2023}).andThen(DistributionMatch.any(VersionRange.of("8.1.0-rc0"), VersionRange.of("8.1.0"), VersionRange.of("8.0.6-rc2"), VersionRange.of("8.0.0-rc9"), VersionRange.of("8.0.0-rc7"), VersionRange.of("8.0.0-rc3"), VersionRange.of("7.3.3-rc0"), VersionRange.of("7.3.0", "7.3.3"), VersionRange.of("7.2.0-rc3"), VersionRange.of("7.1.0", "7.1.1"), VersionRange.of("7.0.18-rc0"), VersionRange.of("7.0.15-rc1"), VersionRange.of("7.0.8-rc0"), VersionRange.of("7.0.3-rc1"), VersionRange.of("7.0.0-rc8"), VersionRange.of("7.0.0-rc2"), VersionRange.of("7.0.0-rc10")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-amazon2023-{version}.tgz").isDevVersion(true).build()).build();
        ImmutablePackageFinderRule rule_AmazonLinux2023_X86_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{AmazonVersion.AmazonLinux2023}).andThen(DistributionMatch.any(VersionRange.of("8.0.3", "8.0.9"), VersionRange.of("8.0.0", "8.0.1"), VersionRange.of("7.0.14", "7.0.20"), VersionRange.of("7.0.11", "7.0.12"), VersionRange.of("7.0.0", "7.0.9")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-amazon2023-{version}.tgz").build()).build();
        ImmutablePackageFinderRule tools_AmazonLinux2023_X86_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{AmazonVersion.AmazonLinux2023}).andThen(DistributionMatch.any(ToolVersionRange.of("100.12.0"), ToolVersionRange.of("100.11.0"), ToolVersionRange.of("100.10.0"), ToolVersionRange.of("100.9.0", "100.9.5"), ToolVersionRange.of("100.8.0"), ToolVersionRange.of("100.7.1", "100.7.5")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-amazon2023-x86_64-{tools.version}.tgz").build()).build();
        ImmutablePackageFinderRule devRule_AmazonLinux2_ARM_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.ARM, new Version[]{AmazonVersion.AmazonLinux2}).andThen(DistributionMatch.any(VersionRange.of("7.3.3-rc0"), VersionRange.of("7.3.0", "7.3.3"), VersionRange.of("7.2.0-rc3"), VersionRange.of("7.1.0", "7.1.1"), VersionRange.of("7.0.18-rc0"), VersionRange.of("7.0.15-rc1"), VersionRange.of("7.0.8-rc0"), VersionRange.of("7.0.3-rc1"), VersionRange.of("7.0.0-rc8"), VersionRange.of("7.0.0-rc2"), VersionRange.of("7.0.0-rc10"), VersionRange.of("7.0.0-rc1"), VersionRange.of("6.3.1", "6.3.2"), VersionRange.of("6.0.21-rc1"), VersionRange.of("6.0.16-rc0"), VersionRange.of("6.0.9-rc1"), VersionRange.of("5.0.28-rc0"), VersionRange.of("5.0.20-rc1"), VersionRange.of("4.4.27-rc0"), VersionRange.of("4.4.24-rc0")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-aarch64-amazon2-{version}.tgz").isDevVersion(true).build()).build();
        ImmutablePackageFinderRule rule_AmazonLinux2_ARM_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.ARM, new Version[]{AmazonVersion.AmazonLinux2}).andThen(DistributionMatch.any(VersionRange.of("7.0.14", "7.0.20"), VersionRange.of("7.0.11", "7.0.12"), VersionRange.of("7.0.0", "7.0.9"), VersionRange.of("6.0.0", "6.0.23"), VersionRange.of("5.0.0", "5.0.31"), VersionRange.of("4.4.4", "4.4.29"), VersionRange.of("4.2.13", "4.2.25")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-aarch64-amazon2-{version}.tgz").build()).build();
        ImmutablePackageFinderRule tools_AmazonLinux2_ARM_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.ARM, new Version[]{AmazonVersion.AmazonLinux2}).andThen(DistributionMatch.any(ToolVersionRange.of("100.6.0"), ToolVersionRange.of("100.5.0", "100.5.4"), ToolVersionRange.of("100.4.0", "100.4.1"), ToolVersionRange.of("100.3.0", "100.3.1")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-amazon2-arm64-{tools.version}.tgz").build()).build();
        ImmutablePackageFinderRule tools_AmazonLinux2_ARM_B64_1 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.ARM, new Version[]{AmazonVersion.AmazonLinux2}).andThen(DistributionMatch.any(ToolVersionRange.of("100.12.0"), ToolVersionRange.of("100.11.0"), ToolVersionRange.of("100.10.0"), ToolVersionRange.of("100.9.0", "100.9.5"), ToolVersionRange.of("100.8.0"), ToolVersionRange.of("100.7.0", "100.7.5"), ToolVersionRange.of("100.6.1")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-amazon2-aarch64-{tools.version}.tgz").build()).build();
        ImmutablePackageFinderRule devRule_AmazonLinux2_X86_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{AmazonVersion.AmazonLinux2}).andThen(DistributionMatch.any(VersionRange.of("7.3.3-rc0"), VersionRange.of("7.3.0", "7.3.3"), VersionRange.of("7.2.0-rc3"), VersionRange.of("7.1.0", "7.1.1"), VersionRange.of("7.0.18-rc0"), VersionRange.of("7.0.15-rc1"), VersionRange.of("7.0.8-rc0"), VersionRange.of("7.0.3-rc1"), VersionRange.of("7.0.0-rc8"), VersionRange.of("7.0.0-rc2"), VersionRange.of("7.0.0-rc10"), VersionRange.of("7.0.0-rc1"), VersionRange.of("6.3.1", "6.3.2"), VersionRange.of("6.0.21-rc1"), VersionRange.of("6.0.16-rc0"), VersionRange.of("6.0.9-rc1"), VersionRange.of("5.0.28-rc0"), VersionRange.of("5.0.20-rc1"), VersionRange.of("4.4.27-rc0"), VersionRange.of("4.4.24-rc0")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-amazon2-{version}.tgz").isDevVersion(true).build()).build();
        ImmutablePackageFinderRule rule_AmazonLinux2_X86_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{AmazonVersion.AmazonLinux2}).andThen(DistributionMatch.any(VersionRange.of("7.0.14", "7.0.20"), VersionRange.of("7.0.11", "7.0.12"), VersionRange.of("7.0.0", "7.0.9"), VersionRange.of("6.0.0", "6.0.23"), VersionRange.of("5.0.0", "5.0.31"), VersionRange.of("4.4.0", "4.4.29"), VersionRange.of("4.2.5", "4.2.25"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.28"), VersionRange.of("3.6.22", "3.6.23")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-amazon2-{version}.tgz").build()).build();
        ImmutablePackageFinderRule tools_AmazonLinux2_X86_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{AmazonVersion.AmazonLinux2}).andThen(DistributionMatch.any(ToolVersionRange.of("100.12.0"), ToolVersionRange.of("100.11.0"), ToolVersionRange.of("100.10.0"), ToolVersionRange.of("100.9.0", "100.9.5"), ToolVersionRange.of("100.8.0"), ToolVersionRange.of("100.7.0", "100.7.5"), ToolVersionRange.of("100.6.0", "100.6.1"), ToolVersionRange.of("100.5.0", "100.5.4"), ToolVersionRange.of("100.4.0", "100.4.1"), ToolVersionRange.of("100.3.0", "100.3.1"), ToolVersionRange.of("100.2.0", "100.2.1"), ToolVersionRange.of("100.1.0", "100.1.1"), ToolVersionRange.of("100.0.0", "100.0.2"), ToolVersionRange.of("99.0.0")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-amazon2-x86_64-{tools.version}.tgz").build()).build();
        ImmutablePackageFinderRule devRule_AmazonLinux_X86_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{AmazonVersion.AmazonLinux}).andThen(DistributionMatch.any(VersionRange.of("5.0.28-rc0"), VersionRange.of("5.0.20-rc1"), VersionRange.of("4.4.27-rc0"), VersionRange.of("4.4.24-rc0")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-amazon-{version}.tgz").isDevVersion(true).build()).build();
        ImmutablePackageFinderRule rule_AmazonLinux_X86_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{AmazonVersion.AmazonLinux}).andThen(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.31"), VersionRange.of("4.4.0", "4.4.29"), VersionRange.of("4.2.5", "4.2.25"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.28"), VersionRange.of("3.6.0", "3.6.23"), VersionRange.of("3.4.9", "3.4.24"), VersionRange.of("3.4.0", "3.4.7"), VersionRange.of("3.2.0", "3.2.22"), VersionRange.of("3.0.0", "3.0.15")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-amazon-{version}.tgz").build()).build();
        ImmutablePackageFinderRule tools_AmazonLinux_X86_B64 = PackageFinderRule.builder().match(AmazonPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[]{AmazonVersion.AmazonLinux}).andThen(DistributionMatch.any(ToolVersionRange.of("100.12.0"), ToolVersionRange.of("100.11.0"), ToolVersionRange.of("100.10.0"), ToolVersionRange.of("100.9.0", "100.9.5"), ToolVersionRange.of("100.8.0"), ToolVersionRange.of("100.7.0", "100.7.5"), ToolVersionRange.of("100.6.0", "100.6.1"), ToolVersionRange.of("100.5.0", "100.5.4"), ToolVersionRange.of("100.4.0", "100.4.1"), ToolVersionRange.of("100.3.0", "100.3.1"), ToolVersionRange.of("100.2.0", "100.2.1"), ToolVersionRange.of("100.1.0", "100.1.1"), ToolVersionRange.of("100.0.0", "100.0.2"), ToolVersionRange.of("99.0.0")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-amazon-x86_64-{tools.version}.tgz").build()).build();
        switch (command) {
            case MongoDump: 
            case MongoImport: 
            case MongoRestore: {
                return PackageFinderRules.empty().withAdditionalRules(tools_AmazonLinux2023_ARM_B64).withAdditionalRules(tools_AmazonLinux2023_X86_B64).withAdditionalRules(tools_AmazonLinux2_ARM_B64, tools_AmazonLinux2_ARM_B64_1).withAdditionalRules(tools_AmazonLinux2_X86_B64).withAdditionalRules(tools_AmazonLinux_X86_B64).withAdditionalRules(devRule_AmazonLinux2_ARM_B64, rule_AmazonLinux2_ARM_B64).withAdditionalRules(devRule_AmazonLinux2_X86_B64, rule_AmazonLinux2_X86_B64).withAdditionalRules(devRule_AmazonLinux_X86_B64, rule_AmazonLinux_X86_B64);
            }
        }
        return PackageFinderRules.empty().withAdditionalRules(devRule_AmazonLinux2023_ARM_B64, rule_AmazonLinux2023_ARM_B64).withAdditionalRules(devRule_AmazonLinux2023_X86_B64, rule_AmazonLinux2023_X86_B64).withAdditionalRules(devRule_AmazonLinux2_ARM_B64, rule_AmazonLinux2_ARM_B64).withAdditionalRules(devRule_AmazonLinux2_X86_B64, rule_AmazonLinux2_X86_B64).withAdditionalRules(devRule_AmazonLinux_X86_B64, rule_AmazonLinux_X86_B64);
    }
}

