/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.HasMongotoolsPackage;
import de.flapdoodle.embed.mongo.packageresolver.ImmutableToolVersionRange;
import de.flapdoodle.embed.mongo.packageresolver.MongotoolsVersion;
import de.flapdoodle.embed.mongo.packageresolver.NumericVersion;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Version;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ToolVersionRange
implements DistributionMatch {
    @Value.Parameter
    abstract NumericVersion min();

    @Value.Parameter
    abstract NumericVersion max();

    @Value.Check
    protected void check() {
        if (this.min().compareTo(this.max()) > 0) {
            throw new IllegalArgumentException(this.min() + " > " + this.max());
        }
    }

    @Override
    @Value.Auxiliary
    public boolean match(Distribution distribution) {
        return this.match(distribution.version());
    }

    @Value.Auxiliary
    public boolean match(Version version) {
        Optional<MongotoolsVersion.Main> toolsVersion;
        if (version instanceof HasMongotoolsPackage && (toolsVersion = ((HasMongotoolsPackage)version).mongotoolsVersion()).isPresent()) {
            NumericVersion asNumeric = NumericVersion.of(toolsVersion.get().asInDownloadPath());
            return this.min().isOlderOrEqual(asNumeric) && asNumeric.isOlderOrEqual(this.max());
        }
        return false;
    }

    public static ToolVersionRange of(NumericVersion min, NumericVersion max) {
        return ImmutableToolVersionRange.of(min, max);
    }

    public static ToolVersionRange of(String min, String max) {
        return ToolVersionRange.of(NumericVersion.of(min), NumericVersion.of(max));
    }

    public static ToolVersionRange of(String minMax) {
        return ToolVersionRange.of(NumericVersion.of(minMax), NumericVersion.of(minMax));
    }
}

