/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.spring.autoconfigure;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import de.flapdoodle.embed.mongo.commands.ServerAddress;
import de.flapdoodle.embed.mongo.spring.autoconfigure.AbstractServerFactory;
import de.flapdoodle.embed.mongo.spring.autoconfigure.MongoClientAction;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;

public class ReactiveClientServerFactory
extends AbstractServerFactory<MongoClient> {
    private static Logger logger = LoggerFactory.getLogger(ReactiveClientServerFactory.class);

    ReactiveClientServerFactory(MongoProperties properties) {
        super(properties);
        logger.info("reactive server factory");
    }

    @Override
    protected Document resultOfAction(MongoClient client, MongoClientAction.Action action) {
        if (action instanceof MongoClientAction.RunCommand) {
            return (Document)ReactiveClientServerFactory.get(client.getDatabase(action.database()).runCommand((Bson)((MongoClientAction.RunCommand)action).command()));
        }
        throw new IllegalArgumentException("Action not supported: " + action);
    }

    @Override
    protected MongoClient client(ServerAddress serverAddress) {
        return MongoClients.create((String)("mongodb://" + serverAddress));
    }

    @Override
    protected MongoClient client(ServerAddress serverAddress, MongoCredential credential) {
        return MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyConnectionString(new ConnectionString("mongodb://" + serverAddress)).credential(credential).build());
    }

    private static <T> T get(Publisher<T> publisher) {
        final CompletableFuture result = new CompletableFuture();
        publisher.subscribe(new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                s.request(1L);
            }

            public void onNext(T t) {
                result.complete(t);
            }

            public void onError(Throwable t) {
                result.completeExceptionally(t);
            }

            public void onComplete() {
            }
        });
        try {
            return result.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

