/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.runtime;

import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.config.SupportConfig;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.runtime.NUMA;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Mongod {
    private static Logger logger = Logger.getLogger(Mongod.class.getName());
    static final byte[] SHUTDOWN_COMMAND = new byte[]{71, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, -44, 7, 0, 0, 0, 0, 0, 0, 97, 100, 109, 105, 110, 46, 36, 99, 109, 100, 0, 0, 0, 0, 0, -1, -1, -1, -1, 27, 0, 0, 0, 16, 115, 104, 117, 116, 100, 111, 119, 110, 0, 1, 0, 0, 0, 8, 102, 111, 114, 99, 101, 0, 1, 0, 5, 0, 0, 0, 0};
    public static final int SOCKET_TIMEOUT = 2000;
    public static final int CONNECT_TIMEOUT = 2000;
    public static final int BYTE_BUFFER_LENGTH = 512;
    public static final int WAITING_TIME_SHUTDOWN_IN_MS = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sendShutdown(InetAddress hostname, int port) {
        if (!hostname.isLoopbackAddress()) {
            logger.log(Level.WARNING, "---------------------------------------\nYour localhost (" + hostname.getHostAddress() + ") is not a loopback adress\n" + "We can NOT send shutdown to mongod, because it is denied from remote." + "---------------------------------------\n");
            return false;
        }
        boolean tryToReadErrorResponse = false;
        Socket s = new Socket();
        try {
            s.setSoTimeout(2000);
            s.connect(new InetSocketAddress(hostname, port), 2000);
            OutputStream outputStream = s.getOutputStream();
            outputStream.write(SHUTDOWN_COMMAND);
            outputStream.flush();
            tryToReadErrorResponse = true;
            InputStream inputStream = s.getInputStream();
            if (inputStream.read(new byte[512]) != -1) {
                logger.severe("Got some response, should be an error message");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iox) {
            logger.log(Level.WARNING, "sendShutdown", iox);
            if (tryToReadErrorResponse) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            try {
                s.close();
                Thread.sleep(100L);
            }
            catch (InterruptedException ix) {
                logger.log(Level.WARNING, "sendShutdown", ix);
            }
            catch (IOException iox) {
                logger.log(Level.WARNING, "sendShutdown", iox);
            }
        }
        return false;
    }

    public static int getMongodProcessId(String output, int defaultValue) {
        Pattern pattern = Pattern.compile("MongoDB starting : pid=([1234567890]+) port", 8);
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            String value = matcher.group(1);
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    public static List<String> getCommandLine(MongodConfig config, File mongodExecutable, File dbDir) throws UnknownHostException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(Arrays.asList(mongodExecutable.getAbsolutePath(), "-v", "--port", "" + config.getPort(), "--dbpath", "" + dbDir.getAbsolutePath(), "--noprealloc", "--nohttpinterface", "--smallfiles", "--nojournal", "--noauth"));
        if (config.isIpv6()) {
            ret.add("--ipv6");
        }
        return ret;
    }

    public static List<String> enhanceCommandLinePlattformSpecific(Distribution distribution, List<String> commands) {
        if (NUMA.isNUMA((ISupportConfig)SupportConfig.getInstance(), (Platform)distribution.getPlatform())) {
            switch (distribution.getPlatform()) {
                case Linux: {
                    ArrayList<String> ret = new ArrayList<String>();
                    ret.add("numactl");
                    ret.add("--interleave=all");
                    ret.addAll(commands);
                    return ret;
                }
            }
            logger.warning("NUMA Plattform detected, but not supported.");
        }
        return commands;
    }
}

