/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.DownloadConfig;
import de.flapdoodle.embed.mongo.config.MongodProcessOutputConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.extract.UUIDTempNaming;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import de.flapdoodle.embed.process.io.progress.LoggingProgressListener;
import de.flapdoodle.embed.process.runtime.ICommandLinePostProcessor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuntimeConfig
implements IRuntimeConfig {
    private ITempNaming defaultfileNaming;
    private ITempNaming executableNaming;
    private ProcessOutput mongodOutputConfig;
    private ICommandLinePostProcessor commandLinePostProcessor;
    private DownloadConfig downloadConfig;

    public RuntimeConfig() {
        this.executableNaming = this.defaultfileNaming = new UUIDTempNaming();
        this.mongodOutputConfig = MongodProcessOutputConfig.getDefaultInstance();
        this.commandLinePostProcessor = new ICommandLinePostProcessor.Noop();
        this.downloadConfig = new DownloadConfig();
    }

    public ITempNaming getDefaultfileNaming() {
        return this.defaultfileNaming;
    }

    public void setDefaultfileNaming(ITempNaming defaultfileNaming) {
        this.defaultfileNaming = defaultfileNaming;
    }

    public ITempNaming getExecutableNaming() {
        return this.executableNaming;
    }

    public void setExecutableNaming(ITempNaming executableNaming) {
        this.executableNaming = executableNaming;
    }

    public ProcessOutput getProcessOutput() {
        return this.mongodOutputConfig;
    }

    public void setProcessOutput(ProcessOutput mongodOutputConfig) {
        this.mongodOutputConfig = mongodOutputConfig;
    }

    public void setCommandLinePostProcessor(ICommandLinePostProcessor commandLinePostProcessor) {
        this.commandLinePostProcessor = commandLinePostProcessor;
    }

    public ICommandLinePostProcessor getCommandLinePostProcessor() {
        return this.commandLinePostProcessor;
    }

    public DownloadConfig getDownloadConfig() {
        return this.downloadConfig;
    }

    public static RuntimeConfig getInstance(Logger logger) {
        RuntimeConfig ret = new RuntimeConfig();
        ret.setProcessOutput(MongodProcessOutputConfig.getInstance(logger));
        ret.getDownloadConfig().setProgressListener((IProgressListener)new LoggingProgressListener(logger, Level.FINE));
        return ret;
    }
}

