/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.tests;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.config.RuntimeConfig;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.logging.Logger;

public class MongodForTestsFactory {
    private static Logger logger = Logger.getLogger(MongodForTestsFactory.class.getName());
    private final MongodExecutable mongodExecutable;
    private final MongodProcess mongodProcess;

    public static MongodForTestsFactory with(IVersion version) throws IOException {
        return new MongodForTestsFactory(version);
    }

    public MongodForTestsFactory() throws IOException {
        this(Version.Main.V2_0);
    }

    public MongodForTestsFactory(IVersion version) throws IOException {
        MongodStarter runtime = MongodStarter.getInstance(RuntimeConfig.getInstance(logger));
        this.mongodExecutable = (MongodExecutable)runtime.prepare(new MongodConfig(version, Network.getFreeServerPort(), Network.localhostIsIPv6()));
        this.mongodProcess = (MongodProcess)((Object)this.mongodExecutable.start());
    }

    public Mongo newMongo() throws UnknownHostException, MongoException {
        return new Mongo(new ServerAddress(Network.getLocalHost(), ((MongodConfig)this.mongodProcess.getConfig()).getPort()));
    }

    public DB newDB(Mongo mongo) {
        return mongo.getDB(UUID.randomUUID().toString());
    }

    public void shutdown() {
        this.mongodProcess.stop();
        this.mongodExecutable.cleanup();
    }
}

