/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo;

import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.config.SupportConfig;
import de.flapdoodle.embed.mongo.runtime.Mongod;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.LogWatchStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.runtime.AbstractProcess;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MongodProcess
extends AbstractProcess<MongodConfig, MongodExecutable, MongodProcess> {
    private static Logger logger = Logger.getLogger(MongodProcess.class.getName());
    public static final int TIMEOUT = 20000;
    private File dbDir;
    boolean dbDirIsTemp;
    private boolean stopped = false;

    public MongodProcess(Distribution distribution, MongodConfig config, IRuntimeConfig runtimeConfig, MongodExecutable mongodExecutable) throws IOException {
        super(distribution, (ExecutableProcessConfig)config, runtimeConfig, (Executable)mongodExecutable);
    }

    protected void onBeforeProcess(IRuntimeConfig runtimeConfig) throws IOException {
        File tmpDbDir;
        super.onBeforeProcess(runtimeConfig);
        MongodConfig config = (MongodConfig)this.getConfig();
        if (config.getDatabaseDir() != null) {
            tmpDbDir = Files.createOrCheckDir((String)config.getDatabaseDir());
        } else {
            tmpDbDir = Files.createTempDir((String)"embedmongo-db");
            this.dbDirIsTemp = true;
        }
        this.dbDir = tmpDbDir;
    }

    protected void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        ProcessOutput outputConfig = runtimeConfig.getProcessOutput();
        LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor("waiting for connections on port", "failed", StreamToLineProcessor.wrap((IStreamProcessor)outputConfig.getOutput()));
        Processors.connect((Reader)process.getReader(), (IStreamProcessor)logWatch);
        Processors.connect((Reader)process.getError(), (IStreamProcessor)StreamToLineProcessor.wrap((IStreamProcessor)outputConfig.getError()));
        logWatch.waitForResult(20000L);
        if (!logWatch.isInitWithSuccess()) {
            throw new IOException("Could not start mongod process");
        }
        this.setProcessId(Mongod.getMongodProcessId(logWatch.getOutput(), -1));
    }

    protected ISupportConfig supportConfig() {
        return SupportConfig.getInstance();
    }

    protected List<String> getCommandLine(Distribution distribution, MongodConfig config, File exe) throws IOException {
        return Mongod.enhanceCommandLinePlattformSpecific(distribution, Mongod.getCommandLine((MongodConfig)this.getConfig(), exe, this.dbDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        MongodProcess mongodProcess = this;
        synchronized (mongodProcess) {
            if (!this.stopped) {
                this.stopped = true;
                logger.info("try to stop mongod");
                if (!this.sendStopToMongoInstance()) {
                    logger.warning("could not stop mongod with db command, try next");
                    if (!this.sendKillToProcess()) {
                        logger.warning("could not stop mongod, try next");
                        if (!this.tryKillToProcess()) {
                            logger.warning("could not stop mongod the second time, try one last thing");
                        }
                    }
                }
                this.stopProcess();
                if (this.dbDir != null && this.dbDirIsTemp && !Files.forceDelete((File)this.dbDir)) {
                    logger.warning("Could not delete temp db dir: " + this.dbDir);
                }
            }
        }
    }

    private boolean sendStopToMongoInstance() {
        try {
            return Mongod.sendShutdown(((MongodConfig)this.getConfig()).getServerAddress(), ((MongodConfig)this.getConfig()).getPort());
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "sendStop", e);
            return false;
        }
    }
}

