/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MongodConfig
extends ExecutableProcessConfig {
    private final String bindIp;
    private final int port;
    private final String databaseDir;
    private final boolean ipv6;

    public MongodConfig(IVersion version) throws UnknownHostException, IOException {
        this(version, null, Network.getFreeServerPort(), Network.localhostIsIPv6(), null);
    }

    public MongodConfig(IVersion version, int port, boolean ipv6) {
        this(version, null, port, ipv6, null);
    }

    @Deprecated
    public MongodConfig(IVersion version, int port, boolean ipv6, String databaseDir) {
        this(version, null, port, ipv6, databaseDir);
    }

    public MongodConfig(IVersion version, String bindIp, int port, boolean ipv6, String databaseDir) {
        super(version);
        this.bindIp = bindIp;
        this.port = port;
        this.ipv6 = ipv6;
        this.databaseDir = databaseDir;
    }

    public String getBindIp() {
        return this.bindIp;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isIpv6() {
        return this.ipv6;
    }

    public String getDatabaseDir() {
        return this.databaseDir;
    }

    public InetAddress getServerAddress() throws UnknownHostException {
        if (this.bindIp != null) {
            return InetAddress.getByName(this.bindIp);
        }
        return Network.getLocalHost();
    }
}

