/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class AbstractMongoConfig
extends ExecutableProcessConfig {
    protected final Net network;
    protected final Timeout timeout;

    public AbstractMongoConfig(IVersion version, Net networt, Timeout timeout) {
        super(version);
        this.network = networt;
        this.timeout = timeout;
    }

    public Net net() {
        return this.network;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public static class Timeout {
        private final long startupTimeout;

        public Timeout() {
            this(20000L);
        }

        public Timeout(long startupTimeout) {
            this.startupTimeout = startupTimeout;
        }

        public long getStartupTimeout() {
            return this.startupTimeout;
        }
    }

    public static class Net {
        private final String bindIp;
        private final int port;
        private final boolean ipv6;

        public Net() throws UnknownHostException, IOException {
            this(null, Network.getFreeServerPort(), Network.localhostIsIPv6());
        }

        public Net(int port, boolean ipv6) {
            this(null, port, ipv6);
        }

        public Net(String bindIp, int port, boolean ipv6) {
            this.bindIp = bindIp;
            this.port = port;
            this.ipv6 = ipv6;
        }

        public String getBindIp() {
            return this.bindIp;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isIpv6() {
            return this.ipv6;
        }

        public InetAddress getServerAddress() throws UnknownHostException {
            if (this.bindIp != null) {
                return InetAddress.getByName(this.bindIp);
            }
            return Network.getLocalHost();
        }
    }

    public static class Storage {
        private final int oplogSize;
        private final String replSetName;
        private final String databaseDir;

        public Storage() {
            this(null, null, 0);
        }

        public Storage(String databaseDir, String replSetName, int oplogSize) {
            this.databaseDir = databaseDir;
            this.replSetName = replSetName;
            this.oplogSize = oplogSize;
        }

        public int getOplogSize() {
            return this.oplogSize;
        }

        public String getReplSetName() {
            return this.replSetName;
        }

        public String getDatabaseDir() {
            return this.databaseDir;
        }
    }
}

