/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.runtime;

import de.flapdoodle.embed.mongo.config.MongosConfig;
import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class Mongos {
    private static Logger logger = Logger.getLogger(Mongos.class.getName());

    public static List<String> getCommandLine(MongosConfig config, File mongosExecutable) throws UnknownHostException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(Arrays.asList(mongosExecutable.getAbsolutePath(), "-v", "--port", "" + config.net().getPort(), "--nohttpinterface", "--chunkSize", "1"));
        if (config.net().isIpv6()) {
            ret.add("--ipv6");
        }
        if (config.net().getBindIp() != null) {
            ret.add("--bind_ip");
            ret.add(config.net().getBindIp());
        }
        if (config.getConfigDB() != null) {
            ret.add("--configdb");
            ret.add(config.getConfigDB());
        }
        return ret;
    }
}

