/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.tests;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.AbstractMongoConfig;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.config.RuntimeConfig;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.distribution.IVersion;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.logging.Logger;

public class MongodForTestsFactory {
    private static Logger logger = Logger.getLogger(MongodForTestsFactory.class.getName());
    private final MongodExecutable mongodExecutable;
    private final MongodProcess mongodProcess;

    public static MongodForTestsFactory with(IVersion version) throws IOException {
        return new MongodForTestsFactory(version);
    }

    public MongodForTestsFactory() throws IOException {
        this(Version.Main.PRODUCTION);
    }

    public MongodForTestsFactory(IVersion version) throws IOException {
        MongodStarter runtime = MongodStarter.getInstance(RuntimeConfig.getInstance(logger));
        this.mongodExecutable = (MongodExecutable)runtime.prepare(this.newMongodConfig(version));
        this.mongodProcess = (MongodProcess)this.mongodExecutable.start();
    }

    protected MongodConfig newMongodConfig(IVersion version) throws UnknownHostException, IOException {
        return new MongodConfig(version, new AbstractMongoConfig.Net(), new AbstractMongoConfig.Storage(), new AbstractMongoConfig.Timeout());
    }

    public Mongo newMongo() throws UnknownHostException, MongoException {
        return new Mongo(new ServerAddress(((MongodConfig)this.mongodProcess.getConfig()).net().getServerAddress(), ((MongodConfig)this.mongodProcess.getConfig()).net().getPort()));
    }

    public DB newDB(Mongo mongo) {
        return mongo.getDB(UUID.randomUUID().toString());
    }

    public void shutdown() {
        this.mongodProcess.stop();
        this.mongodExecutable.stop();
    }
}

