/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.tests;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.MongosExecutable;
import de.flapdoodle.embed.mongo.MongosProcess;
import de.flapdoodle.embed.mongo.MongosStarter;
import de.flapdoodle.embed.mongo.config.AbstractMongoConfig;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.config.MongosConfig;
import de.flapdoodle.embed.mongo.config.MongosRuntimeConfig;
import de.flapdoodle.embed.mongo.config.RuntimeConfig;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.logging.Logger;

public class MongosForTestsFactory {
    private static Logger logger = Logger.getLogger(MongosForTestsFactory.class.getName());
    private final MongodExecutable mongoConfigExecutable;
    private final MongodProcess mongoConfigProcess;
    private final MongosExecutable mongosExecutable;
    private final MongosProcess mongosProcess;

    public static MongosForTestsFactory with(IVersion version) throws IOException {
        return new MongosForTestsFactory(version);
    }

    public MongosForTestsFactory() throws IOException {
        this(Version.Main.V2_0);
    }

    public MongosForTestsFactory(IVersion version) throws IOException {
        MongodStarter mongoConfigRuntime = MongodStarter.getInstance(RuntimeConfig.getInstance(logger));
        int configServerPort = 27019;
        int mongosPort = 27017;
        this.mongoConfigExecutable = (MongodExecutable)mongoConfigRuntime.prepare(MongodConfig.getConfigInstance(version, new AbstractMongoConfig.Net(configServerPort, Network.localhostIsIPv6())));
        this.mongoConfigProcess = (MongodProcess)this.mongoConfigExecutable.start();
        MongosStarter runtime = MongosStarter.getInstance(MongosRuntimeConfig.getInstance(logger));
        this.mongosExecutable = (MongosExecutable)runtime.prepare(new MongosConfig(version, new AbstractMongoConfig.Net(mongosPort, Network.localhostIsIPv6()), new AbstractMongoConfig.Timeout(), Network.getLocalHost().getHostName() + ":" + configServerPort));
        this.mongosProcess = (MongosProcess)this.mongosExecutable.start();
    }

    public Mongo newMongo() throws UnknownHostException, MongoException {
        return new Mongo(new ServerAddress(((MongosConfig)this.mongosProcess.getConfig()).net().getServerAddress(), ((MongosConfig)this.mongosProcess.getConfig()).net().getPort()));
    }

    public DB newDB(Mongo mongo) {
        return mongo.getDB(UUID.randomUUID().toString());
    }

    public void shutdown() {
        this.mongosProcess.stop();
        this.mongosExecutable.stop();
    }
}

