/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.tests;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongosExecutable;
import de.flapdoodle.embed.mongo.MongosProcess;
import de.flapdoodle.embed.mongo.MongosStarter;
import de.flapdoodle.embed.mongo.config.AbstractMongoConfig;
import de.flapdoodle.embed.mongo.config.MongosConfig;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.logging.Logger;

public class MongosForTestsFactory {
    private static Logger logger = Logger.getLogger(MongosForTestsFactory.class.getName());
    private final MongosExecutable mongoConfigExecutable;
    private final MongosProcess mongoConfigProcess;
    private final MongosExecutable mongosExecutable;
    private final MongosProcess mongosProcess;

    public static MongosForTestsFactory with(IVersion version) throws IOException {
        return new MongosForTestsFactory(version);
    }

    public MongosForTestsFactory() throws IOException {
        this(Version.Main.PRODUCTION);
    }

    public MongosForTestsFactory(IVersion version) throws IOException {
        MongosStarter mongoConfigRuntime = MongosStarter.getInstance(new RuntimeConfigBuilder().defaultsWithLogger(Command.MongoS, logger).build());
        int configServerPort = 27019;
        int mongosPort = 27017;
        this.mongoConfigExecutable = (MongosExecutable)mongoConfigRuntime.prepare(MongosConfig.getConfigInstance(version, new AbstractMongoConfig.Net(configServerPort, Network.localhostIsIPv6()), "testDB"));
        this.mongoConfigProcess = (MongosProcess)this.mongoConfigExecutable.start();
        MongosStarter runtime = MongosStarter.getInstance(new RuntimeConfigBuilder().defaultsWithLogger(Command.MongoS, logger).build());
        this.mongosExecutable = (MongosExecutable)runtime.prepare(new MongosConfig(version, new AbstractMongoConfig.Net(mongosPort, Network.localhostIsIPv6()), new AbstractMongoConfig.Timeout(), Network.getLocalHost().getHostName() + ":" + configServerPort));
        this.mongosProcess = (MongosProcess)this.mongosExecutable.start();
    }

    public Mongo newMongo() throws UnknownHostException, MongoException {
        return new Mongo(new ServerAddress(((MongosConfig)this.mongosProcess.getConfig()).net().getServerAddress(), ((MongosConfig)this.mongosProcess.getConfig()).net().getPort()));
    }

    public DB newDB(Mongo mongo) {
        return mongo.getDB(UUID.randomUUID().toString());
    }

    public void shutdown() {
        this.mongosProcess.stop();
        this.mongosExecutable.stop();
    }
}

