/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo;

import de.flapdoodle.embed.mongo.AbstractMongoProcess;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.config.SupportConfig;
import de.flapdoodle.embed.mongo.runtime.Mongod;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.directories.PropertyOrPlatformTempDir;
import de.flapdoodle.embed.process.io.file.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

public class MongodProcess
extends AbstractMongoProcess<MongodConfig, MongodExecutable, MongodProcess> {
    private static Logger logger = Logger.getLogger(MongodProcess.class.getName());
    private File dbDir;
    boolean dbDirIsTemp;

    public MongodProcess(Distribution distribution, MongodConfig config, IRuntimeConfig runtimeConfig, MongodExecutable mongodExecutable) throws IOException {
        super(distribution, config, runtimeConfig, mongodExecutable);
    }

    protected void onBeforeProcess(IRuntimeConfig runtimeConfig) throws IOException {
        File tmpDbDir;
        super.onBeforeProcess(runtimeConfig);
        MongodConfig config = (MongodConfig)this.getConfig();
        if (config.replication().getDatabaseDir() != null) {
            tmpDbDir = Files.createOrCheckDir((String)config.replication().getDatabaseDir());
        } else {
            tmpDbDir = Files.createTempDir((IDirectory)PropertyOrPlatformTempDir.defaultInstance(), (String)"embedmongo-db");
            this.dbDirIsTemp = true;
        }
        this.dbDir = tmpDbDir;
    }

    protected ISupportConfig supportConfig() {
        return new SupportConfig(Command.MongoD);
    }

    protected List<String> getCommandLine(Distribution distribution, MongodConfig config, File exe) throws IOException {
        return Mongod.enhanceCommandLinePlattformSpecific(distribution, Mongod.getCommandLine((MongodConfig)this.getConfig(), exe, this.dbDir));
    }

    @Override
    protected void deleteTempFiles() {
        super.deleteTempFiles();
        if (this.dbDir != null && this.dbDirIsTemp && !Files.forceDelete((File)this.dbDir)) {
            logger.warning("Could not delete temp db dir: " + this.dbDir);
        }
    }
}

