/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.AbstractMongoConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import java.io.IOException;
import java.net.UnknownHostException;

public class MongodConfig
extends AbstractMongoConfig {
    private final AbstractMongoConfig.Storage storage;
    private final boolean configServer;

    public MongodConfig(IVersion version) throws UnknownHostException, IOException {
        this(version, new AbstractMongoConfig.Net(), new AbstractMongoConfig.Storage(), new AbstractMongoConfig.Timeout());
    }

    public MongodConfig(IVersion version, int port, boolean ipv6) {
        this(version, new AbstractMongoConfig.Net(null, port, ipv6), new AbstractMongoConfig.Storage(), new AbstractMongoConfig.Timeout());
    }

    @Deprecated
    public MongodConfig(IVersion version, int port, boolean ipv6, String databaseDir) {
        this(version, new AbstractMongoConfig.Net(null, port, ipv6), new AbstractMongoConfig.Storage(databaseDir, null, 0), new AbstractMongoConfig.Timeout());
    }

    @Deprecated
    public MongodConfig(IVersion version, String bindIp, int port, boolean ipv6, String databaseDir, String replSetName, int oplogSize) {
        this(version, new AbstractMongoConfig.Net(bindIp, port, ipv6), new AbstractMongoConfig.Storage(databaseDir, replSetName, oplogSize), new AbstractMongoConfig.Timeout());
    }

    public static MongodConfig getConfigInstance(IVersion version, AbstractMongoConfig.Net network) {
        return new MongodConfig(version, network, new AbstractMongoConfig.Storage(), new AbstractMongoConfig.Timeout(), true);
    }

    public MongodConfig(IVersion version, AbstractMongoConfig.Net network, AbstractMongoConfig.Storage storage, AbstractMongoConfig.Timeout timeout) {
        this(version, network, storage, timeout, false);
    }

    public MongodConfig(IVersion version, AbstractMongoConfig.Net network, AbstractMongoConfig.Storage storage, AbstractMongoConfig.Timeout timeout, boolean configServer) {
        super(version, network, timeout);
        this.storage = storage;
        this.configServer = configServer;
    }

    public AbstractMongoConfig.Storage replication() {
        return this.storage;
    }

    public boolean isConfigServer() {
        return this.configServer;
    }

    @Deprecated
    public String getBindIp() {
        return this.network.getBindIp();
    }

    @Deprecated
    public int getPort() {
        return this.network.getPort();
    }

    @Deprecated
    public boolean isIpv6() {
        return this.network.isIpv6();
    }
}

