/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.AbstractMongoConfigBuilder;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.Storage;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.process.builder.TypedProperty;
import de.flapdoodle.embed.process.distribution.IVersion;
import java.io.IOException;
import java.net.UnknownHostException;

public class MongodConfigBuilder
extends AbstractMongoConfigBuilder<IMongodConfig> {
    protected static final TypedProperty<Storage> REPLICATION = TypedProperty.with((String)"Replication", Storage.class);
    protected static final TypedProperty<Boolean> CONFIG_SERVER = TypedProperty.with((String)"ConfigServer", Boolean.class);

    public MongodConfigBuilder() throws UnknownHostException, IOException {
        this.property(REPLICATION).setDefault((Object)new Storage());
        this.property(CONFIG_SERVER).setDefault((Object)false);
    }

    public MongodConfigBuilder version(IVersion version) {
        this.version().set((Object)version);
        return this;
    }

    public MongodConfigBuilder timeout(Timeout timeout) {
        this.timeout().set((Object)timeout);
        return this;
    }

    public MongodConfigBuilder net(Net net) {
        this.net().set((Object)net);
        return this;
    }

    public MongodConfigBuilder replication(Storage replication) {
        this.set(REPLICATION, replication);
        return this;
    }

    public MongodConfigBuilder configServer(boolean configServer) {
        this.set(CONFIG_SERVER, configServer);
        return this;
    }

    public IMongodConfig build() {
        IVersion version = (IVersion)this.version().get();
        Net net = (Net)this.net().get();
        Timeout timeout = (Timeout)this.timeout().get();
        Storage replication = (Storage)this.get(REPLICATION);
        boolean configServer = (Boolean)this.get(CONFIG_SERVER);
        return new ImmutableMongodConfig(version, net, timeout, replication, configServer);
    }

    static class ImmutableMongodConfig
    extends AbstractMongoConfigBuilder.ImmutableMongoConfig
    implements IMongodConfig {
        private final Storage _replication;
        private final boolean _configServer;

        public ImmutableMongodConfig(IVersion version, Net net, Timeout timeout, Storage replication, boolean configServer) {
            super(version, net, timeout);
            this._replication = replication;
            this._configServer = configServer;
        }

        @Override
        public Storage replication() {
            return this._replication;
        }

        @Override
        public boolean isConfigServer() {
            return this._configServer;
        }
    }
}

