/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.AbstractMongoConfigBuilder;
import de.flapdoodle.embed.mongo.config.IMongosConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.process.builder.TypedProperty;
import de.flapdoodle.embed.process.distribution.IVersion;
import java.io.IOException;
import java.net.UnknownHostException;

public class MongosConfigBuilder
extends AbstractMongoConfigBuilder<IMongosConfig> {
    protected static final TypedProperty<String> CONFIG_DB = TypedProperty.with((String)"ConfigDB", String.class);

    public MongosConfigBuilder version(IVersion version) {
        this.version().set((Object)version);
        return this;
    }

    public MongosConfigBuilder timeout(Timeout timeout) {
        this.timeout().set((Object)timeout);
        return this;
    }

    public MongosConfigBuilder net(Net net) {
        this.net().set((Object)net);
        return this;
    }

    public MongosConfigBuilder configDB(String configDB) {
        this.set(CONFIG_DB, configDB);
        return this;
    }

    public IMongosConfig build() {
        IVersion version = (IVersion)this.version().get();
        Net net = (Net)this.net().get();
        Timeout timeout = (Timeout)this.timeout().get();
        String configDB = (String)this.get(CONFIG_DB);
        return new ImmutableMongosConfig(version, net, timeout, configDB);
    }

    static class ImmutableMongosConfig
    extends AbstractMongoConfigBuilder.ImmutableMongoConfig
    implements IMongosConfig {
        private final String _configDB;

        public ImmutableMongosConfig(IVersion version, Net net, Timeout timeout, String configDB) {
            super(version, net, timeout);
            this._configDB = configDB;
        }

        @Override
        public String getConfigDB() {
            return this._configDB;
        }
    }
}

