/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.builder.TypedProperty;

public class MongoCmdOptionsBuilder
extends AbstractBuilder<IMongoCmdOptions> {
    protected static final TypedProperty<Integer> SYNC_DELAY = TypedProperty.with((String)"syncDelay", Integer.class);

    public MongoCmdOptionsBuilder() {
        this.property(SYNC_DELAY).setDefault((Object)0);
    }

    public MongoCmdOptionsBuilder syncDeplay(int deplay) {
        this.set(SYNC_DELAY, deplay);
        return this;
    }

    public MongoCmdOptionsBuilder defaultSyncDeplay() {
        this.set(SYNC_DELAY, null);
        return this;
    }

    public IMongoCmdOptions build() {
        Integer syncDelay = (Integer)this.get(SYNC_DELAY, null);
        return new MongoCmdOptions(syncDelay);
    }

    static class MongoCmdOptions
    implements IMongoCmdOptions {
        private final Integer _syncDelay;

        public MongoCmdOptions(Integer syncDelay) {
            this._syncDelay = syncDelay;
        }

        @Override
        public Integer syncDelay() {
            return this._syncDelay;
        }
    }
}

