/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.AbstractMongoConfigBuilder;
import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.Storage;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.mongo.config.processlistener.IMongoProcessListener;
import de.flapdoodle.embed.mongo.config.processlistener.NoopProcessListener;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.builder.TypedProperty;
import java.io.IOException;
import java.net.UnknownHostException;

public class MongodConfigBuilder
extends AbstractMongoConfigBuilder<IMongodConfig> {
    protected static final TypedProperty<Storage> REPLICATION = TypedProperty.with((String)"Replication", Storage.class);
    protected static final TypedProperty<Boolean> CONFIG_SERVER = TypedProperty.with((String)"ConfigServer", Boolean.class);
    protected static final TypedProperty<IMongoProcessListener> PROCESS_LISTENER = TypedProperty.with((String)"ProcessListener", IMongoProcessListener.class);

    public MongodConfigBuilder() throws UnknownHostException, IOException {
        this.property(REPLICATION).setDefault((Object)new Storage());
        this.property(CONFIG_SERVER).setDefault((Object)false);
        this.property(PROCESS_LISTENER).setDefault((Object)new NoopProcessListener());
        this.property(PID_FILE).setDefault((Object)"mongod.pid");
    }

    public MongodConfigBuilder version(IFeatureAwareVersion version) {
        this.version().set((Object)version);
        return this;
    }

    public MongodConfigBuilder timeout(Timeout timeout) {
        this.timeout().set((Object)timeout);
        return this;
    }

    public MongodConfigBuilder net(Net net) {
        this.net().set((Object)net);
        return this;
    }

    public MongodConfigBuilder cmdOptions(IMongoCmdOptions cmdOptions) {
        this.cmdOptions().set((Object)cmdOptions);
        return this;
    }

    public MongodConfigBuilder replication(Storage replication) {
        this.set(REPLICATION, replication);
        return this;
    }

    public MongodConfigBuilder configServer(boolean configServer) {
        this.set(CONFIG_SERVER, configServer);
        return this;
    }

    public MongodConfigBuilder processListener(IMongoProcessListener processListener) {
        this.set(PROCESS_LISTENER, processListener);
        return this;
    }

    public IMongodConfig build() {
        IFeatureAwareVersion version = (IFeatureAwareVersion)this.version().get();
        Net net = (Net)this.net().get();
        Timeout timeout = (Timeout)this.timeout().get();
        Storage replication = (Storage)this.get(REPLICATION);
        boolean configServer = (Boolean)this.get(CONFIG_SERVER);
        IMongoCmdOptions cmdOptions = (IMongoCmdOptions)this.get(CMD_OPTIONS);
        IMongoProcessListener processListener = (IMongoProcessListener)this.get(PROCESS_LISTENER);
        String pidFile = (String)this.get(PID_FILE);
        return new ImmutableMongodConfig(version, net, timeout, cmdOptions, pidFile, replication, configServer, processListener);
    }

    static class ImmutableMongodConfig
    extends AbstractMongoConfigBuilder.ImmutableMongoConfig
    implements IMongodConfig {
        private final Storage _replication;
        private final boolean _configServer;
        private final IMongoProcessListener _processListener;

        public ImmutableMongodConfig(IFeatureAwareVersion version, Net net, Timeout timeout, IMongoCmdOptions cmdOptions, String pidFile, Storage replication, boolean configServer, IMongoProcessListener processListener) {
            super(version, net, timeout, cmdOptions, pidFile);
            this._replication = replication;
            this._configServer = configServer;
            this._processListener = processListener;
        }

        @Override
        public Storage replication() {
            return this._replication;
        }

        @Override
        public boolean isConfigServer() {
            return this._configServer;
        }

        @Override
        public IMongoProcessListener processListener() {
            return this._processListener;
        }
    }
}

