/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.builder.TypedProperty;

public class MongoCmdOptionsBuilder
extends AbstractBuilder<IMongoCmdOptions> {
    protected static final TypedProperty<Integer> SYNC_DELAY = TypedProperty.with((String)"syncDelay", Integer.class);
    protected static final TypedProperty<Boolean> VERBOSE = TypedProperty.with((String)"verbose", Boolean.class);

    public MongoCmdOptionsBuilder() {
        this.property(SYNC_DELAY).setDefault((Object)0);
        this.property(VERBOSE).setDefault((Object)false);
    }

    public MongoCmdOptionsBuilder syncDeplay(int deplay) {
        this.set(SYNC_DELAY, deplay);
        return this;
    }

    public MongoCmdOptionsBuilder verbose(boolean verbose) {
        this.set(VERBOSE, verbose);
        return this;
    }

    public MongoCmdOptionsBuilder defaultSyncDeplay() {
        this.set(SYNC_DELAY, null);
        return this;
    }

    public IMongoCmdOptions build() {
        Integer syncDelay = (Integer)this.get(SYNC_DELAY, null);
        boolean verbose = (Boolean)this.get(VERBOSE);
        return new MongoCmdOptions(syncDelay, verbose);
    }

    static class MongoCmdOptions
    implements IMongoCmdOptions {
        private final Integer _syncDelay;
        private final boolean _verbose;

        public MongoCmdOptions(Integer syncDelay, boolean verbose) {
            this._syncDelay = syncDelay;
            this._verbose = verbose;
        }

        @Override
        public Integer syncDelay() {
            return this._syncDelay;
        }

        @Override
        public boolean isVerbose() {
            return this._verbose;
        }
    }
}

