/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.tests;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.MongosExecutable;
import de.flapdoodle.embed.mongo.MongosProcess;
import de.flapdoodle.embed.mongo.MongosStarter;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.IMongosConfig;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class MongosSystemForTestFactory {
    private static final Logger logger = Logger.getLogger(MongosSystemForTestFactory.class.getName());
    public static final String ADMIN_DATABASE_NAME = "admin";
    public static final String LOCAL_DATABASE_NAME = "local";
    public static final String REPLICA_SET_NAME = "rep1";
    public static final String OPLOG_COLLECTION = "oplog.rs";
    private final IMongosConfig config;
    private final Map<String, List<IMongodConfig>> replicaSets;
    private final List<IMongodConfig> configServers;
    private final String shardDatabase;
    private final String shardCollection;
    private final String shardKey;
    private MongosExecutable mongosExecutable;
    private MongosProcess mongosProcess;
    private List<MongodProcess> mongodProcessList;
    private List<MongodProcess> mongodConfigProcessList;

    public MongosSystemForTestFactory(IMongosConfig config, Map<String, List<IMongodConfig>> replicaSets, List<IMongodConfig> configServers, String shardDatabase, String shardCollection, String shardKey) {
        this.config = config;
        this.replicaSets = replicaSets;
        this.configServers = configServers;
        this.shardDatabase = shardDatabase;
        this.shardCollection = shardCollection;
        this.shardKey = shardKey;
    }

    public void start() throws Throwable {
        this.mongodProcessList = new ArrayList<MongodProcess>();
        this.mongodConfigProcessList = new ArrayList<MongodProcess>();
        for (Map.Entry<String, List<IMongodConfig>> entry : this.replicaSets.entrySet()) {
            this.initializeReplicaSet(entry);
        }
        for (IMongodConfig config : this.configServers) {
            this.initializeConfigServer(config);
        }
        this.initializeMongos();
        this.configureMongos();
    }

    private void initializeReplicaSet(Map.Entry<String, List<IMongodConfig>> entry) throws Exception {
        String replicaName = entry.getKey();
        List<IMongodConfig> mongoConfigList = entry.getValue();
        if (mongoConfigList.size() < 3) {
            throw new Exception("A replica set must contain at least 3 members.");
        }
        for (IMongodConfig mongoConfig : mongoConfigList) {
            if (!mongoConfig.replication().getReplSetName().equals(replicaName)) {
                throw new Exception("Replica set name must match in mongo configuration");
            }
            MongodStarter starter = MongodStarter.getDefaultInstance();
            MongodExecutable mongodExe = (MongodExecutable)starter.prepare(mongoConfig);
            MongodProcess process = (MongodProcess)mongodExe.start();
            this.mongodProcessList.add(process);
        }
        Thread.sleep(1000L);
        MongoClientOptions mo = MongoClientOptions.builder().autoConnectRetry(true).build();
        MongoClient mongo = new MongoClient(new ServerAddress(mongoConfigList.get(0).net().getServerAddress().getHostName(), mongoConfigList.get(0).net().getPort()), mo);
        DB mongoAdminDB = mongo.getDB(ADMIN_DATABASE_NAME);
        CommandResult cr = mongoAdminDB.command((DBObject)new BasicDBObject("isMaster", (Object)1));
        logger.info("isMaster: " + cr);
        BasicDBObject replicaSetSetting = new BasicDBObject();
        replicaSetSetting.put("_id", (Object)replicaName);
        BasicDBList members = new BasicDBList();
        int i = 0;
        for (IMongodConfig mongoConfig : mongoConfigList) {
            BasicDBObject host = new BasicDBObject();
            host.put("_id", (Object)i++);
            host.put("host", (Object)(mongoConfig.net().getServerAddress().getHostName() + ":" + mongoConfig.net().getPort()));
            members.add((Object)host);
        }
        replicaSetSetting.put("members", (Object)members);
        logger.info(replicaSetSetting.toString());
        cr = mongoAdminDB.command((DBObject)new BasicDBObject("replSetInitiate", (Object)replicaSetSetting));
        logger.info("replSetInitiate: " + cr);
        Thread.sleep(5000L);
        cr = mongoAdminDB.command((DBObject)new BasicDBObject("replSetGetStatus", (Object)1));
        logger.info("replSetGetStatus: " + cr);
        while (!this.isReplicaSetStarted((BasicDBObject)cr)) {
            logger.info("Waiting for 3 seconds...");
            Thread.sleep(1000L);
            cr = mongoAdminDB.command((DBObject)new BasicDBObject("replSetGetStatus", (Object)1));
            logger.info("replSetGetStatus: " + cr);
        }
        mongo.close();
        mongo = null;
    }

    private boolean isReplicaSetStarted(BasicDBObject setting) {
        if (setting.get("members") == null) {
            return false;
        }
        BasicDBList members = (BasicDBList)setting.get("members");
        for (Object m : members.toArray()) {
            BasicDBObject member = (BasicDBObject)m;
            logger.info(member.toString());
            int state = member.getInt("state");
            logger.info("state: " + state);
            if (state == 1 || state == 2 || state == 7) continue;
            return false;
        }
        return true;
    }

    private void initializeConfigServer(IMongodConfig config) throws Exception {
        if (!config.isConfigServer()) {
            throw new Exception("Mongo configuration is not a defined for a config server.");
        }
        MongodStarter starter = MongodStarter.getDefaultInstance();
        MongodExecutable mongodExe = (MongodExecutable)starter.prepare(config);
        MongodProcess process = (MongodProcess)mongodExe.start();
        this.mongodProcessList.add(process);
    }

    private void initializeMongos() throws Exception {
        MongosStarter runtime = MongosStarter.getInstance(new RuntimeConfigBuilder().defaultsWithLogger(Command.MongoS, logger).build());
        this.mongosExecutable = (MongosExecutable)runtime.prepare(this.config);
        this.mongosProcess = (MongosProcess)this.mongosExecutable.start();
    }

    private void configureMongos() throws Exception {
        CommandResult cr;
        MongoOptions mo = new MongoOptions();
        mo.autoConnectRetry = true;
        Mongo mongo = new Mongo(new ServerAddress(this.config.net().getServerAddress().getHostName(), this.config.net().getPort()), mo);
        DB mongoAdminDB = mongo.getDB(ADMIN_DATABASE_NAME);
        for (Map.Entry<String, List<IMongodConfig>> entry : this.replicaSets.entrySet()) {
            String replicaName = entry.getKey();
            String command = "";
            for (IMongodConfig mongodConfig : entry.getValue()) {
                command = command.isEmpty() ? replicaName + "/" : command + ",";
                command = command + mongodConfig.net().getServerAddress().getHostName() + ":" + mongodConfig.net().getPort();
            }
            logger.info("Execute add shard command: " + command);
            cr = mongoAdminDB.command((DBObject)new BasicDBObject("addShard", (Object)command));
            logger.info(cr.toString());
        }
        logger.info("Execute list shards.");
        cr = mongoAdminDB.command((DBObject)new BasicDBObject("listShards", (Object)1));
        logger.info(cr.toString());
        logger.info("Enabled sharding at database level");
        cr = mongoAdminDB.command((DBObject)new BasicDBObject("enableSharding", (Object)this.shardDatabase));
        logger.info(cr.toString());
        logger.info("Create index in sharded collection");
        DB db = mongo.getDB(this.shardDatabase);
        db.getCollection(this.shardCollection).ensureIndex(this.shardKey);
        logger.info("Shard the collection: " + this.shardDatabase + "." + this.shardCollection);
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("shardCollection", (Object)(this.shardDatabase + "." + this.shardCollection));
        cmd.put("key", (Object)new BasicDBObject(this.shardKey, (Object)1));
        cr = mongoAdminDB.command((DBObject)cmd);
        logger.info(cr.toString());
        logger.info("Get info from config/shards");
        DBCursor cursor = mongo.getDB("config").getCollection("shards").find();
        while (cursor.hasNext()) {
            DBObject item = cursor.next();
            logger.info(item.toString());
        }
    }

    public Mongo getMongo() throws UnknownHostException, MongoException {
        return new Mongo(new ServerAddress(((IMongosConfig)this.mongosProcess.getConfig()).net().getServerAddress(), ((IMongosConfig)this.mongosProcess.getConfig()).net().getPort()));
    }

    public void stop() {
        for (MongodProcess process : this.mongodProcessList) {
            process.stop();
        }
        for (MongodProcess process : this.mongodConfigProcessList) {
            process.stop();
        }
        this.mongosProcess.stop();
    }
}

