/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo;

import de.flapdoodle.embed.mongo.config.IMongoConfig;
import de.flapdoodle.embed.mongo.runtime.Mongod;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.LogWatchStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.runtime.AbstractProcess;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.IStopable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.IOException;
import java.io.Reader;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractMongoProcess<T extends IMongoConfig, E extends Executable<T, P>, P extends IStopable>
extends AbstractProcess<T, E, P> {
    private static Logger logger = Logger.getLogger(AbstractMongoProcess.class.getName());
    boolean stopped = false;

    public AbstractMongoProcess(Distribution distribution, T config, IRuntimeConfig runtimeConfig, E executable) throws IOException {
        super(distribution, config, runtimeConfig, executable);
    }

    protected final void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        ProcessOutput outputConfig = runtimeConfig.getProcessOutput();
        LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor(this.successMessage(), this.knownFailureMessages(), StreamToLineProcessor.wrap((IStreamProcessor)outputConfig.getOutput()));
        Processors.connect((Reader)process.getReader(), (IStreamProcessor)logWatch);
        Processors.connect((Reader)process.getError(), (IStreamProcessor)StreamToLineProcessor.wrap((IStreamProcessor)outputConfig.getError()));
        logWatch.waitForResult(((IMongoConfig)this.getConfig()).timeout().getStartupTimeout());
        if (!logWatch.isInitWithSuccess()) {
            String failureFound = logWatch.getFailureFound();
            if (failureFound == null) {
                failureFound = "\n----------------------\nHmm.. no failure message.. \n...the cause must be somewhere in the process output\n----------------------\n" + logWatch.getOutput();
            }
            throw new IOException("Could not start process: " + failureFound);
        }
        this.setProcessId(Mongod.getMongodProcessId(logWatch.getOutput(), -1));
    }

    protected String successMessage() {
        return "waiting for connections on port";
    }

    private Set<String> knownFailureMessages() {
        HashSet<String> ret = new HashSet<String>();
        ret.add("failed errno");
        ret.add("ERROR:");
        ret.add("error command line");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopInternal() {
        AbstractMongoProcess abstractMongoProcess = this;
        synchronized (abstractMongoProcess) {
            if (!this.stopped) {
                this.stopped = true;
                logger.fine("try to stop mongod");
                if (!this.sendStopToMongoInstance()) {
                    logger.warning("could not stop mongod with db command, try next");
                    if (!this.sendKillToProcess()) {
                        logger.warning("could not stop mongod, try next");
                        if (!this.tryKillToProcess()) {
                            logger.warning("could not stop mongod the second time, try one last thing");
                        }
                    }
                }
                this.stopProcess();
            }
        }
    }

    protected void cleanupInternal() {
        this.deleteTempFiles();
    }

    protected void deleteTempFiles() {
    }

    protected final boolean sendStopToMongoInstance() {
        try {
            return Mongod.sendShutdown(((IMongoConfig)this.getConfig()).net().getServerAddress(), ((IMongoConfig)this.getConfig()).net().getPort());
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "sendStop", e);
            return false;
        }
    }
}

