/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.config.AbstractMongoConfigBuilder;
import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.mongo.config.IMongoShellConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.SupportConfig;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.builder.TypedProperty;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MongoShellConfigBuilder
extends AbstractMongoConfigBuilder<IMongoShellConfig> {
    protected static final TypedProperty<String> JS_SCRIPT = TypedProperty.with((String)"scriptName", String.class);
    protected static final TypedProperty<List> JS_SCRIPT_PARAMETERS = TypedProperty.with((String)"parameters", List.class);

    public MongoShellConfigBuilder() throws UnknownHostException, IOException {
        this.property(PID_FILE).setDefault((Object)"mongo.pid");
    }

    public MongoShellConfigBuilder version(IFeatureAwareVersion version) {
        this.version().set((Object)version);
        return this;
    }

    public MongoShellConfigBuilder timeout(Timeout timeout) {
        this.timeout().set((Object)timeout);
        return this;
    }

    public MongoShellConfigBuilder net(Net net) {
        this.net().set((Object)net);
        return this;
    }

    public MongoShellConfigBuilder cmdOptions(IMongoCmdOptions cmdOptions) {
        this.cmdOptions().set((Object)cmdOptions);
        return this;
    }

    public MongoShellConfigBuilder scriptName(String scriptName) {
        this.set(JS_SCRIPT, scriptName);
        return this;
    }

    public MongoShellConfigBuilder parameters(String ... parameters) {
        return this.parameters(Arrays.asList(parameters));
    }

    public MongoShellConfigBuilder parameters(List<String> parameters) {
        this.set(JS_SCRIPT_PARAMETERS, parameters);
        return this;
    }

    public IMongoShellConfig build() {
        IFeatureAwareVersion version = (IFeatureAwareVersion)this.version().get();
        Net net = (Net)this.net().get();
        Timeout timeout = (Timeout)this.timeout().get();
        IMongoCmdOptions cmdOptions = (IMongoCmdOptions)this.get(CMD_OPTIONS);
        String pidFile = (String)this.get(PID_FILE);
        String name = (String)this.get(JS_SCRIPT, null);
        List parameters = (List)this.get(JS_SCRIPT_PARAMETERS, new ArrayList());
        if (name == null && parameters.isEmpty()) {
            throw new RuntimeException("you must set parameters or scriptName");
        }
        return new ImmutableMongoShellConfig(version, net, timeout, cmdOptions, pidFile, name, parameters);
    }

    static class ImmutableMongoShellConfig
    extends AbstractMongoConfigBuilder.ImmutableMongoConfig
    implements IMongoShellConfig {
        private final String _name;
        private final List<String> _parameters;

        public ImmutableMongoShellConfig(IFeatureAwareVersion version, Net net, Timeout timeout, IMongoCmdOptions cmdOptions, String pidFile, String scriptName, List<String> parameters) {
            super(new SupportConfig(Command.Mongo), version, net, timeout, cmdOptions, pidFile);
            this._name = scriptName;
            this._parameters = Collections.unmodifiableList(new ArrayList<String>(parameters));
        }

        @Override
        public List<String> getScriptParameters() {
            return this._parameters;
        }

        @Override
        public String getScriptName() {
            return this._name;
        }
    }
}

