/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.runtime;

import de.flapdoodle.embed.mongo.config.IMongoImportConfig;
import de.flapdoodle.embed.mongo.runtime.AbstractMongo;
import de.flapdoodle.embed.mongo.runtime.Mongos;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class MongoImport
extends AbstractMongo {
    private static Logger logger = Logger.getLogger(Mongos.class.getName());

    public static List<String> getCommandLine(IMongoImportConfig config, IExtractedFileSet files) throws UnknownHostException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(Arrays.asList(files.executable().getAbsolutePath()));
        if (config.cmdOptions().isVerbose()) {
            ret.add("-v");
        }
        MongoImport.applyNet(config.net(), ret);
        if (config.getDatabaseName() != null) {
            ret.add("--db");
            ret.add(config.getDatabaseName());
        }
        if (config.getCollectionName() != null) {
            ret.add("--collection");
            ret.add(config.getCollectionName());
        }
        if (config.isJsonArray()) {
            ret.add("--jsonArray");
        }
        if (config.isDropCollection()) {
            ret.add("--drop");
        }
        if (config.isUpsertDocuments()) {
            ret.add("--upsert");
        }
        if (config.getImportFile() != null) {
            ret.add("--file");
            ret.add(config.getImportFile());
        }
        return ret;
    }
}

