/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.tests;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodForTestsFactory {
    private static Logger logger = LoggerFactory.getLogger((String)MongodForTestsFactory.class.getName());
    private final MongodExecutable mongodExecutable;
    private final MongodProcess mongodProcess;

    public static MongodForTestsFactory with(IFeatureAwareVersion version) throws IOException {
        return new MongodForTestsFactory(version);
    }

    public MongodForTestsFactory() throws IOException {
        this(Version.Main.PRODUCTION);
    }

    public MongodForTestsFactory(IFeatureAwareVersion version) throws IOException {
        MongodStarter runtime = MongodStarter.getInstance(new RuntimeConfigBuilder().defaultsWithLogger(Command.MongoD, logger).build());
        this.mongodExecutable = (MongodExecutable)runtime.prepare(this.newMongodConfig(version));
        this.mongodProcess = (MongodProcess)this.mongodExecutable.start();
    }

    protected IMongodConfig newMongodConfig(IFeatureAwareVersion version) throws UnknownHostException, IOException {
        return new MongodConfigBuilder().version(version).build();
    }

    public MongoClient newMongo() throws UnknownHostException, MongoException {
        return new MongoClient(new ServerAddress(((IMongodConfig)this.mongodProcess.getConfig()).net().getServerAddress(), ((IMongodConfig)this.mongodProcess.getConfig()).net().getPort()));
    }

    public DB newDB(Mongo mongo) {
        return mongo.getDB(UUID.randomUUID().toString());
    }

    public void shutdown() {
        this.mongodProcess.stop();
        this.mongodExecutable.stop();
    }
}

