package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.processlistener.IMongoProcessListener;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.SupportConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongodConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongodConfig.builder()}.
 */
@Generated(from = "MongodConfig", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableMongodConfig implements MongodConfig {
  private final Long stopTimeoutInMillis;
  private final IFeatureAwareVersion version;
  private final Timeout timeout;
  private final Net net;
  private final MongoCmdOptions cmdOptions;
  private final String password;
  private final String userName;
  private final Storage replication;
  private final boolean isConfigServer;
  private final boolean isShardServer;
  private final IMongoProcessListener processListener;
  private final Map<String, String> params;
  private final Map<String, String> args;
  private final String pidFile;
  private final SupportConfig supportConfig;

  private ImmutableMongodConfig(ImmutableMongodConfig.Builder builder) {
    this.stopTimeoutInMillis = builder.stopTimeoutInMillis;
    this.version = builder.version;
    this.params = createUnmodifiableMap(false, false, builder.params);
    this.args = createUnmodifiableMap(false, false, builder.args);
    if (builder.timeout != null) {
      initShim.timeout(builder.timeout);
    }
    if (builder.net != null) {
      initShim.net(builder.net);
    }
    if (builder.cmdOptions != null) {
      initShim.cmdOptions(builder.cmdOptions);
    }
    if (builder.password != null) {
      initShim.password(builder.password);
    }
    if (builder.userName != null) {
      initShim.userName(builder.userName);
    }
    if (builder.replication != null) {
      initShim.replication(builder.replication);
    }
    if (builder.isConfigServerIsSet()) {
      initShim.isConfigServer(builder.isConfigServer);
    }
    if (builder.isShardServerIsSet()) {
      initShim.isShardServer(builder.isShardServer);
    }
    if (builder.processListener != null) {
      initShim.processListener(builder.processListener);
    }
    if (builder.pidFile != null) {
      initShim.pidFile(builder.pidFile);
    }
    if (builder.supportConfig != null) {
      initShim.supportConfig(builder.supportConfig);
    }
    this.timeout = initShim.timeout();
    this.net = initShim.net();
    this.cmdOptions = initShim.cmdOptions();
    this.password = initShim.password();
    this.userName = initShim.userName();
    this.replication = initShim.replication();
    this.isConfigServer = initShim.isConfigServer();
    this.isShardServer = initShim.isShardServer();
    this.processListener = initShim.processListener();
    this.pidFile = initShim.pidFile();
    this.supportConfig = initShim.supportConfig();
    this.initShim = null;
  }

  private ImmutableMongodConfig(
      Long stopTimeoutInMillis,
      IFeatureAwareVersion version,
      Timeout timeout,
      Net net,
      MongoCmdOptions cmdOptions,
      String password,
      String userName,
      Storage replication,
      boolean isConfigServer,
      boolean isShardServer,
      IMongoProcessListener processListener,
      Map<String, String> params,
      Map<String, String> args,
      String pidFile,
      SupportConfig supportConfig) {
    this.stopTimeoutInMillis = stopTimeoutInMillis;
    this.version = version;
    this.timeout = timeout;
    this.net = net;
    this.cmdOptions = cmdOptions;
    this.password = password;
    this.userName = userName;
    this.replication = replication;
    this.isConfigServer = isConfigServer;
    this.isShardServer = isShardServer;
    this.processListener = processListener;
    this.params = params;
    this.args = args;
    this.pidFile = pidFile;
    this.supportConfig = supportConfig;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MongodConfig", generator = "Immutables")
  private final class InitShim {
    private byte timeoutBuildStage = STAGE_UNINITIALIZED;
    private Timeout timeout;

    Timeout timeout() {
      if (timeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (timeoutBuildStage == STAGE_UNINITIALIZED) {
        timeoutBuildStage = STAGE_INITIALIZING;
        this.timeout = Objects.requireNonNull(timeoutInitialize(), "timeout");
        timeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.timeout;
    }

    void timeout(Timeout timeout) {
      this.timeout = timeout;
      timeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte netBuildStage = STAGE_UNINITIALIZED;
    private Net net;

    Net net() {
      if (netBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (netBuildStage == STAGE_UNINITIALIZED) {
        netBuildStage = STAGE_INITIALIZING;
        this.net = Objects.requireNonNull(netInitialize(), "net");
        netBuildStage = STAGE_INITIALIZED;
      }
      return this.net;
    }

    void net(Net net) {
      this.net = net;
      netBuildStage = STAGE_INITIALIZED;
    }

    private byte cmdOptionsBuildStage = STAGE_UNINITIALIZED;
    private MongoCmdOptions cmdOptions;

    MongoCmdOptions cmdOptions() {
      if (cmdOptionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (cmdOptionsBuildStage == STAGE_UNINITIALIZED) {
        cmdOptionsBuildStage = STAGE_INITIALIZING;
        this.cmdOptions = Objects.requireNonNull(cmdOptionsInitialize(), "cmdOptions");
        cmdOptionsBuildStage = STAGE_INITIALIZED;
      }
      return this.cmdOptions;
    }

    void cmdOptions(MongoCmdOptions cmdOptions) {
      this.cmdOptions = cmdOptions;
      cmdOptionsBuildStage = STAGE_INITIALIZED;
    }

    private byte passwordBuildStage = STAGE_UNINITIALIZED;
    private String password;

    String password() {
      if (passwordBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (passwordBuildStage == STAGE_UNINITIALIZED) {
        passwordBuildStage = STAGE_INITIALIZING;
        this.password = Objects.requireNonNull(passwordInitialize(), "password");
        passwordBuildStage = STAGE_INITIALIZED;
      }
      return this.password;
    }

    void password(String password) {
      this.password = password;
      passwordBuildStage = STAGE_INITIALIZED;
    }

    private byte userNameBuildStage = STAGE_UNINITIALIZED;
    private String userName;

    String userName() {
      if (userNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (userNameBuildStage == STAGE_UNINITIALIZED) {
        userNameBuildStage = STAGE_INITIALIZING;
        this.userName = Objects.requireNonNull(userNameInitialize(), "userName");
        userNameBuildStage = STAGE_INITIALIZED;
      }
      return this.userName;
    }

    void userName(String userName) {
      this.userName = userName;
      userNameBuildStage = STAGE_INITIALIZED;
    }

    private byte replicationBuildStage = STAGE_UNINITIALIZED;
    private Storage replication;

    Storage replication() {
      if (replicationBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (replicationBuildStage == STAGE_UNINITIALIZED) {
        replicationBuildStage = STAGE_INITIALIZING;
        this.replication = Objects.requireNonNull(replicationInitialize(), "replication");
        replicationBuildStage = STAGE_INITIALIZED;
      }
      return this.replication;
    }

    void replication(Storage replication) {
      this.replication = replication;
      replicationBuildStage = STAGE_INITIALIZED;
    }

    private byte isConfigServerBuildStage = STAGE_UNINITIALIZED;
    private boolean isConfigServer;

    boolean isConfigServer() {
      if (isConfigServerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isConfigServerBuildStage == STAGE_UNINITIALIZED) {
        isConfigServerBuildStage = STAGE_INITIALIZING;
        this.isConfigServer = isConfigServerInitialize();
        isConfigServerBuildStage = STAGE_INITIALIZED;
      }
      return this.isConfigServer;
    }

    void isConfigServer(boolean isConfigServer) {
      this.isConfigServer = isConfigServer;
      isConfigServerBuildStage = STAGE_INITIALIZED;
    }

    private byte isShardServerBuildStage = STAGE_UNINITIALIZED;
    private boolean isShardServer;

    boolean isShardServer() {
      if (isShardServerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isShardServerBuildStage == STAGE_UNINITIALIZED) {
        isShardServerBuildStage = STAGE_INITIALIZING;
        this.isShardServer = isShardServerInitialize();
        isShardServerBuildStage = STAGE_INITIALIZED;
      }
      return this.isShardServer;
    }

    void isShardServer(boolean isShardServer) {
      this.isShardServer = isShardServer;
      isShardServerBuildStage = STAGE_INITIALIZED;
    }

    private byte processListenerBuildStage = STAGE_UNINITIALIZED;
    private IMongoProcessListener processListener;

    IMongoProcessListener processListener() {
      if (processListenerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (processListenerBuildStage == STAGE_UNINITIALIZED) {
        processListenerBuildStage = STAGE_INITIALIZING;
        this.processListener = Objects.requireNonNull(processListenerInitialize(), "processListener");
        processListenerBuildStage = STAGE_INITIALIZED;
      }
      return this.processListener;
    }

    void processListener(IMongoProcessListener processListener) {
      this.processListener = processListener;
      processListenerBuildStage = STAGE_INITIALIZED;
    }

    private byte pidFileBuildStage = STAGE_UNINITIALIZED;
    private String pidFile;

    String pidFile() {
      if (pidFileBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pidFileBuildStage == STAGE_UNINITIALIZED) {
        pidFileBuildStage = STAGE_INITIALIZING;
        this.pidFile = Objects.requireNonNull(pidFileInitialize(), "pidFile");
        pidFileBuildStage = STAGE_INITIALIZED;
      }
      return this.pidFile;
    }

    void pidFile(String pidFile) {
      this.pidFile = pidFile;
      pidFileBuildStage = STAGE_INITIALIZED;
    }

    private byte supportConfigBuildStage = STAGE_UNINITIALIZED;
    private SupportConfig supportConfig;

    SupportConfig supportConfig() {
      if (supportConfigBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (supportConfigBuildStage == STAGE_UNINITIALIZED) {
        supportConfigBuildStage = STAGE_INITIALIZING;
        this.supportConfig = Objects.requireNonNull(supportConfigInitialize(), "supportConfig");
        supportConfigBuildStage = STAGE_INITIALIZED;
      }
      return this.supportConfig;
    }

    void supportConfig(SupportConfig supportConfig) {
      this.supportConfig = supportConfig;
      supportConfigBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (timeoutBuildStage == STAGE_INITIALIZING) attributes.add("timeout");
      if (netBuildStage == STAGE_INITIALIZING) attributes.add("net");
      if (cmdOptionsBuildStage == STAGE_INITIALIZING) attributes.add("cmdOptions");
      if (passwordBuildStage == STAGE_INITIALIZING) attributes.add("password");
      if (userNameBuildStage == STAGE_INITIALIZING) attributes.add("userName");
      if (replicationBuildStage == STAGE_INITIALIZING) attributes.add("replication");
      if (isConfigServerBuildStage == STAGE_INITIALIZING) attributes.add("isConfigServer");
      if (isShardServerBuildStage == STAGE_INITIALIZING) attributes.add("isShardServer");
      if (processListenerBuildStage == STAGE_INITIALIZING) attributes.add("processListener");
      if (pidFileBuildStage == STAGE_INITIALIZING) attributes.add("pidFile");
      if (supportConfigBuildStage == STAGE_INITIALIZING) attributes.add("supportConfig");
      return "Cannot build MongodConfig, attribute initializers form cycle " + attributes;
    }
  }

  private Timeout timeoutInitialize() {
    return MongodConfig.super.timeout();
  }

  private Net netInitialize() {
    return MongodConfig.super.net();
  }

  private MongoCmdOptions cmdOptionsInitialize() {
    return MongodConfig.super.cmdOptions();
  }

  private String passwordInitialize() {
    return MongodConfig.super.password();
  }

  private String userNameInitialize() {
    return MongodConfig.super.userName();
  }

  private Storage replicationInitialize() {
    return MongodConfig.super.replication();
  }

  private boolean isConfigServerInitialize() {
    return MongodConfig.super.isConfigServer();
  }

  private boolean isShardServerInitialize() {
    return MongodConfig.super.isShardServer();
  }

  private IMongoProcessListener processListenerInitialize() {
    return MongodConfig.super.processListener();
  }

  private String pidFileInitialize() {
    return MongodConfig.super.pidFile();
  }

  private SupportConfig supportConfigInitialize() {
    return MongodConfig.super.supportConfig();
  }

  /**
   * @return The value of the {@code stopTimeoutInMillis} attribute
   */
  @Override
  public OptionalLong stopTimeoutInMillis() {
    return stopTimeoutInMillis != null
        ? OptionalLong.of(stopTimeoutInMillis)
        : OptionalLong.empty();
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @Override
  public IFeatureAwareVersion version() {
    return version;
  }

  /**
   * @return The value of the {@code timeout} attribute
   */
  @Override
  public Timeout timeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.timeout()
        : this.timeout;
  }

  /**
   * @return The value of the {@code net} attribute
   */
  @Override
  public Net net() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.net()
        : this.net;
  }

  /**
   * @return The value of the {@code cmdOptions} attribute
   */
  @Override
  public MongoCmdOptions cmdOptions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.cmdOptions()
        : this.cmdOptions;
  }

  /**
   * @return The value of the {@code password} attribute
   */
  @Override
  public String password() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.password()
        : this.password;
  }

  /**
   * @return The value of the {@code userName} attribute
   */
  @Override
  public String userName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.userName()
        : this.userName;
  }

  /**
   * @return The value of the {@code replication} attribute
   */
  @Override
  public Storage replication() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.replication()
        : this.replication;
  }

  /**
   * @return The value of the {@code isConfigServer} attribute
   */
  @Override
  public boolean isConfigServer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isConfigServer()
        : this.isConfigServer;
  }

  /**
   * @return The value of the {@code isShardServer} attribute
   */
  @Override
  public boolean isShardServer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isShardServer()
        : this.isShardServer;
  }

  /**
   * @return The value of the {@code processListener} attribute
   */
  @Override
  public IMongoProcessListener processListener() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.processListener()
        : this.processListener;
  }

  /**
   * @return The value of the {@code params} attribute
   */
  @Override
  public Map<String, String> params() {
    return params;
  }

  /**
   * @return The value of the {@code args} attribute
   */
  @Override
  public Map<String, String> args() {
    return args;
  }

  /**
   * @return The value of the {@code pidFile} attribute
   */
  @Override
  public String pidFile() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.pidFile()
        : this.pidFile;
  }

  /**
   * @return The value of the {@code supportConfig} attribute
   */
  @Override
  public SupportConfig supportConfig() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.supportConfig()
        : this.supportConfig;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongodConfig#stopTimeoutInMillis() stopTimeoutInMillis} attribute.
   * @param value The value for stopTimeoutInMillis
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongodConfig withStopTimeoutInMillis(long value) {
    Long newValue = value;
    if (Objects.equals(this.stopTimeoutInMillis, newValue)) return this;
    return new ImmutableMongodConfig(
        newValue,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.processListener,
        this.params,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongodConfig#stopTimeoutInMillis() stopTimeoutInMillis} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for stopTimeoutInMillis
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongodConfig withStopTimeoutInMillis(OptionalLong optional) {
    Long value = optional.isPresent() ? optional.getAsLong() : null;
    if (Objects.equals(this.stopTimeoutInMillis, value)) return this;
    return new ImmutableMongodConfig(
        value,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.processListener,
        this.params,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodConfig#version() version} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodConfig withVersion(IFeatureAwareVersion value) {
    if (this.version == value) return this;
    IFeatureAwareVersion newValue = Objects.requireNonNull(value, "version");
    return new ImmutableMongodConfig(
        this.stopTimeoutInMillis,
        newValue,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.processListener,
        this.params,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodConfig#timeout() timeout} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timeout
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodConfig withTimeout(Timeout value) {
    if (this.timeout == value) return this;
    Timeout newValue = Objects.requireNonNull(value, "timeout");
    return new ImmutableMongodConfig(
        this.stopTimeoutInMillis,
        this.version,
        newValue,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.processListener,
        this.params,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodConfig#net() net} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for net
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodConfig withNet(Net value) {
    if (this.net == value) return this;
    Net newValue = Objects.requireNonNull(value, "net");
    return new ImmutableMongodConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        newValue,
        this.cmdOptions,
        this.password,
        this.userName,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.processListener,
        this.params,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodConfig#cmdOptions() cmdOptions} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cmdOptions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodConfig withCmdOptions(MongoCmdOptions value) {
    if (this.cmdOptions == value) return this;
    MongoCmdOptions newValue = Objects.requireNonNull(value, "cmdOptions");
    return new ImmutableMongodConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        newValue,
        this.password,
        this.userName,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.processListener,
        this.params,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodConfig#password() password} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for password
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodConfig withPassword(String value) {
    String newValue = Objects.requireNonNull(value, "password");
    if (this.password.equals(newValue)) return this;
    return new ImmutableMongodConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        newValue,
        this.userName,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.processListener,
        this.params,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodConfig#userName() userName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodConfig withUserName(String value) {
    String newValue = Objects.requireNonNull(value, "userName");
    if (this.userName.equals(newValue)) return this;
    return new ImmutableMongodConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        newValue,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.processListener,
        this.params,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodConfig#replication() replication} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for replication
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodConfig withReplication(Storage value) {
    if (this.replication == value) return this;
    Storage newValue = Objects.requireNonNull(value, "replication");
    return new ImmutableMongodConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        newValue,
        this.isConfigServer,
        this.isShardServer,
        this.processListener,
        this.params,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodConfig#isConfigServer() isConfigServer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isConfigServer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodConfig withIsConfigServer(boolean value) {
    if (this.isConfigServer == value) return this;
    return new ImmutableMongodConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.replication,
        value,
        this.isShardServer,
        this.processListener,
        this.params,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodConfig#isShardServer() isShardServer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isShardServer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodConfig withIsShardServer(boolean value) {
    if (this.isShardServer == value) return this;
    return new ImmutableMongodConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.replication,
        this.isConfigServer,
        value,
        this.processListener,
        this.params,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodConfig#processListener() processListener} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processListener
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodConfig withProcessListener(IMongoProcessListener value) {
    if (this.processListener == value) return this;
    IMongoProcessListener newValue = Objects.requireNonNull(value, "processListener");
    return new ImmutableMongodConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        newValue,
        this.params,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by replacing the {@link MongodConfig#params() params} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the params map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongodConfig withParams(Map<String, ? extends String> entries) {
    if (this.params == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableMongodConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.processListener,
        newValue,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by replacing the {@link MongodConfig#args() args} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the args map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongodConfig withArgs(Map<String, ? extends String> entries) {
    if (this.args == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableMongodConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.processListener,
        this.params,
        newValue,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodConfig#pidFile() pidFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pidFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodConfig withPidFile(String value) {
    String newValue = Objects.requireNonNull(value, "pidFile");
    if (this.pidFile.equals(newValue)) return this;
    return new ImmutableMongodConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.processListener,
        this.params,
        this.args,
        newValue,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodConfig#supportConfig() supportConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for supportConfig
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodConfig withSupportConfig(SupportConfig value) {
    if (this.supportConfig == value) return this;
    SupportConfig newValue = Objects.requireNonNull(value, "supportConfig");
    return new ImmutableMongodConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.processListener,
        this.params,
        this.args,
        this.pidFile,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongodConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongodConfig
        && equalTo((ImmutableMongodConfig) another);
  }

  private boolean equalTo(ImmutableMongodConfig another) {
    return Objects.equals(stopTimeoutInMillis, another.stopTimeoutInMillis)
        && version.equals(another.version)
        && timeout.equals(another.timeout)
        && net.equals(another.net)
        && cmdOptions.equals(another.cmdOptions)
        && password.equals(another.password)
        && userName.equals(another.userName)
        && replication.equals(another.replication)
        && isConfigServer == another.isConfigServer
        && isShardServer == another.isShardServer
        && processListener.equals(another.processListener)
        && params.equals(another.params)
        && args.equals(another.args)
        && pidFile.equals(another.pidFile)
        && supportConfig.equals(another.supportConfig);
  }

  /**
   * Computes a hash code from attributes: {@code stopTimeoutInMillis}, {@code version}, {@code timeout}, {@code net}, {@code cmdOptions}, {@code password}, {@code userName}, {@code replication}, {@code isConfigServer}, {@code isShardServer}, {@code processListener}, {@code params}, {@code args}, {@code pidFile}, {@code supportConfig}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(stopTimeoutInMillis);
    h += (h << 5) + version.hashCode();
    h += (h << 5) + timeout.hashCode();
    h += (h << 5) + net.hashCode();
    h += (h << 5) + cmdOptions.hashCode();
    h += (h << 5) + password.hashCode();
    h += (h << 5) + userName.hashCode();
    h += (h << 5) + replication.hashCode();
    h += (h << 5) + Boolean.hashCode(isConfigServer);
    h += (h << 5) + Boolean.hashCode(isShardServer);
    h += (h << 5) + processListener.hashCode();
    h += (h << 5) + params.hashCode();
    h += (h << 5) + args.hashCode();
    h += (h << 5) + pidFile.hashCode();
    h += (h << 5) + supportConfig.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongodConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("MongodConfig{");
    if (stopTimeoutInMillis != null) {
      builder.append("stopTimeoutInMillis=").append(stopTimeoutInMillis);
    }
    if (builder.length() > 13) builder.append(", ");
    builder.append("version=").append(version);
    builder.append(", ");
    builder.append("timeout=").append(timeout);
    builder.append(", ");
    builder.append("net=").append(net);
    builder.append(", ");
    builder.append("cmdOptions=").append(cmdOptions);
    builder.append(", ");
    builder.append("password=").append(password);
    builder.append(", ");
    builder.append("userName=").append(userName);
    builder.append(", ");
    builder.append("replication=").append(replication);
    builder.append(", ");
    builder.append("isConfigServer=").append(isConfigServer);
    builder.append(", ");
    builder.append("isShardServer=").append(isShardServer);
    builder.append(", ");
    builder.append("processListener=").append(processListener);
    builder.append(", ");
    builder.append("params=").append(params);
    builder.append(", ");
    builder.append("args=").append(args);
    builder.append(", ");
    builder.append("pidFile=").append(pidFile);
    builder.append(", ");
    builder.append("supportConfig=").append(supportConfig);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link MongodConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongodConfig instance
   */
  public static ImmutableMongodConfig copyOf(MongodConfig instance) {
    if (instance instanceof ImmutableMongodConfig) {
      return (ImmutableMongodConfig) instance;
    }
    return ImmutableMongodConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongodConfig ImmutableMongodConfig}.
   * <pre>
   * ImmutableMongodConfig.builder()
   *    .stopTimeoutInMillis(long) // optional {@link MongodConfig#stopTimeoutInMillis() stopTimeoutInMillis}
   *    .version(de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion) // required {@link MongodConfig#version() version}
   *    .timeout(de.flapdoodle.embed.mongo.config.Timeout) // optional {@link MongodConfig#timeout() timeout}
   *    .net(de.flapdoodle.embed.mongo.config.Net) // optional {@link MongodConfig#net() net}
   *    .cmdOptions(de.flapdoodle.embed.mongo.config.MongoCmdOptions) // optional {@link MongodConfig#cmdOptions() cmdOptions}
   *    .password(String) // optional {@link MongodConfig#password() password}
   *    .userName(String) // optional {@link MongodConfig#userName() userName}
   *    .replication(de.flapdoodle.embed.mongo.config.Storage) // optional {@link MongodConfig#replication() replication}
   *    .isConfigServer(boolean) // optional {@link MongodConfig#isConfigServer() isConfigServer}
   *    .isShardServer(boolean) // optional {@link MongodConfig#isShardServer() isShardServer}
   *    .processListener(de.flapdoodle.embed.mongo.config.processlistener.IMongoProcessListener) // optional {@link MongodConfig#processListener() processListener}
   *    .putParams|putAllParams(String =&gt; String) // {@link MongodConfig#params() params} mappings
   *    .putArgs|putAllArgs(String =&gt; String) // {@link MongodConfig#args() args} mappings
   *    .pidFile(String) // optional {@link MongodConfig#pidFile() pidFile}
   *    .supportConfig(de.flapdoodle.embed.process.config.SupportConfig) // optional {@link MongodConfig#supportConfig() supportConfig}
   *    .build();
   * </pre>
   * @return A new ImmutableMongodConfig builder
   */
  public static ImmutableMongodConfig.Builder builder() {
    return new ImmutableMongodConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongodConfig ImmutableMongodConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongodConfig", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long OPT_BIT_IS_CONFIG_SERVER = 0x1L;
    private static final long OPT_BIT_IS_SHARD_SERVER = 0x2L;
    private long initBits = 0x1L;
    private long optBits;

    private Long stopTimeoutInMillis;
    private IFeatureAwareVersion version;
    private Timeout timeout;
    private Net net;
    private MongoCmdOptions cmdOptions;
    private String password;
    private String userName;
    private Storage replication;
    private boolean isConfigServer;
    private boolean isShardServer;
    private IMongoProcessListener processListener;
    private Map<String, String> params = new LinkedHashMap<String, String>();
    private Map<String, String> args = new LinkedHashMap<String, String>();
    private String pidFile;
    private SupportConfig supportConfig;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.config.MongodConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongodConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.config.MongoCommonConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoCommonConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.process.config.ExecutableProcessConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExecutableProcessConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof MongodConfig) {
        MongodConfig instance = (MongodConfig) object;
        replication(instance.replication());
        putAllArgs(instance.args());
        processListener(instance.processListener());
        if ((bits & 0x4L) == 0) {
          supportConfig(instance.supportConfig());
          bits |= 0x4L;
        }
        isShardServer(instance.isShardServer());
        putAllParams(instance.params());
        if ((bits & 0x1L) == 0) {
          version(instance.version());
          bits |= 0x1L;
        }
        isConfigServer(instance.isConfigServer());
        if ((bits & 0x2L) == 0) {
          pidFile(instance.pidFile());
          bits |= 0x2L;
        }
      }
      if (object instanceof MongoCommonConfig) {
        MongoCommonConfig instance = (MongoCommonConfig) object;
        password(instance.password());
        cmdOptions(instance.cmdOptions());
        userName(instance.userName());
        net(instance.net());
        if ((bits & 0x1L) == 0) {
          version(instance.version());
          bits |= 0x1L;
        }
        timeout(instance.timeout());
        if ((bits & 0x2L) == 0) {
          pidFile(instance.pidFile());
          bits |= 0x2L;
        }
      }
      if (object instanceof ExecutableProcessConfig) {
        ExecutableProcessConfig instance = (ExecutableProcessConfig) object;
        if ((bits & 0x4L) == 0) {
          supportConfig(instance.supportConfig());
          bits |= 0x4L;
        }
        OptionalLong stopTimeoutInMillisOptional = instance.stopTimeoutInMillis();
        if (stopTimeoutInMillisOptional.isPresent()) {
          stopTimeoutInMillis(stopTimeoutInMillisOptional);
        }
      }
    }

    /**
     * Initializes the optional value {@link MongodConfig#stopTimeoutInMillis() stopTimeoutInMillis} to stopTimeoutInMillis.
     * @param stopTimeoutInMillis The value for stopTimeoutInMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder stopTimeoutInMillis(long stopTimeoutInMillis) {
      this.stopTimeoutInMillis = stopTimeoutInMillis;
      return this;
    }

    /**
     * Initializes the optional value {@link MongodConfig#stopTimeoutInMillis() stopTimeoutInMillis} to stopTimeoutInMillis.
     * @param stopTimeoutInMillis The value for stopTimeoutInMillis
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stopTimeoutInMillis(OptionalLong stopTimeoutInMillis) {
      this.stopTimeoutInMillis = stopTimeoutInMillis.isPresent() ? stopTimeoutInMillis.getAsLong() : null;
      return this;
    }

    /**
     * Initializes the value for the {@link MongodConfig#version() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(IFeatureAwareVersion version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link MongodConfig#timeout() timeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodConfig#timeout() timeout}.</em>
     * @param timeout The value for timeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timeout(Timeout timeout) {
      this.timeout = Objects.requireNonNull(timeout, "timeout");
      return this;
    }

    /**
     * Initializes the value for the {@link MongodConfig#net() net} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodConfig#net() net}.</em>
     * @param net The value for net 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder net(Net net) {
      this.net = Objects.requireNonNull(net, "net");
      return this;
    }

    /**
     * Initializes the value for the {@link MongodConfig#cmdOptions() cmdOptions} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodConfig#cmdOptions() cmdOptions}.</em>
     * @param cmdOptions The value for cmdOptions 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cmdOptions(MongoCmdOptions cmdOptions) {
      this.cmdOptions = Objects.requireNonNull(cmdOptions, "cmdOptions");
      return this;
    }

    /**
     * Initializes the value for the {@link MongodConfig#password() password} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodConfig#password() password}.</em>
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      return this;
    }

    /**
     * Initializes the value for the {@link MongodConfig#userName() userName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodConfig#userName() userName}.</em>
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      return this;
    }

    /**
     * Initializes the value for the {@link MongodConfig#replication() replication} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodConfig#replication() replication}.</em>
     * @param replication The value for replication 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder replication(Storage replication) {
      this.replication = Objects.requireNonNull(replication, "replication");
      return this;
    }

    /**
     * Initializes the value for the {@link MongodConfig#isConfigServer() isConfigServer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodConfig#isConfigServer() isConfigServer}.</em>
     * @param isConfigServer The value for isConfigServer 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isConfigServer(boolean isConfigServer) {
      this.isConfigServer = isConfigServer;
      optBits |= OPT_BIT_IS_CONFIG_SERVER;
      return this;
    }

    /**
     * Initializes the value for the {@link MongodConfig#isShardServer() isShardServer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodConfig#isShardServer() isShardServer}.</em>
     * @param isShardServer The value for isShardServer 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isShardServer(boolean isShardServer) {
      this.isShardServer = isShardServer;
      optBits |= OPT_BIT_IS_SHARD_SERVER;
      return this;
    }

    /**
     * Initializes the value for the {@link MongodConfig#processListener() processListener} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodConfig#processListener() processListener}.</em>
     * @param processListener The value for processListener 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processListener(IMongoProcessListener processListener) {
      this.processListener = Objects.requireNonNull(processListener, "processListener");
      return this;
    }

    /**
     * Put one entry to the {@link MongodConfig#params() params} map.
     * @param key The key in the params map
     * @param value The associated value in the params map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putParams(String key, String value) {
      this.params.put(
          Objects.requireNonNull(key, "params key"),
          Objects.requireNonNull(value, "params value"));
      return this;
    }

    /**
     * Put one entry to the {@link MongodConfig#params() params} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putParams(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.params.put(
          Objects.requireNonNull(k, "params key"),
          Objects.requireNonNull(v, "params value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MongodConfig#params() params} map. Nulls are not permitted
     * @param entries The entries that will be added to the params map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder params(Map<String, ? extends String> entries) {
      this.params.clear();
      return putAllParams(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MongodConfig#params() params} map. Nulls are not permitted
     * @param entries The entries that will be added to the params map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParams(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.params.put(
            Objects.requireNonNull(k, "params key"),
            Objects.requireNonNull(v, "params value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link MongodConfig#args() args} map.
     * @param key The key in the args map
     * @param value The associated value in the args map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putArgs(String key, String value) {
      this.args.put(
          Objects.requireNonNull(key, "args key"),
          Objects.requireNonNull(value, "args value"));
      return this;
    }

    /**
     * Put one entry to the {@link MongodConfig#args() args} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putArgs(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.args.put(
          Objects.requireNonNull(k, "args key"),
          Objects.requireNonNull(v, "args value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MongodConfig#args() args} map. Nulls are not permitted
     * @param entries The entries that will be added to the args map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder args(Map<String, ? extends String> entries) {
      this.args.clear();
      return putAllArgs(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MongodConfig#args() args} map. Nulls are not permitted
     * @param entries The entries that will be added to the args map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllArgs(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.args.put(
            Objects.requireNonNull(k, "args key"),
            Objects.requireNonNull(v, "args value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MongodConfig#pidFile() pidFile} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodConfig#pidFile() pidFile}.</em>
     * @param pidFile The value for pidFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pidFile(String pidFile) {
      this.pidFile = Objects.requireNonNull(pidFile, "pidFile");
      return this;
    }

    /**
     * Initializes the value for the {@link MongodConfig#supportConfig() supportConfig} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodConfig#supportConfig() supportConfig}.</em>
     * @param supportConfig The value for supportConfig 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportConfig(SupportConfig supportConfig) {
      this.supportConfig = Objects.requireNonNull(supportConfig, "supportConfig");
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongodConfig ImmutableMongodConfig}.
     * @return An immutable instance of MongodConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongodConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMongodConfig(this);
    }

    private boolean isConfigServerIsSet() {
      return (optBits & OPT_BIT_IS_CONFIG_SERVER) != 0;
    }

    private boolean isShardServerIsSet() {
      return (optBits & OPT_BIT_IS_SHARD_SERVER) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      return "Cannot build MongodConfig, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
