/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.ImmutableFileSet;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.linux.DebianVersion;
import java.util.Optional;

public class DebianPackageResolver
implements PackageFinder {
    private final ImmutablePlatformMatchRules rules;

    public DebianPackageResolver(Command command) {
        this.rules = DebianPackageResolver.rules(command);
    }

    @Override
    public Optional<DistributionPackage> packageFor(Distribution distribution) {
        return this.rules.packageFor(distribution);
    }

    private static ImmutablePlatformMatchRules rules(Command command) {
        ImmutableFileSet fileSet = FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
        ImmutablePlatformMatchRule debian9 = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("3.6.23", "5.0.4")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.X86).withVersion(new Version[]{DebianVersion.DEBIAN_9}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian92-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule debian9tools = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("3.6.23", "5.0.4")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.X86).withVersion(new Version[]{DebianVersion.DEBIAN_9}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-debian92-x86_64-{tools.version}.tgz").build()).build();
        ImmutablePlatformMatchRule debian10 = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("4.2.13", "5.0.4")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.X86).withVersion(new Version[]{DebianVersion.DEBIAN_10}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian10-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule debian10tools = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("4.2.13", "5.0.4")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.X86).withVersion(new Version[]{DebianVersion.DEBIAN_10}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-debian10-x86_64-{tools.version}.tgz").build()).build();
        switch (command) {
            case MongoDump: 
            case MongoImport: 
            case MongoRestore: {
                return PlatformMatchRules.empty().withRules(debian9tools, debian10tools);
            }
        }
        return PlatformMatchRules.empty().withRules(debian9, debian10);
    }
}

