package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.SupportConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongosConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongosConfig.builder()}.
 */
@Generated(from = "MongosConfig", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableMongosConfig implements MongosConfig {
  private final Long stopTimeoutInMillis;
  private final IFeatureAwareVersion version;
  private final Timeout timeout;
  private final Net net;
  private final MongoCmdOptions cmdOptions;
  private final String password;
  private final String userName;
  private final String configDB;
  private final String replicaSet;
  private final Map<String, String> args;
  private final String pidFile;
  private final SupportConfig supportConfig;

  private ImmutableMongosConfig(ImmutableMongosConfig.Builder builder) {
    this.stopTimeoutInMillis = builder.stopTimeoutInMillis;
    this.version = builder.version;
    this.configDB = builder.configDB;
    this.args = createUnmodifiableMap(false, false, builder.args);
    if (builder.timeout != null) {
      initShim.timeout(builder.timeout);
    }
    if (builder.net != null) {
      initShim.net(builder.net);
    }
    if (builder.cmdOptions != null) {
      initShim.cmdOptions(builder.cmdOptions);
    }
    if (builder.password != null) {
      initShim.password(builder.password);
    }
    if (builder.userName != null) {
      initShim.userName(builder.userName);
    }
    if (builder.replicaSet != null) {
      initShim.replicaSet(builder.replicaSet);
    }
    if (builder.pidFile != null) {
      initShim.pidFile(builder.pidFile);
    }
    if (builder.supportConfig != null) {
      initShim.supportConfig(builder.supportConfig);
    }
    this.timeout = initShim.timeout();
    this.net = initShim.net();
    this.cmdOptions = initShim.cmdOptions();
    this.password = initShim.password();
    this.userName = initShim.userName();
    this.replicaSet = initShim.replicaSet();
    this.pidFile = initShim.pidFile();
    this.supportConfig = initShim.supportConfig();
    this.initShim = null;
  }

  private ImmutableMongosConfig(
      Long stopTimeoutInMillis,
      IFeatureAwareVersion version,
      Timeout timeout,
      Net net,
      MongoCmdOptions cmdOptions,
      String password,
      String userName,
      String configDB,
      String replicaSet,
      Map<String, String> args,
      String pidFile,
      SupportConfig supportConfig) {
    this.stopTimeoutInMillis = stopTimeoutInMillis;
    this.version = version;
    this.timeout = timeout;
    this.net = net;
    this.cmdOptions = cmdOptions;
    this.password = password;
    this.userName = userName;
    this.configDB = configDB;
    this.replicaSet = replicaSet;
    this.args = args;
    this.pidFile = pidFile;
    this.supportConfig = supportConfig;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MongosConfig", generator = "Immutables")
  private final class InitShim {
    private byte timeoutBuildStage = STAGE_UNINITIALIZED;
    private Timeout timeout;

    Timeout timeout() {
      if (timeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (timeoutBuildStage == STAGE_UNINITIALIZED) {
        timeoutBuildStage = STAGE_INITIALIZING;
        this.timeout = Objects.requireNonNull(timeoutInitialize(), "timeout");
        timeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.timeout;
    }

    void timeout(Timeout timeout) {
      this.timeout = timeout;
      timeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte netBuildStage = STAGE_UNINITIALIZED;
    private Net net;

    Net net() {
      if (netBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (netBuildStage == STAGE_UNINITIALIZED) {
        netBuildStage = STAGE_INITIALIZING;
        this.net = Objects.requireNonNull(netInitialize(), "net");
        netBuildStage = STAGE_INITIALIZED;
      }
      return this.net;
    }

    void net(Net net) {
      this.net = net;
      netBuildStage = STAGE_INITIALIZED;
    }

    private byte cmdOptionsBuildStage = STAGE_UNINITIALIZED;
    private MongoCmdOptions cmdOptions;

    MongoCmdOptions cmdOptions() {
      if (cmdOptionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (cmdOptionsBuildStage == STAGE_UNINITIALIZED) {
        cmdOptionsBuildStage = STAGE_INITIALIZING;
        this.cmdOptions = Objects.requireNonNull(cmdOptionsInitialize(), "cmdOptions");
        cmdOptionsBuildStage = STAGE_INITIALIZED;
      }
      return this.cmdOptions;
    }

    void cmdOptions(MongoCmdOptions cmdOptions) {
      this.cmdOptions = cmdOptions;
      cmdOptionsBuildStage = STAGE_INITIALIZED;
    }

    private byte passwordBuildStage = STAGE_UNINITIALIZED;
    private String password;

    String password() {
      if (passwordBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (passwordBuildStage == STAGE_UNINITIALIZED) {
        passwordBuildStage = STAGE_INITIALIZING;
        this.password = Objects.requireNonNull(passwordInitialize(), "password");
        passwordBuildStage = STAGE_INITIALIZED;
      }
      return this.password;
    }

    void password(String password) {
      this.password = password;
      passwordBuildStage = STAGE_INITIALIZED;
    }

    private byte userNameBuildStage = STAGE_UNINITIALIZED;
    private String userName;

    String userName() {
      if (userNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (userNameBuildStage == STAGE_UNINITIALIZED) {
        userNameBuildStage = STAGE_INITIALIZING;
        this.userName = Objects.requireNonNull(userNameInitialize(), "userName");
        userNameBuildStage = STAGE_INITIALIZED;
      }
      return this.userName;
    }

    void userName(String userName) {
      this.userName = userName;
      userNameBuildStage = STAGE_INITIALIZED;
    }

    private byte replicaSetBuildStage = STAGE_UNINITIALIZED;
    private String replicaSet;

    String replicaSet() {
      if (replicaSetBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (replicaSetBuildStage == STAGE_UNINITIALIZED) {
        replicaSetBuildStage = STAGE_INITIALIZING;
        this.replicaSet = Objects.requireNonNull(replicaSetInitialize(), "replicaSet");
        replicaSetBuildStage = STAGE_INITIALIZED;
      }
      return this.replicaSet;
    }

    void replicaSet(String replicaSet) {
      this.replicaSet = replicaSet;
      replicaSetBuildStage = STAGE_INITIALIZED;
    }

    private byte pidFileBuildStage = STAGE_UNINITIALIZED;
    private String pidFile;

    String pidFile() {
      if (pidFileBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pidFileBuildStage == STAGE_UNINITIALIZED) {
        pidFileBuildStage = STAGE_INITIALIZING;
        this.pidFile = Objects.requireNonNull(pidFileInitialize(), "pidFile");
        pidFileBuildStage = STAGE_INITIALIZED;
      }
      return this.pidFile;
    }

    void pidFile(String pidFile) {
      this.pidFile = pidFile;
      pidFileBuildStage = STAGE_INITIALIZED;
    }

    private byte supportConfigBuildStage = STAGE_UNINITIALIZED;
    private SupportConfig supportConfig;

    SupportConfig supportConfig() {
      if (supportConfigBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (supportConfigBuildStage == STAGE_UNINITIALIZED) {
        supportConfigBuildStage = STAGE_INITIALIZING;
        this.supportConfig = Objects.requireNonNull(supportConfigInitialize(), "supportConfig");
        supportConfigBuildStage = STAGE_INITIALIZED;
      }
      return this.supportConfig;
    }

    void supportConfig(SupportConfig supportConfig) {
      this.supportConfig = supportConfig;
      supportConfigBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (timeoutBuildStage == STAGE_INITIALIZING) attributes.add("timeout");
      if (netBuildStage == STAGE_INITIALIZING) attributes.add("net");
      if (cmdOptionsBuildStage == STAGE_INITIALIZING) attributes.add("cmdOptions");
      if (passwordBuildStage == STAGE_INITIALIZING) attributes.add("password");
      if (userNameBuildStage == STAGE_INITIALIZING) attributes.add("userName");
      if (replicaSetBuildStage == STAGE_INITIALIZING) attributes.add("replicaSet");
      if (pidFileBuildStage == STAGE_INITIALIZING) attributes.add("pidFile");
      if (supportConfigBuildStage == STAGE_INITIALIZING) attributes.add("supportConfig");
      return "Cannot build MongosConfig, attribute initializers form cycle " + attributes;
    }
  }

  private Timeout timeoutInitialize() {
    return MongosConfig.super.timeout();
  }

  private Net netInitialize() {
    return MongosConfig.super.net();
  }

  private MongoCmdOptions cmdOptionsInitialize() {
    return MongosConfig.super.cmdOptions();
  }

  private String passwordInitialize() {
    return MongosConfig.super.password();
  }

  private String userNameInitialize() {
    return MongosConfig.super.userName();
  }

  private String replicaSetInitialize() {
    return MongosConfig.super.replicaSet();
  }

  private String pidFileInitialize() {
    return MongosConfig.super.pidFile();
  }

  private SupportConfig supportConfigInitialize() {
    return MongosConfig.super.supportConfig();
  }

  /**
   * @return The value of the {@code stopTimeoutInMillis} attribute
   */
  @Override
  public OptionalLong stopTimeoutInMillis() {
    return stopTimeoutInMillis != null
        ? OptionalLong.of(stopTimeoutInMillis)
        : OptionalLong.empty();
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @Override
  public IFeatureAwareVersion version() {
    return version;
  }

  /**
   * @return The value of the {@code timeout} attribute
   */
  @Override
  public Timeout timeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.timeout()
        : this.timeout;
  }

  /**
   * @return The value of the {@code net} attribute
   */
  @Override
  public Net net() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.net()
        : this.net;
  }

  /**
   * @return The value of the {@code cmdOptions} attribute
   */
  @Override
  public MongoCmdOptions cmdOptions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.cmdOptions()
        : this.cmdOptions;
  }

  /**
   * @return The value of the {@code password} attribute
   */
  @Override
  public String password() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.password()
        : this.password;
  }

  /**
   * @return The value of the {@code userName} attribute
   */
  @Override
  public String userName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.userName()
        : this.userName;
  }

  /**
   * @return The value of the {@code configDB} attribute
   */
  @Override
  public String getConfigDB() {
    return configDB;
  }

  /**
   * @return The value of the {@code replicaSet} attribute
   */
  @Override
  public String replicaSet() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.replicaSet()
        : this.replicaSet;
  }

  /**
   * @return The value of the {@code args} attribute
   */
  @Override
  public Map<String, String> args() {
    return args;
  }

  /**
   * @return The value of the {@code pidFile} attribute
   */
  @Override
  public String pidFile() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.pidFile()
        : this.pidFile;
  }

  /**
   * @return The value of the {@code supportConfig} attribute
   */
  @Override
  public SupportConfig supportConfig() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.supportConfig()
        : this.supportConfig;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongosConfig#stopTimeoutInMillis() stopTimeoutInMillis} attribute.
   * @param value The value for stopTimeoutInMillis
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongosConfig withStopTimeoutInMillis(long value) {
    Long newValue = value;
    if (Objects.equals(this.stopTimeoutInMillis, newValue)) return this;
    return new ImmutableMongosConfig(
        newValue,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.configDB,
        this.replicaSet,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongosConfig#stopTimeoutInMillis() stopTimeoutInMillis} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for stopTimeoutInMillis
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongosConfig withStopTimeoutInMillis(OptionalLong optional) {
    Long value = optional.isPresent() ? optional.getAsLong() : null;
    if (Objects.equals(this.stopTimeoutInMillis, value)) return this;
    return new ImmutableMongosConfig(
        value,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.configDB,
        this.replicaSet,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosConfig#version() version} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosConfig withVersion(IFeatureAwareVersion value) {
    if (this.version == value) return this;
    IFeatureAwareVersion newValue = Objects.requireNonNull(value, "version");
    return new ImmutableMongosConfig(
        this.stopTimeoutInMillis,
        newValue,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.configDB,
        this.replicaSet,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosConfig#timeout() timeout} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timeout
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosConfig withTimeout(Timeout value) {
    if (this.timeout == value) return this;
    Timeout newValue = Objects.requireNonNull(value, "timeout");
    return new ImmutableMongosConfig(
        this.stopTimeoutInMillis,
        this.version,
        newValue,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.configDB,
        this.replicaSet,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosConfig#net() net} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for net
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosConfig withNet(Net value) {
    if (this.net == value) return this;
    Net newValue = Objects.requireNonNull(value, "net");
    return new ImmutableMongosConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        newValue,
        this.cmdOptions,
        this.password,
        this.userName,
        this.configDB,
        this.replicaSet,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosConfig#cmdOptions() cmdOptions} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cmdOptions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosConfig withCmdOptions(MongoCmdOptions value) {
    if (this.cmdOptions == value) return this;
    MongoCmdOptions newValue = Objects.requireNonNull(value, "cmdOptions");
    return new ImmutableMongosConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        newValue,
        this.password,
        this.userName,
        this.configDB,
        this.replicaSet,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosConfig#password() password} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for password
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosConfig withPassword(String value) {
    String newValue = Objects.requireNonNull(value, "password");
    if (this.password.equals(newValue)) return this;
    return new ImmutableMongosConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        newValue,
        this.userName,
        this.configDB,
        this.replicaSet,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosConfig#userName() userName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosConfig withUserName(String value) {
    String newValue = Objects.requireNonNull(value, "userName");
    if (this.userName.equals(newValue)) return this;
    return new ImmutableMongosConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        newValue,
        this.configDB,
        this.replicaSet,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosConfig#getConfigDB() configDB} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for configDB
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosConfig withConfigDB(String value) {
    String newValue = Objects.requireNonNull(value, "configDB");
    if (this.configDB.equals(newValue)) return this;
    return new ImmutableMongosConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        newValue,
        this.replicaSet,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosConfig#replicaSet() replicaSet} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for replicaSet
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosConfig withReplicaSet(String value) {
    String newValue = Objects.requireNonNull(value, "replicaSet");
    if (this.replicaSet.equals(newValue)) return this;
    return new ImmutableMongosConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.configDB,
        newValue,
        this.args,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by replacing the {@link MongosConfig#args() args} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the args map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongosConfig withArgs(Map<String, ? extends String> entries) {
    if (this.args == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableMongosConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.configDB,
        this.replicaSet,
        newValue,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosConfig#pidFile() pidFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pidFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosConfig withPidFile(String value) {
    String newValue = Objects.requireNonNull(value, "pidFile");
    if (this.pidFile.equals(newValue)) return this;
    return new ImmutableMongosConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.configDB,
        this.replicaSet,
        this.args,
        newValue,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosConfig#supportConfig() supportConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for supportConfig
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosConfig withSupportConfig(SupportConfig value) {
    if (this.supportConfig == value) return this;
    SupportConfig newValue = Objects.requireNonNull(value, "supportConfig");
    return new ImmutableMongosConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.configDB,
        this.replicaSet,
        this.args,
        this.pidFile,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongosConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongosConfig
        && equalTo((ImmutableMongosConfig) another);
  }

  private boolean equalTo(ImmutableMongosConfig another) {
    return Objects.equals(stopTimeoutInMillis, another.stopTimeoutInMillis)
        && version.equals(another.version)
        && timeout.equals(another.timeout)
        && net.equals(another.net)
        && cmdOptions.equals(another.cmdOptions)
        && password.equals(another.password)
        && userName.equals(another.userName)
        && configDB.equals(another.configDB)
        && replicaSet.equals(another.replicaSet)
        && args.equals(another.args)
        && pidFile.equals(another.pidFile)
        && supportConfig.equals(another.supportConfig);
  }

  /**
   * Computes a hash code from attributes: {@code stopTimeoutInMillis}, {@code version}, {@code timeout}, {@code net}, {@code cmdOptions}, {@code password}, {@code userName}, {@code configDB}, {@code replicaSet}, {@code args}, {@code pidFile}, {@code supportConfig}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(stopTimeoutInMillis);
    h += (h << 5) + version.hashCode();
    h += (h << 5) + timeout.hashCode();
    h += (h << 5) + net.hashCode();
    h += (h << 5) + cmdOptions.hashCode();
    h += (h << 5) + password.hashCode();
    h += (h << 5) + userName.hashCode();
    h += (h << 5) + configDB.hashCode();
    h += (h << 5) + replicaSet.hashCode();
    h += (h << 5) + args.hashCode();
    h += (h << 5) + pidFile.hashCode();
    h += (h << 5) + supportConfig.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongosConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("MongosConfig{");
    if (stopTimeoutInMillis != null) {
      builder.append("stopTimeoutInMillis=").append(stopTimeoutInMillis);
    }
    if (builder.length() > 13) builder.append(", ");
    builder.append("version=").append(version);
    builder.append(", ");
    builder.append("timeout=").append(timeout);
    builder.append(", ");
    builder.append("net=").append(net);
    builder.append(", ");
    builder.append("cmdOptions=").append(cmdOptions);
    builder.append(", ");
    builder.append("password=").append(password);
    builder.append(", ");
    builder.append("userName=").append(userName);
    builder.append(", ");
    builder.append("configDB=").append(configDB);
    builder.append(", ");
    builder.append("replicaSet=").append(replicaSet);
    builder.append(", ");
    builder.append("args=").append(args);
    builder.append(", ");
    builder.append("pidFile=").append(pidFile);
    builder.append(", ");
    builder.append("supportConfig=").append(supportConfig);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link MongosConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongosConfig instance
   */
  public static ImmutableMongosConfig copyOf(MongosConfig instance) {
    if (instance instanceof ImmutableMongosConfig) {
      return (ImmutableMongosConfig) instance;
    }
    return ImmutableMongosConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongosConfig ImmutableMongosConfig}.
   * <pre>
   * ImmutableMongosConfig.builder()
   *    .stopTimeoutInMillis(long) // optional {@link MongosConfig#stopTimeoutInMillis() stopTimeoutInMillis}
   *    .version(de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion) // required {@link MongosConfig#version() version}
   *    .timeout(de.flapdoodle.embed.mongo.config.Timeout) // optional {@link MongosConfig#timeout() timeout}
   *    .net(de.flapdoodle.embed.mongo.config.Net) // optional {@link MongosConfig#net() net}
   *    .cmdOptions(de.flapdoodle.embed.mongo.config.MongoCmdOptions) // optional {@link MongosConfig#cmdOptions() cmdOptions}
   *    .password(String) // optional {@link MongosConfig#password() password}
   *    .userName(String) // optional {@link MongosConfig#userName() userName}
   *    .configDB(String) // required {@link MongosConfig#getConfigDB() configDB}
   *    .replicaSet(String) // optional {@link MongosConfig#replicaSet() replicaSet}
   *    .putArgs|putAllArgs(String =&gt; String) // {@link MongosConfig#args() args} mappings
   *    .pidFile(String) // optional {@link MongosConfig#pidFile() pidFile}
   *    .supportConfig(de.flapdoodle.embed.process.config.SupportConfig) // optional {@link MongosConfig#supportConfig() supportConfig}
   *    .build();
   * </pre>
   * @return A new ImmutableMongosConfig builder
   */
  public static ImmutableMongosConfig.Builder builder() {
    return new ImmutableMongosConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongosConfig ImmutableMongosConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongosConfig", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long INIT_BIT_CONFIG_D_B = 0x2L;
    private long initBits = 0x3L;

    private Long stopTimeoutInMillis;
    private IFeatureAwareVersion version;
    private Timeout timeout;
    private Net net;
    private MongoCmdOptions cmdOptions;
    private String password;
    private String userName;
    private String configDB;
    private String replicaSet;
    private Map<String, String> args = new LinkedHashMap<String, String>();
    private String pidFile;
    private SupportConfig supportConfig;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.config.MongoCommonConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoCommonConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.process.config.ExecutableProcessConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExecutableProcessConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.config.MongosConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongosConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof MongoCommonConfig) {
        MongoCommonConfig instance = (MongoCommonConfig) object;
        password(instance.password());
        cmdOptions(instance.cmdOptions());
        net(instance.net());
        userName(instance.userName());
        if ((bits & 0x2L) == 0) {
          version(instance.version());
          bits |= 0x2L;
        }
        timeout(instance.timeout());
        if ((bits & 0x4L) == 0) {
          pidFile(instance.pidFile());
          bits |= 0x4L;
        }
      }
      if (object instanceof ExecutableProcessConfig) {
        ExecutableProcessConfig instance = (ExecutableProcessConfig) object;
        if ((bits & 0x1L) == 0) {
          supportConfig(instance.supportConfig());
          bits |= 0x1L;
        }
        OptionalLong stopTimeoutInMillisOptional = instance.stopTimeoutInMillis();
        if (stopTimeoutInMillisOptional.isPresent()) {
          stopTimeoutInMillis(stopTimeoutInMillisOptional);
        }
      }
      if (object instanceof MongosConfig) {
        MongosConfig instance = (MongosConfig) object;
        putAllArgs(instance.args());
        configDB(instance.getConfigDB());
        if ((bits & 0x1L) == 0) {
          supportConfig(instance.supportConfig());
          bits |= 0x1L;
        }
        replicaSet(instance.replicaSet());
        if ((bits & 0x2L) == 0) {
          version(instance.version());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          pidFile(instance.pidFile());
          bits |= 0x4L;
        }
      }
    }

    /**
     * Initializes the optional value {@link MongosConfig#stopTimeoutInMillis() stopTimeoutInMillis} to stopTimeoutInMillis.
     * @param stopTimeoutInMillis The value for stopTimeoutInMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder stopTimeoutInMillis(long stopTimeoutInMillis) {
      this.stopTimeoutInMillis = stopTimeoutInMillis;
      return this;
    }

    /**
     * Initializes the optional value {@link MongosConfig#stopTimeoutInMillis() stopTimeoutInMillis} to stopTimeoutInMillis.
     * @param stopTimeoutInMillis The value for stopTimeoutInMillis
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stopTimeoutInMillis(OptionalLong stopTimeoutInMillis) {
      this.stopTimeoutInMillis = stopTimeoutInMillis.isPresent() ? stopTimeoutInMillis.getAsLong() : null;
      return this;
    }

    /**
     * Initializes the value for the {@link MongosConfig#version() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(IFeatureAwareVersion version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link MongosConfig#timeout() timeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongosConfig#timeout() timeout}.</em>
     * @param timeout The value for timeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timeout(Timeout timeout) {
      this.timeout = Objects.requireNonNull(timeout, "timeout");
      return this;
    }

    /**
     * Initializes the value for the {@link MongosConfig#net() net} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongosConfig#net() net}.</em>
     * @param net The value for net 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder net(Net net) {
      this.net = Objects.requireNonNull(net, "net");
      return this;
    }

    /**
     * Initializes the value for the {@link MongosConfig#cmdOptions() cmdOptions} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongosConfig#cmdOptions() cmdOptions}.</em>
     * @param cmdOptions The value for cmdOptions 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cmdOptions(MongoCmdOptions cmdOptions) {
      this.cmdOptions = Objects.requireNonNull(cmdOptions, "cmdOptions");
      return this;
    }

    /**
     * Initializes the value for the {@link MongosConfig#password() password} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongosConfig#password() password}.</em>
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      return this;
    }

    /**
     * Initializes the value for the {@link MongosConfig#userName() userName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongosConfig#userName() userName}.</em>
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      return this;
    }

    /**
     * Initializes the value for the {@link MongosConfig#getConfigDB() configDB} attribute.
     * @param configDB The value for configDB 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder configDB(String configDB) {
      this.configDB = Objects.requireNonNull(configDB, "configDB");
      initBits &= ~INIT_BIT_CONFIG_D_B;
      return this;
    }

    /**
     * Initializes the value for the {@link MongosConfig#replicaSet() replicaSet} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongosConfig#replicaSet() replicaSet}.</em>
     * @param replicaSet The value for replicaSet 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder replicaSet(String replicaSet) {
      this.replicaSet = Objects.requireNonNull(replicaSet, "replicaSet");
      return this;
    }

    /**
     * Put one entry to the {@link MongosConfig#args() args} map.
     * @param key The key in the args map
     * @param value The associated value in the args map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putArgs(String key, String value) {
      this.args.put(
          Objects.requireNonNull(key, "args key"),
          Objects.requireNonNull(value, "args value"));
      return this;
    }

    /**
     * Put one entry to the {@link MongosConfig#args() args} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putArgs(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.args.put(
          Objects.requireNonNull(k, "args key"),
          Objects.requireNonNull(v, "args value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MongosConfig#args() args} map. Nulls are not permitted
     * @param entries The entries that will be added to the args map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder args(Map<String, ? extends String> entries) {
      this.args.clear();
      return putAllArgs(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MongosConfig#args() args} map. Nulls are not permitted
     * @param entries The entries that will be added to the args map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllArgs(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.args.put(
            Objects.requireNonNull(k, "args key"),
            Objects.requireNonNull(v, "args value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MongosConfig#pidFile() pidFile} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongosConfig#pidFile() pidFile}.</em>
     * @param pidFile The value for pidFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pidFile(String pidFile) {
      this.pidFile = Objects.requireNonNull(pidFile, "pidFile");
      return this;
    }

    /**
     * Initializes the value for the {@link MongosConfig#supportConfig() supportConfig} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongosConfig#supportConfig() supportConfig}.</em>
     * @param supportConfig The value for supportConfig 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportConfig(SupportConfig supportConfig) {
      this.supportConfig = Objects.requireNonNull(supportConfig, "supportConfig");
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongosConfig ImmutableMongosConfig}.
     * @return An immutable instance of MongosConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongosConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMongosConfig(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_CONFIG_D_B) != 0) attributes.add("configDB");
      return "Cannot build MongosConfig, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
