/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.distribution;

import de.flapdoodle.embed.mongo.distribution.ImmutableNumericVersion;
import org.immutables.value.Value;

@Value.Immutable
public interface NumericVersion {
    @Value.Parameter
    public int major();

    @Value.Parameter
    public int minor();

    @Value.Parameter
    public int patch();

    public static NumericVersion of(int major, int minor, int patch) {
        return ImmutableNumericVersion.of(major, minor, patch);
    }

    public static NumericVersion of(String versionString) {
        int patch;
        int minor;
        int major;
        if ("latest".equals(versionString)) {
            major = Integer.MAX_VALUE;
            minor = Integer.MAX_VALUE;
            patch = Integer.MAX_VALUE;
        } else {
            String[] semverParts = versionString.split("\\.", 3);
            major = Integer.parseInt(semverParts[0], 10);
            minor = Integer.parseInt(semverParts[1], 10);
            String semverPart3 = semverParts[2];
            int idxOfDash = semverPart3.indexOf(45);
            if (idxOfDash > 0) {
                semverPart3 = semverPart3.substring(0, idxOfDash);
            }
            patch = Integer.parseInt(semverPart3, 10);
        }
        return NumericVersion.of(major, minor, patch);
    }

    default public boolean isNewerOrEqual(int major, int minor, int patch) {
        return this.isNewerOrEqual(NumericVersion.of(major, minor, patch));
    }

    default public boolean isOlderOrEqual(int major, int minor, int patch) {
        return this.isOlderOrEqual(NumericVersion.of(major, minor, patch));
    }

    default public boolean isNewerOrEqual(NumericVersion other) {
        return this.isNewer(other) || this.isEqual(other);
    }

    default public boolean isNewer(NumericVersion other) {
        if (this.major() > other.major()) {
            return true;
        }
        if (this.major() == other.major()) {
            if (this.minor() > other.minor()) {
                return true;
            }
            if (this.minor() == other.minor()) {
                return this.patch() > other.patch();
            }
        }
        return false;
    }

    default public boolean isOlderOrEqual(NumericVersion other) {
        return this.isOlder(other) || this.isEqual(other);
    }

    default public boolean isOlder(NumericVersion other) {
        if (this.major() < other.major()) {
            return true;
        }
        if (this.major() == other.major()) {
            if (this.minor() < other.minor()) {
                return true;
            }
            if (this.minor() == other.minor()) {
                return this.patch() < other.patch();
            }
        }
        return false;
    }

    default public boolean isEqual(NumericVersion other) {
        return this.major() == other.major() && this.minor() == other.minor() && this.patch() == other.patch();
    }

    default public boolean isNextOrPrevPatch(NumericVersion other) {
        if (this.major() != other.major()) {
            return false;
        }
        if (this.minor() != other.minor()) {
            return false;
        }
        return Math.abs(this.patch() - other.patch()) == 1;
    }
}

