/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.OS;
import java.util.Optional;

public class SolarisPackageFinder
implements PackageFinder {
    private final Command command;
    private final PlatformMatchRules rules;

    public SolarisPackageFinder(Command command) {
        this.command = command;
        this.rules = SolarisPackageFinder.rules(command);
    }

    @Override
    public Optional<DistributionPackage> packageFor(Distribution distribution) {
        return this.rules.packageFor(distribution);
    }

    private static FileSet fileSetOf(Command command) {
        return FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
    }

    private static PlatformMatchRules rules(Command command) {
        FileSet fileSet = SolarisPackageFinder.fileSetOf(command);
        ArchiveType archiveType = ArchiveType.TGZ;
        ImmutablePlatformMatchRule firstRule = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("3.4.0", "3.4.5"), VersionRange.of("3.2.0", "3.2.14"), VersionRange.of("3.0.0", "3.0.14"), VersionRange.of("2.6.0", "2.6.12")).andThen(PlatformMatch.withOs(OS.Solaris).withBitSize(BitSize.B64))).finder(UrlTemplatePackageResolver.builder().fileSet(fileSet).archiveType(archiveType).urlTemplate("/sunos5/mongodb-sunos5-x86_64-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule hiddenLegacyRule = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("3.3.1", "3.3.1"), VersionRange.of("3.5.5", "3.5.5")).andThen(PlatformMatch.withOs(OS.Solaris).withBitSize(BitSize.B64))).finder(UrlTemplatePackageResolver.builder().fileSet(fileSet).archiveType(archiveType).urlTemplate("/sunos5/mongodb-sunos5-x86_64-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule failIfNothingMatches = PlatformMatchRule.builder().match(PlatformMatch.withOs(OS.Solaris)).finder(distribution -> {
            throw new IllegalArgumentException("osx distribution not supported: " + distribution);
        }).build();
        return PlatformMatchRules.empty().withRules(firstRule, hiddenLegacyRule, failIfNothingMatches);
    }
}

