/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.distribution;

import de.flapdoodle.embed.mongo.distribution.NumericVersion;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="NumericVersion", generator="Immutables")
public final class ImmutableNumericVersion
implements NumericVersion {
    private final int major;
    private final int minor;
    private final int patch;

    private ImmutableNumericVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    @Override
    public int major() {
        return this.major;
    }

    @Override
    public int minor() {
        return this.minor;
    }

    @Override
    public int patch() {
        return this.patch;
    }

    public final ImmutableNumericVersion withMajor(int value) {
        if (this.major == value) {
            return this;
        }
        return new ImmutableNumericVersion(value, this.minor, this.patch);
    }

    public final ImmutableNumericVersion withMinor(int value) {
        if (this.minor == value) {
            return this;
        }
        return new ImmutableNumericVersion(this.major, value, this.patch);
    }

    public final ImmutableNumericVersion withPatch(int value) {
        if (this.patch == value) {
            return this;
        }
        return new ImmutableNumericVersion(this.major, this.minor, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNumericVersion && this.equalTo((ImmutableNumericVersion)another);
    }

    private boolean equalTo(ImmutableNumericVersion another) {
        return this.major == another.major && this.minor == another.minor && this.patch == another.patch;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.major;
        h += (h << 5) + this.minor;
        h += (h << 5) + this.patch;
        return h;
    }

    public String toString() {
        return "NumericVersion{major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + "}";
    }

    public static ImmutableNumericVersion of(int major, int minor, int patch) {
        return new ImmutableNumericVersion(major, minor, patch);
    }

    public static ImmutableNumericVersion copyOf(NumericVersion instance) {
        if (instance instanceof ImmutableNumericVersion) {
            return (ImmutableNumericVersion)instance;
        }
        return ImmutableNumericVersion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NumericVersion", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MAJOR = 1L;
        private static final long INIT_BIT_MINOR = 2L;
        private static final long INIT_BIT_PATCH = 4L;
        private long initBits = 7L;
        private int major;
        private int minor;
        private int patch;

        private Builder() {
        }

        public final Builder from(NumericVersion instance) {
            Objects.requireNonNull(instance, "instance");
            this.major(instance.major());
            this.minor(instance.minor());
            this.patch(instance.patch());
            return this;
        }

        public final Builder major(int major) {
            this.major = major;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder minor(int minor) {
            this.minor = minor;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder patch(int patch) {
            this.patch = patch;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableNumericVersion build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNumericVersion(this.major, this.minor, this.patch);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("major");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("minor");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("patch");
            }
            return "Cannot build NumericVersion, some of required attributes are not set " + attributes;
        }
    }
}

