/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.distribution;

import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.packageresolver.Feature;
import de.flapdoodle.embed.mongo.packageresolver.FeatureSet;
import de.flapdoodle.embed.mongo.packageresolver.FeatureSetResolver;
import de.flapdoodle.embed.mongo.packageresolver.NumericVersion;
import de.flapdoodle.embed.process.distribution.Version;

public class Versions {
    private Versions() {
    }

    public static IFeatureAwareVersion withFeatures(Version version, Feature ... features) {
        return new GenericFeatureAwareVersion(version);
    }

    static class GenericFeatureAwareVersion
    implements IFeatureAwareVersion {
        private final Version _version;
        private final FeatureSet _features;

        public GenericFeatureAwareVersion(Version version) {
            this._version = version;
            this._features = FeatureSetResolver.defaultInstance().featuresOf(version);
        }

        public String asInDownloadPath() {
            return this._version.asInDownloadPath();
        }

        @Override
        public FeatureSet getFeatures() {
            return this._features;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._features == null ? 0 : this._features.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GenericFeatureAwareVersion other = (GenericFeatureAwareVersion)obj;
            if (this._features == null ? other._features != null : !this._features.equals(other._features)) {
                return false;
            }
            return !(this._version == null ? other._version != null : !this._version.equals(other._version));
        }

        @Override
        public NumericVersion numericVersion() {
            throw new IllegalArgumentException("not implemented");
        }

        public String toString() {
            return "GenericFeatureAwareVersion{" + this._version.asInDownloadPath() + "}";
        }
    }
}

