package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.SupportConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongoImportConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongoImportConfig.builder()}.
 */
@Generated(from = "MongoImportConfig", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableMongoImportConfig implements MongoImportConfig {
  private final Long stopTimeoutInMillis;
  private final IFeatureAwareVersion version;
  private final Timeout timeout;
  private final Net net;
  private final MongoCmdOptions cmdOptions;
  private final String password;
  private final String userName;
  private final String databaseName;
  private final String collectionName;
  private final String importFile;
  private final String type;
  private final boolean isHeaderline;
  private final boolean isJsonArray;
  private final boolean isDropCollection;
  private final boolean isUpsertDocuments;
  private final String pidFile;
  private final SupportConfig supportConfig;

  private ImmutableMongoImportConfig(ImmutableMongoImportConfig.Builder builder) {
    this.stopTimeoutInMillis = builder.stopTimeoutInMillis;
    this.version = builder.version;
    this.databaseName = builder.databaseName;
    this.collectionName = builder.collectionName;
    this.importFile = builder.importFile;
    this.isJsonArray = builder.isJsonArray;
    this.isDropCollection = builder.isDropCollection;
    this.isUpsertDocuments = builder.isUpsertDocuments;
    if (builder.timeout != null) {
      initShim.timeout(builder.timeout);
    }
    if (builder.net != null) {
      initShim.net(builder.net);
    }
    if (builder.cmdOptions != null) {
      initShim.cmdOptions(builder.cmdOptions);
    }
    if (builder.password != null) {
      initShim.password(builder.password);
    }
    if (builder.userName != null) {
      initShim.userName(builder.userName);
    }
    if (builder.type != null) {
      initShim.type(builder.type);
    }
    if (builder.isHeaderlineIsSet()) {
      initShim.isHeaderline(builder.isHeaderline);
    }
    if (builder.pidFile != null) {
      initShim.pidFile(builder.pidFile);
    }
    if (builder.supportConfig != null) {
      initShim.supportConfig(builder.supportConfig);
    }
    this.timeout = initShim.timeout();
    this.net = initShim.net();
    this.cmdOptions = initShim.cmdOptions();
    this.password = initShim.password();
    this.userName = initShim.userName();
    this.type = initShim.getType();
    this.isHeaderline = initShim.isHeaderline();
    this.pidFile = initShim.pidFile();
    this.supportConfig = initShim.supportConfig();
    this.initShim = null;
  }

  private ImmutableMongoImportConfig(
      Long stopTimeoutInMillis,
      IFeatureAwareVersion version,
      Timeout timeout,
      Net net,
      MongoCmdOptions cmdOptions,
      String password,
      String userName,
      String databaseName,
      String collectionName,
      String importFile,
      String type,
      boolean isHeaderline,
      boolean isJsonArray,
      boolean isDropCollection,
      boolean isUpsertDocuments,
      String pidFile,
      SupportConfig supportConfig) {
    this.stopTimeoutInMillis = stopTimeoutInMillis;
    this.version = version;
    this.timeout = timeout;
    this.net = net;
    this.cmdOptions = cmdOptions;
    this.password = password;
    this.userName = userName;
    this.databaseName = databaseName;
    this.collectionName = collectionName;
    this.importFile = importFile;
    this.type = type;
    this.isHeaderline = isHeaderline;
    this.isJsonArray = isJsonArray;
    this.isDropCollection = isDropCollection;
    this.isUpsertDocuments = isUpsertDocuments;
    this.pidFile = pidFile;
    this.supportConfig = supportConfig;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MongoImportConfig", generator = "Immutables")
  private final class InitShim {
    private byte timeoutBuildStage = STAGE_UNINITIALIZED;
    private Timeout timeout;

    Timeout timeout() {
      if (timeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (timeoutBuildStage == STAGE_UNINITIALIZED) {
        timeoutBuildStage = STAGE_INITIALIZING;
        this.timeout = Objects.requireNonNull(timeoutInitialize(), "timeout");
        timeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.timeout;
    }

    void timeout(Timeout timeout) {
      this.timeout = timeout;
      timeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte netBuildStage = STAGE_UNINITIALIZED;
    private Net net;

    Net net() {
      if (netBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (netBuildStage == STAGE_UNINITIALIZED) {
        netBuildStage = STAGE_INITIALIZING;
        this.net = Objects.requireNonNull(netInitialize(), "net");
        netBuildStage = STAGE_INITIALIZED;
      }
      return this.net;
    }

    void net(Net net) {
      this.net = net;
      netBuildStage = STAGE_INITIALIZED;
    }

    private byte cmdOptionsBuildStage = STAGE_UNINITIALIZED;
    private MongoCmdOptions cmdOptions;

    MongoCmdOptions cmdOptions() {
      if (cmdOptionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (cmdOptionsBuildStage == STAGE_UNINITIALIZED) {
        cmdOptionsBuildStage = STAGE_INITIALIZING;
        this.cmdOptions = Objects.requireNonNull(cmdOptionsInitialize(), "cmdOptions");
        cmdOptionsBuildStage = STAGE_INITIALIZED;
      }
      return this.cmdOptions;
    }

    void cmdOptions(MongoCmdOptions cmdOptions) {
      this.cmdOptions = cmdOptions;
      cmdOptionsBuildStage = STAGE_INITIALIZED;
    }

    private byte passwordBuildStage = STAGE_UNINITIALIZED;
    private String password;

    String password() {
      if (passwordBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (passwordBuildStage == STAGE_UNINITIALIZED) {
        passwordBuildStage = STAGE_INITIALIZING;
        this.password = Objects.requireNonNull(passwordInitialize(), "password");
        passwordBuildStage = STAGE_INITIALIZED;
      }
      return this.password;
    }

    void password(String password) {
      this.password = password;
      passwordBuildStage = STAGE_INITIALIZED;
    }

    private byte userNameBuildStage = STAGE_UNINITIALIZED;
    private String userName;

    String userName() {
      if (userNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (userNameBuildStage == STAGE_UNINITIALIZED) {
        userNameBuildStage = STAGE_INITIALIZING;
        this.userName = Objects.requireNonNull(userNameInitialize(), "userName");
        userNameBuildStage = STAGE_INITIALIZED;
      }
      return this.userName;
    }

    void userName(String userName) {
      this.userName = userName;
      userNameBuildStage = STAGE_INITIALIZED;
    }

    private byte typeBuildStage = STAGE_UNINITIALIZED;
    private String type;

    String getType() {
      if (typeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (typeBuildStage == STAGE_UNINITIALIZED) {
        typeBuildStage = STAGE_INITIALIZING;
        this.type = Objects.requireNonNull(getTypeInitialize(), "type");
        typeBuildStage = STAGE_INITIALIZED;
      }
      return this.type;
    }

    void type(String type) {
      this.type = type;
      typeBuildStage = STAGE_INITIALIZED;
    }

    private byte isHeaderlineBuildStage = STAGE_UNINITIALIZED;
    private boolean isHeaderline;

    boolean isHeaderline() {
      if (isHeaderlineBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isHeaderlineBuildStage == STAGE_UNINITIALIZED) {
        isHeaderlineBuildStage = STAGE_INITIALIZING;
        this.isHeaderline = isHeaderlineInitialize();
        isHeaderlineBuildStage = STAGE_INITIALIZED;
      }
      return this.isHeaderline;
    }

    void isHeaderline(boolean isHeaderline) {
      this.isHeaderline = isHeaderline;
      isHeaderlineBuildStage = STAGE_INITIALIZED;
    }

    private byte pidFileBuildStage = STAGE_UNINITIALIZED;
    private String pidFile;

    String pidFile() {
      if (pidFileBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pidFileBuildStage == STAGE_UNINITIALIZED) {
        pidFileBuildStage = STAGE_INITIALIZING;
        this.pidFile = Objects.requireNonNull(pidFileInitialize(), "pidFile");
        pidFileBuildStage = STAGE_INITIALIZED;
      }
      return this.pidFile;
    }

    void pidFile(String pidFile) {
      this.pidFile = pidFile;
      pidFileBuildStage = STAGE_INITIALIZED;
    }

    private byte supportConfigBuildStage = STAGE_UNINITIALIZED;
    private SupportConfig supportConfig;

    SupportConfig supportConfig() {
      if (supportConfigBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (supportConfigBuildStage == STAGE_UNINITIALIZED) {
        supportConfigBuildStage = STAGE_INITIALIZING;
        this.supportConfig = Objects.requireNonNull(supportConfigInitialize(), "supportConfig");
        supportConfigBuildStage = STAGE_INITIALIZED;
      }
      return this.supportConfig;
    }

    void supportConfig(SupportConfig supportConfig) {
      this.supportConfig = supportConfig;
      supportConfigBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (timeoutBuildStage == STAGE_INITIALIZING) attributes.add("timeout");
      if (netBuildStage == STAGE_INITIALIZING) attributes.add("net");
      if (cmdOptionsBuildStage == STAGE_INITIALIZING) attributes.add("cmdOptions");
      if (passwordBuildStage == STAGE_INITIALIZING) attributes.add("password");
      if (userNameBuildStage == STAGE_INITIALIZING) attributes.add("userName");
      if (typeBuildStage == STAGE_INITIALIZING) attributes.add("type");
      if (isHeaderlineBuildStage == STAGE_INITIALIZING) attributes.add("isHeaderline");
      if (pidFileBuildStage == STAGE_INITIALIZING) attributes.add("pidFile");
      if (supportConfigBuildStage == STAGE_INITIALIZING) attributes.add("supportConfig");
      return "Cannot build MongoImportConfig, attribute initializers form cycle " + attributes;
    }
  }

  private Timeout timeoutInitialize() {
    return MongoImportConfig.super.timeout();
  }

  private Net netInitialize() {
    return MongoImportConfig.super.net();
  }

  private MongoCmdOptions cmdOptionsInitialize() {
    return MongoImportConfig.super.cmdOptions();
  }

  private String passwordInitialize() {
    return MongoImportConfig.super.password();
  }

  private String userNameInitialize() {
    return MongoImportConfig.super.userName();
  }

  private String getTypeInitialize() {
    return MongoImportConfig.super.getType();
  }

  private boolean isHeaderlineInitialize() {
    return MongoImportConfig.super.isHeaderline();
  }

  private String pidFileInitialize() {
    return MongoImportConfig.super.pidFile();
  }

  private SupportConfig supportConfigInitialize() {
    return MongoImportConfig.super.supportConfig();
  }

  /**
   * @return The value of the {@code stopTimeoutInMillis} attribute
   */
  @Override
  public OptionalLong stopTimeoutInMillis() {
    return stopTimeoutInMillis != null
        ? OptionalLong.of(stopTimeoutInMillis)
        : OptionalLong.empty();
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @Override
  public IFeatureAwareVersion version() {
    return version;
  }

  /**
   * @return The value of the {@code timeout} attribute
   */
  @Override
  public Timeout timeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.timeout()
        : this.timeout;
  }

  /**
   * @return The value of the {@code net} attribute
   */
  @Override
  public Net net() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.net()
        : this.net;
  }

  /**
   * @return The value of the {@code cmdOptions} attribute
   */
  @Override
  public MongoCmdOptions cmdOptions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.cmdOptions()
        : this.cmdOptions;
  }

  /**
   * @return The value of the {@code password} attribute
   */
  @Override
  public String password() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.password()
        : this.password;
  }

  /**
   * @return The value of the {@code userName} attribute
   */
  @Override
  public String userName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.userName()
        : this.userName;
  }

  /**
   * @return The value of the {@code databaseName} attribute
   */
  @Override
  public String getDatabaseName() {
    return databaseName;
  }

  /**
   * @return The value of the {@code collectionName} attribute
   */
  @Override
  public String getCollectionName() {
    return collectionName;
  }

  /**
   * @return The value of the {@code importFile} attribute
   */
  @Override
  public String getImportFile() {
    return importFile;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public String getType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getType()
        : this.type;
  }

  /**
   * @return The value of the {@code isHeaderline} attribute
   */
  @Override
  public boolean isHeaderline() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isHeaderline()
        : this.isHeaderline;
  }

  /**
   * @return The value of the {@code isJsonArray} attribute
   */
  @Override
  public boolean isJsonArray() {
    return isJsonArray;
  }

  /**
   * @return The value of the {@code isDropCollection} attribute
   */
  @Override
  public boolean isDropCollection() {
    return isDropCollection;
  }

  /**
   * @return The value of the {@code isUpsertDocuments} attribute
   */
  @Override
  public boolean isUpsertDocuments() {
    return isUpsertDocuments;
  }

  /**
   * @return The value of the {@code pidFile} attribute
   */
  @Override
  public String pidFile() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.pidFile()
        : this.pidFile;
  }

  /**
   * @return The value of the {@code supportConfig} attribute
   */
  @Override
  public SupportConfig supportConfig() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.supportConfig()
        : this.supportConfig;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoImportConfig#stopTimeoutInMillis() stopTimeoutInMillis} attribute.
   * @param value The value for stopTimeoutInMillis
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoImportConfig withStopTimeoutInMillis(long value) {
    Long newValue = value;
    if (Objects.equals(this.stopTimeoutInMillis, newValue)) return this;
    return new ImmutableMongoImportConfig(
        newValue,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoImportConfig#stopTimeoutInMillis() stopTimeoutInMillis} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for stopTimeoutInMillis
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoImportConfig withStopTimeoutInMillis(OptionalLong optional) {
    Long value = optional.isPresent() ? optional.getAsLong() : null;
    if (Objects.equals(this.stopTimeoutInMillis, value)) return this;
    return new ImmutableMongoImportConfig(
        value,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#version() version} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withVersion(IFeatureAwareVersion value) {
    if (this.version == value) return this;
    IFeatureAwareVersion newValue = Objects.requireNonNull(value, "version");
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        newValue,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#timeout() timeout} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timeout
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withTimeout(Timeout value) {
    if (this.timeout == value) return this;
    Timeout newValue = Objects.requireNonNull(value, "timeout");
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        newValue,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#net() net} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for net
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withNet(Net value) {
    if (this.net == value) return this;
    Net newValue = Objects.requireNonNull(value, "net");
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        newValue,
        this.cmdOptions,
        this.password,
        this.userName,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#cmdOptions() cmdOptions} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cmdOptions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withCmdOptions(MongoCmdOptions value) {
    if (this.cmdOptions == value) return this;
    MongoCmdOptions newValue = Objects.requireNonNull(value, "cmdOptions");
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        newValue,
        this.password,
        this.userName,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#password() password} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for password
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withPassword(String value) {
    String newValue = Objects.requireNonNull(value, "password");
    if (this.password.equals(newValue)) return this;
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        newValue,
        this.userName,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#userName() userName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withUserName(String value) {
    String newValue = Objects.requireNonNull(value, "userName");
    if (this.userName.equals(newValue)) return this;
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        newValue,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#getDatabaseName() databaseName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for databaseName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withDatabaseName(String value) {
    String newValue = Objects.requireNonNull(value, "databaseName");
    if (this.databaseName.equals(newValue)) return this;
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        newValue,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#getCollectionName() collectionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collectionName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withCollectionName(String value) {
    String newValue = Objects.requireNonNull(value, "collectionName");
    if (this.collectionName.equals(newValue)) return this;
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.databaseName,
        newValue,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#getImportFile() importFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for importFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withImportFile(String value) {
    String newValue = Objects.requireNonNull(value, "importFile");
    if (this.importFile.equals(newValue)) return this;
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.databaseName,
        this.collectionName,
        newValue,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.databaseName,
        this.collectionName,
        this.importFile,
        newValue,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#isHeaderline() isHeaderline} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isHeaderline
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withIsHeaderline(boolean value) {
    if (this.isHeaderline == value) return this;
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        value,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#isJsonArray() isJsonArray} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isJsonArray
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withIsJsonArray(boolean value) {
    if (this.isJsonArray == value) return this;
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        value,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#isDropCollection() isDropCollection} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isDropCollection
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withIsDropCollection(boolean value) {
    if (this.isDropCollection == value) return this;
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        value,
        this.isUpsertDocuments,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#isUpsertDocuments() isUpsertDocuments} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isUpsertDocuments
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withIsUpsertDocuments(boolean value) {
    if (this.isUpsertDocuments == value) return this;
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        value,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#pidFile() pidFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pidFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withPidFile(String value) {
    String newValue = Objects.requireNonNull(value, "pidFile");
    if (this.pidFile.equals(newValue)) return this;
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        newValue,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportConfig#supportConfig() supportConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for supportConfig
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoImportConfig withSupportConfig(SupportConfig value) {
    if (this.supportConfig == value) return this;
    SupportConfig newValue = Objects.requireNonNull(value, "supportConfig");
    return new ImmutableMongoImportConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.isDropCollection,
        this.isUpsertDocuments,
        this.pidFile,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoImportConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoImportConfig
        && equalTo(0, (ImmutableMongoImportConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableMongoImportConfig another) {
    return Objects.equals(stopTimeoutInMillis, another.stopTimeoutInMillis)
        && version.equals(another.version)
        && timeout.equals(another.timeout)
        && net.equals(another.net)
        && cmdOptions.equals(another.cmdOptions)
        && password.equals(another.password)
        && userName.equals(another.userName)
        && databaseName.equals(another.databaseName)
        && collectionName.equals(another.collectionName)
        && importFile.equals(another.importFile)
        && type.equals(another.type)
        && isHeaderline == another.isHeaderline
        && isJsonArray == another.isJsonArray
        && isDropCollection == another.isDropCollection
        && isUpsertDocuments == another.isUpsertDocuments
        && pidFile.equals(another.pidFile)
        && supportConfig.equals(another.supportConfig);
  }

  /**
   * Computes a hash code from attributes: {@code stopTimeoutInMillis}, {@code version}, {@code timeout}, {@code net}, {@code cmdOptions}, {@code password}, {@code userName}, {@code databaseName}, {@code collectionName}, {@code importFile}, {@code type}, {@code isHeaderline}, {@code isJsonArray}, {@code isDropCollection}, {@code isUpsertDocuments}, {@code pidFile}, {@code supportConfig}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(stopTimeoutInMillis);
    h += (h << 5) + version.hashCode();
    h += (h << 5) + timeout.hashCode();
    h += (h << 5) + net.hashCode();
    h += (h << 5) + cmdOptions.hashCode();
    h += (h << 5) + password.hashCode();
    h += (h << 5) + userName.hashCode();
    h += (h << 5) + databaseName.hashCode();
    h += (h << 5) + collectionName.hashCode();
    h += (h << 5) + importFile.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Boolean.hashCode(isHeaderline);
    h += (h << 5) + Boolean.hashCode(isJsonArray);
    h += (h << 5) + Boolean.hashCode(isDropCollection);
    h += (h << 5) + Boolean.hashCode(isUpsertDocuments);
    h += (h << 5) + pidFile.hashCode();
    h += (h << 5) + supportConfig.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongoImportConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("MongoImportConfig{");
    if (stopTimeoutInMillis != null) {
      builder.append("stopTimeoutInMillis=").append(stopTimeoutInMillis);
    }
    if (builder.length() > 18) builder.append(", ");
    builder.append("version=").append(version);
    builder.append(", ");
    builder.append("timeout=").append(timeout);
    builder.append(", ");
    builder.append("net=").append(net);
    builder.append(", ");
    builder.append("cmdOptions=").append(cmdOptions);
    builder.append(", ");
    builder.append("password=").append(password);
    builder.append(", ");
    builder.append("userName=").append(userName);
    builder.append(", ");
    builder.append("databaseName=").append(databaseName);
    builder.append(", ");
    builder.append("collectionName=").append(collectionName);
    builder.append(", ");
    builder.append("importFile=").append(importFile);
    builder.append(", ");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("isHeaderline=").append(isHeaderline);
    builder.append(", ");
    builder.append("isJsonArray=").append(isJsonArray);
    builder.append(", ");
    builder.append("isDropCollection=").append(isDropCollection);
    builder.append(", ");
    builder.append("isUpsertDocuments=").append(isUpsertDocuments);
    builder.append(", ");
    builder.append("pidFile=").append(pidFile);
    builder.append(", ");
    builder.append("supportConfig=").append(supportConfig);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link MongoImportConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoImportConfig instance
   */
  public static ImmutableMongoImportConfig copyOf(MongoImportConfig instance) {
    if (instance instanceof ImmutableMongoImportConfig) {
      return (ImmutableMongoImportConfig) instance;
    }
    return ImmutableMongoImportConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongoImportConfig ImmutableMongoImportConfig}.
   * <pre>
   * ImmutableMongoImportConfig.builder()
   *    .stopTimeoutInMillis(long) // optional {@link MongoImportConfig#stopTimeoutInMillis() stopTimeoutInMillis}
   *    .version(de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion) // required {@link MongoImportConfig#version() version}
   *    .timeout(de.flapdoodle.embed.mongo.config.Timeout) // optional {@link MongoImportConfig#timeout() timeout}
   *    .net(de.flapdoodle.embed.mongo.config.Net) // optional {@link MongoImportConfig#net() net}
   *    .cmdOptions(de.flapdoodle.embed.mongo.config.MongoCmdOptions) // optional {@link MongoImportConfig#cmdOptions() cmdOptions}
   *    .password(String) // optional {@link MongoImportConfig#password() password}
   *    .userName(String) // optional {@link MongoImportConfig#userName() userName}
   *    .databaseName(String) // required {@link MongoImportConfig#getDatabaseName() databaseName}
   *    .collectionName(String) // required {@link MongoImportConfig#getCollectionName() collectionName}
   *    .importFile(String) // required {@link MongoImportConfig#getImportFile() importFile}
   *    .type(String) // optional {@link MongoImportConfig#getType() type}
   *    .isHeaderline(boolean) // optional {@link MongoImportConfig#isHeaderline() isHeaderline}
   *    .isJsonArray(boolean) // required {@link MongoImportConfig#isJsonArray() isJsonArray}
   *    .isDropCollection(boolean) // required {@link MongoImportConfig#isDropCollection() isDropCollection}
   *    .isUpsertDocuments(boolean) // required {@link MongoImportConfig#isUpsertDocuments() isUpsertDocuments}
   *    .pidFile(String) // optional {@link MongoImportConfig#pidFile() pidFile}
   *    .supportConfig(de.flapdoodle.embed.process.config.SupportConfig) // optional {@link MongoImportConfig#supportConfig() supportConfig}
   *    .build();
   * </pre>
   * @return A new ImmutableMongoImportConfig builder
   */
  public static ImmutableMongoImportConfig.Builder builder() {
    return new ImmutableMongoImportConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongoImportConfig ImmutableMongoImportConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongoImportConfig", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long INIT_BIT_DATABASE_NAME = 0x2L;
    private static final long INIT_BIT_COLLECTION_NAME = 0x4L;
    private static final long INIT_BIT_IMPORT_FILE = 0x8L;
    private static final long INIT_BIT_IS_JSON_ARRAY = 0x10L;
    private static final long INIT_BIT_IS_DROP_COLLECTION = 0x20L;
    private static final long INIT_BIT_IS_UPSERT_DOCUMENTS = 0x40L;
    private static final long OPT_BIT_IS_HEADERLINE = 0x1L;
    private long initBits = 0x7fL;
    private long optBits;

    private Long stopTimeoutInMillis;
    private IFeatureAwareVersion version;
    private Timeout timeout;
    private Net net;
    private MongoCmdOptions cmdOptions;
    private String password;
    private String userName;
    private String databaseName;
    private String collectionName;
    private String importFile;
    private String type;
    private boolean isHeaderline;
    private boolean isJsonArray;
    private boolean isDropCollection;
    private boolean isUpsertDocuments;
    private String pidFile;
    private SupportConfig supportConfig;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.config.MongoCommonConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoCommonConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.process.config.ExecutableProcessConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExecutableProcessConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.config.MongoImportConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoImportConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof MongoCommonConfig) {
        MongoCommonConfig instance = (MongoCommonConfig) object;
        if ((bits & 0x10L) == 0) {
          password(instance.password());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          supportConfig(instance.supportConfig());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          OptionalLong stopTimeoutInMillisOptional = instance.stopTimeoutInMillis();
          if (stopTimeoutInMillisOptional.isPresent()) {
            stopTimeoutInMillis(stopTimeoutInMillisOptional);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          cmdOptions(instance.cmdOptions());
          bits |= 0x80L;
        }
        if ((bits & 0x1L) == 0) {
          userName(instance.userName());
          bits |= 0x1L;
        }
        if ((bits & 0x100L) == 0) {
          net(instance.net());
          bits |= 0x100L;
        }
        if ((bits & 0x2L) == 0) {
          version(instance.version());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          timeout(instance.timeout());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          pidFile(instance.pidFile());
          bits |= 0x8L;
        }
      }
      if (object instanceof ExecutableProcessConfig) {
        ExecutableProcessConfig instance = (ExecutableProcessConfig) object;
        if ((bits & 0x20L) == 0) {
          supportConfig(instance.supportConfig());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          OptionalLong stopTimeoutInMillisOptional = instance.stopTimeoutInMillis();
          if (stopTimeoutInMillisOptional.isPresent()) {
            stopTimeoutInMillis(stopTimeoutInMillisOptional);
          }
          bits |= 0x40L;
        }
      }
      if (object instanceof MongoImportConfig) {
        MongoImportConfig instance = (MongoImportConfig) object;
        databaseName(instance.getDatabaseName());
        importFile(instance.getImportFile());
        isUpsertDocuments(instance.isUpsertDocuments());
        isJsonArray(instance.isJsonArray());
        if ((bits & 0x1L) == 0) {
          userName(instance.userName());
          bits |= 0x1L;
        }
        type(instance.getType());
        if ((bits & 0x2L) == 0) {
          version(instance.version());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          timeout(instance.timeout());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          pidFile(instance.pidFile());
          bits |= 0x8L;
        }
        collectionName(instance.getCollectionName());
        if ((bits & 0x10L) == 0) {
          password(instance.password());
          bits |= 0x10L;
        }
        isDropCollection(instance.isDropCollection());
        if ((bits & 0x20L) == 0) {
          supportConfig(instance.supportConfig());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          OptionalLong stopTimeoutInMillisOptional = instance.stopTimeoutInMillis();
          if (stopTimeoutInMillisOptional.isPresent()) {
            stopTimeoutInMillis(stopTimeoutInMillisOptional);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          cmdOptions(instance.cmdOptions());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          net(instance.net());
          bits |= 0x100L;
        }
        isHeaderline(instance.isHeaderline());
      }
    }

    /**
     * Initializes the optional value {@link MongoImportConfig#stopTimeoutInMillis() stopTimeoutInMillis} to stopTimeoutInMillis.
     * @param stopTimeoutInMillis The value for stopTimeoutInMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder stopTimeoutInMillis(long stopTimeoutInMillis) {
      this.stopTimeoutInMillis = stopTimeoutInMillis;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoImportConfig#stopTimeoutInMillis() stopTimeoutInMillis} to stopTimeoutInMillis.
     * @param stopTimeoutInMillis The value for stopTimeoutInMillis
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stopTimeoutInMillis(OptionalLong stopTimeoutInMillis) {
      this.stopTimeoutInMillis = stopTimeoutInMillis.isPresent() ? stopTimeoutInMillis.getAsLong() : null;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#version() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(IFeatureAwareVersion version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#timeout() timeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportConfig#timeout() timeout}.</em>
     * @param timeout The value for timeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timeout(Timeout timeout) {
      this.timeout = Objects.requireNonNull(timeout, "timeout");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#net() net} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportConfig#net() net}.</em>
     * @param net The value for net 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder net(Net net) {
      this.net = Objects.requireNonNull(net, "net");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#cmdOptions() cmdOptions} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportConfig#cmdOptions() cmdOptions}.</em>
     * @param cmdOptions The value for cmdOptions 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cmdOptions(MongoCmdOptions cmdOptions) {
      this.cmdOptions = Objects.requireNonNull(cmdOptions, "cmdOptions");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#password() password} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportConfig#password() password}.</em>
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#userName() userName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportConfig#userName() userName}.</em>
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#getDatabaseName() databaseName} attribute.
     * @param databaseName The value for databaseName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder databaseName(String databaseName) {
      this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
      initBits &= ~INIT_BIT_DATABASE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#getCollectionName() collectionName} attribute.
     * @param collectionName The value for collectionName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder collectionName(String collectionName) {
      this.collectionName = Objects.requireNonNull(collectionName, "collectionName");
      initBits &= ~INIT_BIT_COLLECTION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#getImportFile() importFile} attribute.
     * @param importFile The value for importFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder importFile(String importFile) {
      this.importFile = Objects.requireNonNull(importFile, "importFile");
      initBits &= ~INIT_BIT_IMPORT_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#getType() type} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportConfig#getType() type}.</em>
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#isHeaderline() isHeaderline} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportConfig#isHeaderline() isHeaderline}.</em>
     * @param isHeaderline The value for isHeaderline 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isHeaderline(boolean isHeaderline) {
      this.isHeaderline = isHeaderline;
      optBits |= OPT_BIT_IS_HEADERLINE;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#isJsonArray() isJsonArray} attribute.
     * @param isJsonArray The value for isJsonArray 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isJsonArray(boolean isJsonArray) {
      this.isJsonArray = isJsonArray;
      initBits &= ~INIT_BIT_IS_JSON_ARRAY;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#isDropCollection() isDropCollection} attribute.
     * @param isDropCollection The value for isDropCollection 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isDropCollection(boolean isDropCollection) {
      this.isDropCollection = isDropCollection;
      initBits &= ~INIT_BIT_IS_DROP_COLLECTION;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#isUpsertDocuments() isUpsertDocuments} attribute.
     * @param isUpsertDocuments The value for isUpsertDocuments 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isUpsertDocuments(boolean isUpsertDocuments) {
      this.isUpsertDocuments = isUpsertDocuments;
      initBits &= ~INIT_BIT_IS_UPSERT_DOCUMENTS;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#pidFile() pidFile} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportConfig#pidFile() pidFile}.</em>
     * @param pidFile The value for pidFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pidFile(String pidFile) {
      this.pidFile = Objects.requireNonNull(pidFile, "pidFile");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportConfig#supportConfig() supportConfig} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportConfig#supportConfig() supportConfig}.</em>
     * @param supportConfig The value for supportConfig 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportConfig(SupportConfig supportConfig) {
      this.supportConfig = Objects.requireNonNull(supportConfig, "supportConfig");
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongoImportConfig ImmutableMongoImportConfig}.
     * @return An immutable instance of MongoImportConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoImportConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMongoImportConfig(this);
    }

    private boolean isHeaderlineIsSet() {
      return (optBits & OPT_BIT_IS_HEADERLINE) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_DATABASE_NAME) != 0) attributes.add("databaseName");
      if ((initBits & INIT_BIT_COLLECTION_NAME) != 0) attributes.add("collectionName");
      if ((initBits & INIT_BIT_IMPORT_FILE) != 0) attributes.add("importFile");
      if ((initBits & INIT_BIT_IS_JSON_ARRAY) != 0) attributes.add("isJsonArray");
      if ((initBits & INIT_BIT_IS_DROP_COLLECTION) != 0) attributes.add("isDropCollection");
      if ((initBits & INIT_BIT_IS_UPSERT_DOCUMENTS) != 0) attributes.add("isUpsertDocuments");
      return "Cannot build MongoImportConfig, some of required attributes are not set " + attributes;
    }
  }
}
