/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mongod {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mongod.class);
    private static final byte[] SHUTDOWN_COMMAND = new byte[]{88, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, -44, 7, 0, 0, 0, 0, 0, 0, 97, 100, 109, 105, 110, 46, 36, 99, 109, 100, 0, 0, 0, 0, 0, -1, -1, -1, -1, 44, 0, 0, 0, 16, 115, 104, 117, 116, 100, 111, 119, 110, 0, 1, 0, 0, 0, 8, 102, 111, 114, 99, 101, 0, 1, 16, 116, 105, 109, 101, 111, 117, 116, 83, 101, 99, 115, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0};
    private static final int SOCKET_TIMEOUT = 2000;
    private static final int CONNECT_TIMEOUT = 2000;
    private static final int BYTE_BUFFER_LENGTH = 512;
    private static final int WAITING_TIME_SHUTDOWN_IN_MS = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean sendShutdown(InetAddress hostname, int port) {
        Socket s;
        boolean tryToReadErrorResponse;
        block17: {
            if (!hostname.isLoopbackAddress()) {
                LOGGER.warn("---------------------------------------\nYour localhost ({}) is not a loopback adress\nWe can NOT send shutdown to mongod, because it is denied from remote.\n---------------------------------------\n", (Object)hostname.getHostAddress());
                return false;
            }
            tryToReadErrorResponse = false;
            s = new Socket();
            s.setSoTimeout(2000);
            s.connect(new InetSocketAddress(hostname, port), 2000);
            OutputStream outputStream = s.getOutputStream();
            outputStream.write(SHUTDOWN_COMMAND);
            outputStream.flush();
            tryToReadErrorResponse = true;
            InputStream inputStream = s.getInputStream();
            if (inputStream.read(new byte[512]) == -1) break block17;
            LOGGER.error("Got some response, should be an error message");
            boolean bl = false;
            try {
                s.close();
                Thread.sleep(100L);
            }
            catch (IOException | InterruptedException ix) {
                LOGGER.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
            }
            return bl;
        }
        boolean bl = true;
        try {
            s.close();
            Thread.sleep(100L);
        }
        catch (IOException | InterruptedException ix) {
            LOGGER.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
        }
        return bl;
        catch (IOException iox) {
            block18: {
                boolean bl2;
                try {
                    if (!tryToReadErrorResponse) break block18;
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    try {
                        s.close();
                        Thread.sleep(100L);
                    }
                    catch (IOException | InterruptedException ix) {
                        LOGGER.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
                    }
                    throw throwable;
                }
                try {
                    s.close();
                    Thread.sleep(100L);
                }
                catch (IOException | InterruptedException ix) {
                    LOGGER.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
                }
                return bl2;
            }
            LOGGER.warn("sendShutdown {}:{}", new Object[]{hostname, port, iox});
            try {
                s.close();
                Thread.sleep(100L);
            }
            catch (IOException | InterruptedException ix) {
                LOGGER.warn("sendShutdown closing {}:{}", new Object[]{hostname, port, ix});
            }
        }
        return false;
    }

    public static int getMongodProcessId(String output, int defaultValue) {
        Pattern pattern = Pattern.compile("MongoDB starting : pid=([1234567890]+) port", 8);
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            String value = matcher.group(1);
            return Integer.parseInt(value);
        }
        return defaultValue;
    }
}

