package de.flapdoodle.embed.mongo.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongoDumpArguments}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongoDumpArguments.builder()}.
 */
@Generated(from = "MongoDumpArguments", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableMongoDumpArguments extends MongoDumpArguments {
  private final boolean verbose;
  private final String databaseName;
  private final String collectionName;
  private final String query;
  private final String queryFile;
  private final String readPreference;
  private final boolean forceTableScan;
  private final String archive;
  private final boolean dumpDbUsersAndRoles;
  private final boolean gzip;
  private final boolean repair;
  private final String dir;
  private final boolean isOplog;
  private final String excludeCollection;
  private final String excludeCollectionWithPrefix;
  private final Integer numberOfParallelCollections;

  private ImmutableMongoDumpArguments(ImmutableMongoDumpArguments.Builder builder) {
    this.databaseName = builder.databaseName;
    this.collectionName = builder.collectionName;
    this.query = builder.query;
    this.queryFile = builder.queryFile;
    this.readPreference = builder.readPreference;
    this.archive = builder.archive;
    this.dir = builder.dir;
    this.excludeCollection = builder.excludeCollection;
    this.excludeCollectionWithPrefix = builder.excludeCollectionWithPrefix;
    this.numberOfParallelCollections = builder.numberOfParallelCollections;
    if (builder.verboseIsSet()) {
      initShim.verbose(builder.verbose);
    }
    if (builder.forceTableScanIsSet()) {
      initShim.forceTableScan(builder.forceTableScan);
    }
    if (builder.dumpDbUsersAndRolesIsSet()) {
      initShim.dumpDbUsersAndRoles(builder.dumpDbUsersAndRoles);
    }
    if (builder.gzipIsSet()) {
      initShim.gzip(builder.gzip);
    }
    if (builder.repairIsSet()) {
      initShim.repair(builder.repair);
    }
    if (builder.isOplogIsSet()) {
      initShim.isOplog(builder.isOplog);
    }
    this.verbose = initShim.verbose();
    this.forceTableScan = initShim.forceTableScan();
    this.dumpDbUsersAndRoles = initShim.dumpDbUsersAndRoles();
    this.gzip = initShim.gzip();
    this.repair = initShim.repair();
    this.isOplog = initShim.isOplog();
    this.initShim = null;
  }

  private ImmutableMongoDumpArguments(
      boolean verbose,
      String databaseName,
      String collectionName,
      String query,
      String queryFile,
      String readPreference,
      boolean forceTableScan,
      String archive,
      boolean dumpDbUsersAndRoles,
      boolean gzip,
      boolean repair,
      String dir,
      boolean isOplog,
      String excludeCollection,
      String excludeCollectionWithPrefix,
      Integer numberOfParallelCollections) {
    this.verbose = verbose;
    this.databaseName = databaseName;
    this.collectionName = collectionName;
    this.query = query;
    this.queryFile = queryFile;
    this.readPreference = readPreference;
    this.forceTableScan = forceTableScan;
    this.archive = archive;
    this.dumpDbUsersAndRoles = dumpDbUsersAndRoles;
    this.gzip = gzip;
    this.repair = repair;
    this.dir = dir;
    this.isOplog = isOplog;
    this.excludeCollection = excludeCollection;
    this.excludeCollectionWithPrefix = excludeCollectionWithPrefix;
    this.numberOfParallelCollections = numberOfParallelCollections;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MongoDumpArguments", generator = "Immutables")
  private final class InitShim {
    private byte verboseBuildStage = STAGE_UNINITIALIZED;
    private boolean verbose;

    boolean verbose() {
      if (verboseBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (verboseBuildStage == STAGE_UNINITIALIZED) {
        verboseBuildStage = STAGE_INITIALIZING;
        this.verbose = ImmutableMongoDumpArguments.super.verbose();
        verboseBuildStage = STAGE_INITIALIZED;
      }
      return this.verbose;
    }

    void verbose(boolean verbose) {
      this.verbose = verbose;
      verboseBuildStage = STAGE_INITIALIZED;
    }

    private byte forceTableScanBuildStage = STAGE_UNINITIALIZED;
    private boolean forceTableScan;

    boolean forceTableScan() {
      if (forceTableScanBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (forceTableScanBuildStage == STAGE_UNINITIALIZED) {
        forceTableScanBuildStage = STAGE_INITIALIZING;
        this.forceTableScan = ImmutableMongoDumpArguments.super.forceTableScan();
        forceTableScanBuildStage = STAGE_INITIALIZED;
      }
      return this.forceTableScan;
    }

    void forceTableScan(boolean forceTableScan) {
      this.forceTableScan = forceTableScan;
      forceTableScanBuildStage = STAGE_INITIALIZED;
    }

    private byte dumpDbUsersAndRolesBuildStage = STAGE_UNINITIALIZED;
    private boolean dumpDbUsersAndRoles;

    boolean dumpDbUsersAndRoles() {
      if (dumpDbUsersAndRolesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dumpDbUsersAndRolesBuildStage == STAGE_UNINITIALIZED) {
        dumpDbUsersAndRolesBuildStage = STAGE_INITIALIZING;
        this.dumpDbUsersAndRoles = ImmutableMongoDumpArguments.super.dumpDbUsersAndRoles();
        dumpDbUsersAndRolesBuildStage = STAGE_INITIALIZED;
      }
      return this.dumpDbUsersAndRoles;
    }

    void dumpDbUsersAndRoles(boolean dumpDbUsersAndRoles) {
      this.dumpDbUsersAndRoles = dumpDbUsersAndRoles;
      dumpDbUsersAndRolesBuildStage = STAGE_INITIALIZED;
    }

    private byte gzipBuildStage = STAGE_UNINITIALIZED;
    private boolean gzip;

    boolean gzip() {
      if (gzipBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (gzipBuildStage == STAGE_UNINITIALIZED) {
        gzipBuildStage = STAGE_INITIALIZING;
        this.gzip = ImmutableMongoDumpArguments.super.gzip();
        gzipBuildStage = STAGE_INITIALIZED;
      }
      return this.gzip;
    }

    void gzip(boolean gzip) {
      this.gzip = gzip;
      gzipBuildStage = STAGE_INITIALIZED;
    }

    private byte repairBuildStage = STAGE_UNINITIALIZED;
    private boolean repair;

    boolean repair() {
      if (repairBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (repairBuildStage == STAGE_UNINITIALIZED) {
        repairBuildStage = STAGE_INITIALIZING;
        this.repair = ImmutableMongoDumpArguments.super.repair();
        repairBuildStage = STAGE_INITIALIZED;
      }
      return this.repair;
    }

    void repair(boolean repair) {
      this.repair = repair;
      repairBuildStage = STAGE_INITIALIZED;
    }

    private byte isOplogBuildStage = STAGE_UNINITIALIZED;
    private boolean isOplog;

    boolean isOplog() {
      if (isOplogBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isOplogBuildStage == STAGE_UNINITIALIZED) {
        isOplogBuildStage = STAGE_INITIALIZING;
        this.isOplog = ImmutableMongoDumpArguments.super.isOplog();
        isOplogBuildStage = STAGE_INITIALIZED;
      }
      return this.isOplog;
    }

    void isOplog(boolean isOplog) {
      this.isOplog = isOplog;
      isOplogBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (verboseBuildStage == STAGE_INITIALIZING) attributes.add("verbose");
      if (forceTableScanBuildStage == STAGE_INITIALIZING) attributes.add("forceTableScan");
      if (dumpDbUsersAndRolesBuildStage == STAGE_INITIALIZING) attributes.add("dumpDbUsersAndRoles");
      if (gzipBuildStage == STAGE_INITIALIZING) attributes.add("gzip");
      if (repairBuildStage == STAGE_INITIALIZING) attributes.add("repair");
      if (isOplogBuildStage == STAGE_INITIALIZING) attributes.add("isOplog");
      return "Cannot build MongoDumpArguments, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code verbose} attribute
   */
  @Override
  public boolean verbose() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.verbose()
        : this.verbose;
  }

  /**
   * @return The value of the {@code databaseName} attribute
   */
  @Override
  public Optional<String> databaseName() {
    return Optional.ofNullable(databaseName);
  }

  /**
   * @return The value of the {@code collectionName} attribute
   */
  @Override
  public Optional<String> collectionName() {
    return Optional.ofNullable(collectionName);
  }

  /**
   * @return The value of the {@code query} attribute
   */
  @Override
  public Optional<String> query() {
    return Optional.ofNullable(query);
  }

  /**
   * @return The value of the {@code queryFile} attribute
   */
  @Override
  public Optional<String> queryFile() {
    return Optional.ofNullable(queryFile);
  }

  /**
   * @return The value of the {@code readPreference} attribute
   */
  @Override
  public Optional<String> readPreference() {
    return Optional.ofNullable(readPreference);
  }

  /**
   * @return The value of the {@code forceTableScan} attribute
   */
  @Override
  public boolean forceTableScan() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.forceTableScan()
        : this.forceTableScan;
  }

  /**
   * @return The value of the {@code archive} attribute
   */
  @Override
  public Optional<String> archive() {
    return Optional.ofNullable(archive);
  }

  /**
   * @return The value of the {@code dumpDbUsersAndRoles} attribute
   */
  @Override
  public boolean dumpDbUsersAndRoles() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.dumpDbUsersAndRoles()
        : this.dumpDbUsersAndRoles;
  }

  /**
   * @return The value of the {@code gzip} attribute
   */
  @Override
  public boolean gzip() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.gzip()
        : this.gzip;
  }

  /**
   * @return The value of the {@code repair} attribute
   */
  @Override
  public boolean repair() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.repair()
        : this.repair;
  }

  /**
   * @return The value of the {@code dir} attribute
   */
  @Override
  public Optional<String> dir() {
    return Optional.ofNullable(dir);
  }

  /**
   * @return The value of the {@code isOplog} attribute
   */
  @Override
  public boolean isOplog() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isOplog()
        : this.isOplog;
  }

  /**
   * @return The value of the {@code excludeCollection} attribute
   */
  @Override
  public Optional<String> excludeCollection() {
    return Optional.ofNullable(excludeCollection);
  }

  /**
   * @return The value of the {@code excludeCollectionWithPrefix} attribute
   */
  @Override
  public Optional<String> excludeCollectionWithPrefix() {
    return Optional.ofNullable(excludeCollectionWithPrefix);
  }

  /**
   * @return The value of the {@code numberOfParallelCollections} attribute
   */
  @Override
  public OptionalInt numberOfParallelCollections() {
    return numberOfParallelCollections != null
        ? OptionalInt.of(numberOfParallelCollections)
        : OptionalInt.empty();
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpArguments#verbose() verbose} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verbose
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpArguments withVerbose(boolean value) {
    if (this.verbose == value) return this;
    return new ImmutableMongoDumpArguments(
        value,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpArguments#databaseName() databaseName} attribute.
   * @param value The value for databaseName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withDatabaseName(String value) {
    String newValue = Objects.requireNonNull(value, "databaseName");
    if (Objects.equals(this.databaseName, newValue)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        newValue,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpArguments#databaseName() databaseName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for databaseName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withDatabaseName(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.databaseName, value)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        value,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpArguments#collectionName() collectionName} attribute.
   * @param value The value for collectionName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withCollectionName(String value) {
    String newValue = Objects.requireNonNull(value, "collectionName");
    if (Objects.equals(this.collectionName, newValue)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        newValue,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpArguments#collectionName() collectionName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for collectionName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withCollectionName(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.collectionName, value)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        value,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpArguments#query() query} attribute.
   * @param value The value for query
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withQuery(String value) {
    String newValue = Objects.requireNonNull(value, "query");
    if (Objects.equals(this.query, newValue)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        newValue,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpArguments#query() query} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for query
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withQuery(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.query, value)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        value,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpArguments#queryFile() queryFile} attribute.
   * @param value The value for queryFile
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withQueryFile(String value) {
    String newValue = Objects.requireNonNull(value, "queryFile");
    if (Objects.equals(this.queryFile, newValue)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        newValue,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpArguments#queryFile() queryFile} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for queryFile
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withQueryFile(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.queryFile, value)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        value,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpArguments#readPreference() readPreference} attribute.
   * @param value The value for readPreference
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withReadPreference(String value) {
    String newValue = Objects.requireNonNull(value, "readPreference");
    if (Objects.equals(this.readPreference, newValue)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        newValue,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpArguments#readPreference() readPreference} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for readPreference
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withReadPreference(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.readPreference, value)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        value,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpArguments#forceTableScan() forceTableScan} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for forceTableScan
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpArguments withForceTableScan(boolean value) {
    if (this.forceTableScan == value) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        value,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpArguments#archive() archive} attribute.
   * @param value The value for archive
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withArchive(String value) {
    String newValue = Objects.requireNonNull(value, "archive");
    if (Objects.equals(this.archive, newValue)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        newValue,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpArguments#archive() archive} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for archive
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withArchive(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.archive, value)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        value,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpArguments#dumpDbUsersAndRoles() dumpDbUsersAndRoles} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dumpDbUsersAndRoles
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpArguments withDumpDbUsersAndRoles(boolean value) {
    if (this.dumpDbUsersAndRoles == value) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        value,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpArguments#gzip() gzip} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gzip
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpArguments withGzip(boolean value) {
    if (this.gzip == value) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        value,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpArguments#repair() repair} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repair
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpArguments withRepair(boolean value) {
    if (this.repair == value) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        value,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpArguments#dir() dir} attribute.
   * @param value The value for dir
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withDir(String value) {
    String newValue = Objects.requireNonNull(value, "dir");
    if (Objects.equals(this.dir, newValue)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        newValue,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpArguments#dir() dir} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dir
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withDir(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.dir, value)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        value,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpArguments#isOplog() isOplog} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isOplog
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpArguments withIsOplog(boolean value) {
    if (this.isOplog == value) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        value,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpArguments#excludeCollection() excludeCollection} attribute.
   * @param value The value for excludeCollection
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withExcludeCollection(String value) {
    String newValue = Objects.requireNonNull(value, "excludeCollection");
    if (Objects.equals(this.excludeCollection, newValue)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        newValue,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpArguments#excludeCollection() excludeCollection} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for excludeCollection
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withExcludeCollection(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.excludeCollection, value)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        value,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpArguments#excludeCollectionWithPrefix() excludeCollectionWithPrefix} attribute.
   * @param value The value for excludeCollectionWithPrefix
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withExcludeCollectionWithPrefix(String value) {
    String newValue = Objects.requireNonNull(value, "excludeCollectionWithPrefix");
    if (Objects.equals(this.excludeCollectionWithPrefix, newValue)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        newValue,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpArguments#excludeCollectionWithPrefix() excludeCollectionWithPrefix} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for excludeCollectionWithPrefix
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withExcludeCollectionWithPrefix(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.excludeCollectionWithPrefix, value)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        value,
        this.numberOfParallelCollections);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpArguments#numberOfParallelCollections() numberOfParallelCollections} attribute.
   * @param value The value for numberOfParallelCollections
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withNumberOfParallelCollections(int value) {
    Integer newValue = value;
    if (Objects.equals(this.numberOfParallelCollections, newValue)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpArguments#numberOfParallelCollections() numberOfParallelCollections} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for numberOfParallelCollections
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpArguments withNumberOfParallelCollections(OptionalInt optional) {
    Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.numberOfParallelCollections, value)) return this;
    return new ImmutableMongoDumpArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.forceTableScan,
        this.archive,
        this.dumpDbUsersAndRoles,
        this.gzip,
        this.repair,
        this.dir,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoDumpArguments} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoDumpArguments
        && equalTo((ImmutableMongoDumpArguments) another);
  }

  private boolean equalTo(ImmutableMongoDumpArguments another) {
    return verbose == another.verbose
        && Objects.equals(databaseName, another.databaseName)
        && Objects.equals(collectionName, another.collectionName)
        && Objects.equals(query, another.query)
        && Objects.equals(queryFile, another.queryFile)
        && Objects.equals(readPreference, another.readPreference)
        && forceTableScan == another.forceTableScan
        && Objects.equals(archive, another.archive)
        && dumpDbUsersAndRoles == another.dumpDbUsersAndRoles
        && gzip == another.gzip
        && repair == another.repair
        && Objects.equals(dir, another.dir)
        && isOplog == another.isOplog
        && Objects.equals(excludeCollection, another.excludeCollection)
        && Objects.equals(excludeCollectionWithPrefix, another.excludeCollectionWithPrefix)
        && Objects.equals(numberOfParallelCollections, another.numberOfParallelCollections);
  }

  /**
   * Computes a hash code from attributes: {@code verbose}, {@code databaseName}, {@code collectionName}, {@code query}, {@code queryFile}, {@code readPreference}, {@code forceTableScan}, {@code archive}, {@code dumpDbUsersAndRoles}, {@code gzip}, {@code repair}, {@code dir}, {@code isOplog}, {@code excludeCollection}, {@code excludeCollectionWithPrefix}, {@code numberOfParallelCollections}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Boolean.hashCode(verbose);
    h += (h << 5) + Objects.hashCode(databaseName);
    h += (h << 5) + Objects.hashCode(collectionName);
    h += (h << 5) + Objects.hashCode(query);
    h += (h << 5) + Objects.hashCode(queryFile);
    h += (h << 5) + Objects.hashCode(readPreference);
    h += (h << 5) + Boolean.hashCode(forceTableScan);
    h += (h << 5) + Objects.hashCode(archive);
    h += (h << 5) + Boolean.hashCode(dumpDbUsersAndRoles);
    h += (h << 5) + Boolean.hashCode(gzip);
    h += (h << 5) + Boolean.hashCode(repair);
    h += (h << 5) + Objects.hashCode(dir);
    h += (h << 5) + Boolean.hashCode(isOplog);
    h += (h << 5) + Objects.hashCode(excludeCollection);
    h += (h << 5) + Objects.hashCode(excludeCollectionWithPrefix);
    h += (h << 5) + Objects.hashCode(numberOfParallelCollections);
    return h;
  }

  /**
   * Prints the immutable value {@code MongoDumpArguments} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("MongoDumpArguments{");
    builder.append("verbose=").append(verbose);
    if (databaseName != null) {
      builder.append(", ");
      builder.append("databaseName=").append(databaseName);
    }
    if (collectionName != null) {
      builder.append(", ");
      builder.append("collectionName=").append(collectionName);
    }
    if (query != null) {
      builder.append(", ");
      builder.append("query=").append(query);
    }
    if (queryFile != null) {
      builder.append(", ");
      builder.append("queryFile=").append(queryFile);
    }
    if (readPreference != null) {
      builder.append(", ");
      builder.append("readPreference=").append(readPreference);
    }
    builder.append(", ");
    builder.append("forceTableScan=").append(forceTableScan);
    if (archive != null) {
      builder.append(", ");
      builder.append("archive=").append(archive);
    }
    builder.append(", ");
    builder.append("dumpDbUsersAndRoles=").append(dumpDbUsersAndRoles);
    builder.append(", ");
    builder.append("gzip=").append(gzip);
    builder.append(", ");
    builder.append("repair=").append(repair);
    if (dir != null) {
      builder.append(", ");
      builder.append("dir=").append(dir);
    }
    builder.append(", ");
    builder.append("isOplog=").append(isOplog);
    if (excludeCollection != null) {
      builder.append(", ");
      builder.append("excludeCollection=").append(excludeCollection);
    }
    if (excludeCollectionWithPrefix != null) {
      builder.append(", ");
      builder.append("excludeCollectionWithPrefix=").append(excludeCollectionWithPrefix);
    }
    if (numberOfParallelCollections != null) {
      builder.append(", ");
      builder.append("numberOfParallelCollections=").append(numberOfParallelCollections);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link MongoDumpArguments} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoDumpArguments instance
   */
  public static ImmutableMongoDumpArguments copyOf(MongoDumpArguments instance) {
    if (instance instanceof ImmutableMongoDumpArguments) {
      return (ImmutableMongoDumpArguments) instance;
    }
    return ImmutableMongoDumpArguments.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongoDumpArguments ImmutableMongoDumpArguments}.
   * <pre>
   * ImmutableMongoDumpArguments.builder()
   *    .verbose(boolean) // optional {@link MongoDumpArguments#verbose() verbose}
   *    .databaseName(String) // optional {@link MongoDumpArguments#databaseName() databaseName}
   *    .collectionName(String) // optional {@link MongoDumpArguments#collectionName() collectionName}
   *    .query(String) // optional {@link MongoDumpArguments#query() query}
   *    .queryFile(String) // optional {@link MongoDumpArguments#queryFile() queryFile}
   *    .readPreference(String) // optional {@link MongoDumpArguments#readPreference() readPreference}
   *    .forceTableScan(boolean) // optional {@link MongoDumpArguments#forceTableScan() forceTableScan}
   *    .archive(String) // optional {@link MongoDumpArguments#archive() archive}
   *    .dumpDbUsersAndRoles(boolean) // optional {@link MongoDumpArguments#dumpDbUsersAndRoles() dumpDbUsersAndRoles}
   *    .gzip(boolean) // optional {@link MongoDumpArguments#gzip() gzip}
   *    .repair(boolean) // optional {@link MongoDumpArguments#repair() repair}
   *    .dir(String) // optional {@link MongoDumpArguments#dir() dir}
   *    .isOplog(boolean) // optional {@link MongoDumpArguments#isOplog() isOplog}
   *    .excludeCollection(String) // optional {@link MongoDumpArguments#excludeCollection() excludeCollection}
   *    .excludeCollectionWithPrefix(String) // optional {@link MongoDumpArguments#excludeCollectionWithPrefix() excludeCollectionWithPrefix}
   *    .numberOfParallelCollections(int) // optional {@link MongoDumpArguments#numberOfParallelCollections() numberOfParallelCollections}
   *    .build();
   * </pre>
   * @return A new ImmutableMongoDumpArguments builder
   */
  public static ImmutableMongoDumpArguments.Builder builder() {
    return new ImmutableMongoDumpArguments.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongoDumpArguments ImmutableMongoDumpArguments}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongoDumpArguments", generator = "Immutables")
  public static final class Builder {
    private static final long OPT_BIT_VERBOSE = 0x1L;
    private static final long OPT_BIT_FORCE_TABLE_SCAN = 0x2L;
    private static final long OPT_BIT_DUMP_DB_USERS_AND_ROLES = 0x4L;
    private static final long OPT_BIT_GZIP = 0x8L;
    private static final long OPT_BIT_REPAIR = 0x10L;
    private static final long OPT_BIT_IS_OPLOG = 0x20L;
    private long optBits;

    private boolean verbose;
    private String databaseName;
    private String collectionName;
    private String query;
    private String queryFile;
    private String readPreference;
    private boolean forceTableScan;
    private String archive;
    private boolean dumpDbUsersAndRoles;
    private boolean gzip;
    private boolean repair;
    private String dir;
    private boolean isOplog;
    private String excludeCollection;
    private String excludeCollectionWithPrefix;
    private Integer numberOfParallelCollections;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MongoDumpArguments} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoDumpArguments instance) {
      Objects.requireNonNull(instance, "instance");
      verbose(instance.verbose());
      Optional<String> databaseNameOptional = instance.databaseName();
      if (databaseNameOptional.isPresent()) {
        databaseName(databaseNameOptional);
      }
      Optional<String> collectionNameOptional = instance.collectionName();
      if (collectionNameOptional.isPresent()) {
        collectionName(collectionNameOptional);
      }
      Optional<String> queryOptional = instance.query();
      if (queryOptional.isPresent()) {
        query(queryOptional);
      }
      Optional<String> queryFileOptional = instance.queryFile();
      if (queryFileOptional.isPresent()) {
        queryFile(queryFileOptional);
      }
      Optional<String> readPreferenceOptional = instance.readPreference();
      if (readPreferenceOptional.isPresent()) {
        readPreference(readPreferenceOptional);
      }
      forceTableScan(instance.forceTableScan());
      Optional<String> archiveOptional = instance.archive();
      if (archiveOptional.isPresent()) {
        archive(archiveOptional);
      }
      dumpDbUsersAndRoles(instance.dumpDbUsersAndRoles());
      gzip(instance.gzip());
      repair(instance.repair());
      Optional<String> dirOptional = instance.dir();
      if (dirOptional.isPresent()) {
        dir(dirOptional);
      }
      isOplog(instance.isOplog());
      Optional<String> excludeCollectionOptional = instance.excludeCollection();
      if (excludeCollectionOptional.isPresent()) {
        excludeCollection(excludeCollectionOptional);
      }
      Optional<String> excludeCollectionWithPrefixOptional = instance.excludeCollectionWithPrefix();
      if (excludeCollectionWithPrefixOptional.isPresent()) {
        excludeCollectionWithPrefix(excludeCollectionWithPrefixOptional);
      }
      OptionalInt numberOfParallelCollectionsOptional = instance.numberOfParallelCollections();
      if (numberOfParallelCollectionsOptional.isPresent()) {
        numberOfParallelCollections(numberOfParallelCollectionsOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpArguments#verbose() verbose} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpArguments#verbose() verbose}.</em>
     * @param verbose The value for verbose 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder verbose(boolean verbose) {
      this.verbose = verbose;
      optBits |= OPT_BIT_VERBOSE;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#databaseName() databaseName} to databaseName.
     * @param databaseName The value for databaseName
     * @return {@code this} builder for chained invocation
     */
    public final Builder databaseName(String databaseName) {
      this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#databaseName() databaseName} to databaseName.
     * @param databaseName The value for databaseName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder databaseName(Optional<String> databaseName) {
      this.databaseName = databaseName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#collectionName() collectionName} to collectionName.
     * @param collectionName The value for collectionName
     * @return {@code this} builder for chained invocation
     */
    public final Builder collectionName(String collectionName) {
      this.collectionName = Objects.requireNonNull(collectionName, "collectionName");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#collectionName() collectionName} to collectionName.
     * @param collectionName The value for collectionName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder collectionName(Optional<String> collectionName) {
      this.collectionName = collectionName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#query() query} to query.
     * @param query The value for query
     * @return {@code this} builder for chained invocation
     */
    public final Builder query(String query) {
      this.query = Objects.requireNonNull(query, "query");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#query() query} to query.
     * @param query The value for query
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder query(Optional<String> query) {
      this.query = query.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#queryFile() queryFile} to queryFile.
     * @param queryFile The value for queryFile
     * @return {@code this} builder for chained invocation
     */
    public final Builder queryFile(String queryFile) {
      this.queryFile = Objects.requireNonNull(queryFile, "queryFile");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#queryFile() queryFile} to queryFile.
     * @param queryFile The value for queryFile
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder queryFile(Optional<String> queryFile) {
      this.queryFile = queryFile.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#readPreference() readPreference} to readPreference.
     * @param readPreference The value for readPreference
     * @return {@code this} builder for chained invocation
     */
    public final Builder readPreference(String readPreference) {
      this.readPreference = Objects.requireNonNull(readPreference, "readPreference");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#readPreference() readPreference} to readPreference.
     * @param readPreference The value for readPreference
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder readPreference(Optional<String> readPreference) {
      this.readPreference = readPreference.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpArguments#forceTableScan() forceTableScan} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpArguments#forceTableScan() forceTableScan}.</em>
     * @param forceTableScan The value for forceTableScan 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder forceTableScan(boolean forceTableScan) {
      this.forceTableScan = forceTableScan;
      optBits |= OPT_BIT_FORCE_TABLE_SCAN;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#archive() archive} to archive.
     * @param archive The value for archive
     * @return {@code this} builder for chained invocation
     */
    public final Builder archive(String archive) {
      this.archive = Objects.requireNonNull(archive, "archive");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#archive() archive} to archive.
     * @param archive The value for archive
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder archive(Optional<String> archive) {
      this.archive = archive.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpArguments#dumpDbUsersAndRoles() dumpDbUsersAndRoles} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpArguments#dumpDbUsersAndRoles() dumpDbUsersAndRoles}.</em>
     * @param dumpDbUsersAndRoles The value for dumpDbUsersAndRoles 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dumpDbUsersAndRoles(boolean dumpDbUsersAndRoles) {
      this.dumpDbUsersAndRoles = dumpDbUsersAndRoles;
      optBits |= OPT_BIT_DUMP_DB_USERS_AND_ROLES;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpArguments#gzip() gzip} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpArguments#gzip() gzip}.</em>
     * @param gzip The value for gzip 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder gzip(boolean gzip) {
      this.gzip = gzip;
      optBits |= OPT_BIT_GZIP;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpArguments#repair() repair} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpArguments#repair() repair}.</em>
     * @param repair The value for repair 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder repair(boolean repair) {
      this.repair = repair;
      optBits |= OPT_BIT_REPAIR;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#dir() dir} to dir.
     * @param dir The value for dir
     * @return {@code this} builder for chained invocation
     */
    public final Builder dir(String dir) {
      this.dir = Objects.requireNonNull(dir, "dir");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#dir() dir} to dir.
     * @param dir The value for dir
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dir(Optional<String> dir) {
      this.dir = dir.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpArguments#isOplog() isOplog} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpArguments#isOplog() isOplog}.</em>
     * @param isOplog The value for isOplog 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isOplog(boolean isOplog) {
      this.isOplog = isOplog;
      optBits |= OPT_BIT_IS_OPLOG;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#excludeCollection() excludeCollection} to excludeCollection.
     * @param excludeCollection The value for excludeCollection
     * @return {@code this} builder for chained invocation
     */
    public final Builder excludeCollection(String excludeCollection) {
      this.excludeCollection = Objects.requireNonNull(excludeCollection, "excludeCollection");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#excludeCollection() excludeCollection} to excludeCollection.
     * @param excludeCollection The value for excludeCollection
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder excludeCollection(Optional<String> excludeCollection) {
      this.excludeCollection = excludeCollection.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#excludeCollectionWithPrefix() excludeCollectionWithPrefix} to excludeCollectionWithPrefix.
     * @param excludeCollectionWithPrefix The value for excludeCollectionWithPrefix
     * @return {@code this} builder for chained invocation
     */
    public final Builder excludeCollectionWithPrefix(String excludeCollectionWithPrefix) {
      this.excludeCollectionWithPrefix = Objects.requireNonNull(excludeCollectionWithPrefix, "excludeCollectionWithPrefix");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#excludeCollectionWithPrefix() excludeCollectionWithPrefix} to excludeCollectionWithPrefix.
     * @param excludeCollectionWithPrefix The value for excludeCollectionWithPrefix
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder excludeCollectionWithPrefix(Optional<String> excludeCollectionWithPrefix) {
      this.excludeCollectionWithPrefix = excludeCollectionWithPrefix.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#numberOfParallelCollections() numberOfParallelCollections} to numberOfParallelCollections.
     * @param numberOfParallelCollections The value for numberOfParallelCollections
     * @return {@code this} builder for chained invocation
     */
    public final Builder numberOfParallelCollections(int numberOfParallelCollections) {
      this.numberOfParallelCollections = numberOfParallelCollections;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpArguments#numberOfParallelCollections() numberOfParallelCollections} to numberOfParallelCollections.
     * @param numberOfParallelCollections The value for numberOfParallelCollections
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder numberOfParallelCollections(OptionalInt numberOfParallelCollections) {
      this.numberOfParallelCollections = numberOfParallelCollections.isPresent() ? numberOfParallelCollections.getAsInt() : null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongoDumpArguments ImmutableMongoDumpArguments}.
     * @return An immutable instance of MongoDumpArguments
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoDumpArguments build() {
      return new ImmutableMongoDumpArguments(this);
    }

    private boolean verboseIsSet() {
      return (optBits & OPT_BIT_VERBOSE) != 0;
    }

    private boolean forceTableScanIsSet() {
      return (optBits & OPT_BIT_FORCE_TABLE_SCAN) != 0;
    }

    private boolean dumpDbUsersAndRolesIsSet() {
      return (optBits & OPT_BIT_DUMP_DB_USERS_AND_ROLES) != 0;
    }

    private boolean gzipIsSet() {
      return (optBits & OPT_BIT_GZIP) != 0;
    }

    private boolean repairIsSet() {
      return (optBits & OPT_BIT_REPAIR) != 0;
    }

    private boolean isOplogIsSet() {
      return (optBits & OPT_BIT_IS_OPLOG) != 0;
    }
  }
}
