package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.embed.mongo.commands.MongosArguments;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.embed.process.types.ProcessArguments;
import de.flapdoodle.os.Platform;
import de.flapdoodle.reverse.StateID;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongosProcessArguments}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongosProcessArguments.builder()}.
 */
@Generated(from = "MongosProcessArguments", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableMongosProcessArguments
    extends MongosProcessArguments {
  private final StateID<ProcessArguments> destination;
  private final StateID<MongosArguments> arguments;
  private final StateID<Platform> platform;
  private final StateID<Version> version;
  private final StateID<Net> net;

  private ImmutableMongosProcessArguments(ImmutableMongosProcessArguments.Builder builder) {
    if (builder.destination != null) {
      initShim.destination(builder.destination);
    }
    if (builder.arguments != null) {
      initShim.arguments(builder.arguments);
    }
    if (builder.platform != null) {
      initShim.platform(builder.platform);
    }
    if (builder.version != null) {
      initShim.version(builder.version);
    }
    if (builder.net != null) {
      initShim.net(builder.net);
    }
    this.destination = initShim.destination();
    this.arguments = initShim.arguments();
    this.platform = initShim.platform();
    this.version = initShim.version();
    this.net = initShim.net();
    this.initShim = null;
  }

  private ImmutableMongosProcessArguments(
      StateID<ProcessArguments> destination,
      StateID<MongosArguments> arguments,
      StateID<Platform> platform,
      StateID<Version> version,
      StateID<Net> net) {
    this.destination = destination;
    this.arguments = arguments;
    this.platform = platform;
    this.version = version;
    this.net = net;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MongosProcessArguments", generator = "Immutables")
  private final class InitShim {
    private byte destinationBuildStage = STAGE_UNINITIALIZED;
    private StateID<ProcessArguments> destination;

    StateID<ProcessArguments> destination() {
      if (destinationBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (destinationBuildStage == STAGE_UNINITIALIZED) {
        destinationBuildStage = STAGE_INITIALIZING;
        this.destination = Objects.requireNonNull(ImmutableMongosProcessArguments.super.destination(), "destination");
        destinationBuildStage = STAGE_INITIALIZED;
      }
      return this.destination;
    }

    void destination(StateID<ProcessArguments> destination) {
      this.destination = destination;
      destinationBuildStage = STAGE_INITIALIZED;
    }

    private byte argumentsBuildStage = STAGE_UNINITIALIZED;
    private StateID<MongosArguments> arguments;

    StateID<MongosArguments> arguments() {
      if (argumentsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (argumentsBuildStage == STAGE_UNINITIALIZED) {
        argumentsBuildStage = STAGE_INITIALIZING;
        this.arguments = Objects.requireNonNull(ImmutableMongosProcessArguments.super.arguments(), "arguments");
        argumentsBuildStage = STAGE_INITIALIZED;
      }
      return this.arguments;
    }

    void arguments(StateID<MongosArguments> arguments) {
      this.arguments = arguments;
      argumentsBuildStage = STAGE_INITIALIZED;
    }

    private byte platformBuildStage = STAGE_UNINITIALIZED;
    private StateID<Platform> platform;

    StateID<Platform> platform() {
      if (platformBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (platformBuildStage == STAGE_UNINITIALIZED) {
        platformBuildStage = STAGE_INITIALIZING;
        this.platform = Objects.requireNonNull(ImmutableMongosProcessArguments.super.platform(), "platform");
        platformBuildStage = STAGE_INITIALIZED;
      }
      return this.platform;
    }

    void platform(StateID<Platform> platform) {
      this.platform = platform;
      platformBuildStage = STAGE_INITIALIZED;
    }

    private byte versionBuildStage = STAGE_UNINITIALIZED;
    private StateID<Version> version;

    StateID<Version> version() {
      if (versionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (versionBuildStage == STAGE_UNINITIALIZED) {
        versionBuildStage = STAGE_INITIALIZING;
        this.version = Objects.requireNonNull(ImmutableMongosProcessArguments.super.version(), "version");
        versionBuildStage = STAGE_INITIALIZED;
      }
      return this.version;
    }

    void version(StateID<Version> version) {
      this.version = version;
      versionBuildStage = STAGE_INITIALIZED;
    }

    private byte netBuildStage = STAGE_UNINITIALIZED;
    private StateID<Net> net;

    StateID<Net> net() {
      if (netBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (netBuildStage == STAGE_UNINITIALIZED) {
        netBuildStage = STAGE_INITIALIZING;
        this.net = Objects.requireNonNull(ImmutableMongosProcessArguments.super.net(), "net");
        netBuildStage = STAGE_INITIALIZED;
      }
      return this.net;
    }

    void net(StateID<Net> net) {
      this.net = net;
      netBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (destinationBuildStage == STAGE_INITIALIZING) attributes.add("destination");
      if (argumentsBuildStage == STAGE_INITIALIZING) attributes.add("arguments");
      if (platformBuildStage == STAGE_INITIALIZING) attributes.add("platform");
      if (versionBuildStage == STAGE_INITIALIZING) attributes.add("version");
      if (netBuildStage == STAGE_INITIALIZING) attributes.add("net");
      return "Cannot build MongosProcessArguments, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public StateID<ProcessArguments> destination() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.destination()
        : this.destination;
  }

  /**
   * @return The value of the {@code arguments} attribute
   */
  @Override
  public StateID<MongosArguments> arguments() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.arguments()
        : this.arguments;
  }

  /**
   * @return The value of the {@code platform} attribute
   */
  @Override
  public StateID<Platform> platform() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.platform()
        : this.platform;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @Override
  public StateID<Version> version() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.version()
        : this.version;
  }

  /**
   * @return The value of the {@code net} attribute
   */
  @Override
  public StateID<Net> net() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.net()
        : this.net;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosProcessArguments#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosProcessArguments withDestination(StateID<ProcessArguments> value) {
    if (this.destination == value) return this;
    StateID<ProcessArguments> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableMongosProcessArguments(newValue, this.arguments, this.platform, this.version, this.net);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosProcessArguments#arguments() arguments} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for arguments
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosProcessArguments withArguments(StateID<MongosArguments> value) {
    if (this.arguments == value) return this;
    StateID<MongosArguments> newValue = Objects.requireNonNull(value, "arguments");
    return new ImmutableMongosProcessArguments(this.destination, newValue, this.platform, this.version, this.net);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosProcessArguments#platform() platform} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for platform
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosProcessArguments withPlatform(StateID<Platform> value) {
    if (this.platform == value) return this;
    StateID<Platform> newValue = Objects.requireNonNull(value, "platform");
    return new ImmutableMongosProcessArguments(this.destination, this.arguments, newValue, this.version, this.net);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosProcessArguments#version() version} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosProcessArguments withVersion(StateID<Version> value) {
    if (this.version == value) return this;
    StateID<Version> newValue = Objects.requireNonNull(value, "version");
    return new ImmutableMongosProcessArguments(this.destination, this.arguments, this.platform, newValue, this.net);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongosProcessArguments#net() net} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for net
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongosProcessArguments withNet(StateID<Net> value) {
    if (this.net == value) return this;
    StateID<Net> newValue = Objects.requireNonNull(value, "net");
    return new ImmutableMongosProcessArguments(this.destination, this.arguments, this.platform, this.version, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongosProcessArguments} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongosProcessArguments
        && equalTo((ImmutableMongosProcessArguments) another);
  }

  private boolean equalTo(ImmutableMongosProcessArguments another) {
    return destination.equals(another.destination)
        && arguments.equals(another.arguments)
        && platform.equals(another.platform)
        && version.equals(another.version)
        && net.equals(another.net);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code arguments}, {@code platform}, {@code version}, {@code net}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + arguments.hashCode();
    h += (h << 5) + platform.hashCode();
    h += (h << 5) + version.hashCode();
    h += (h << 5) + net.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongosProcessArguments} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MongosProcessArguments{"
        + "destination=" + destination
        + ", arguments=" + arguments
        + ", platform=" + platform
        + ", version=" + version
        + ", net=" + net
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MongosProcessArguments} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongosProcessArguments instance
   */
  public static ImmutableMongosProcessArguments copyOf(MongosProcessArguments instance) {
    if (instance instanceof ImmutableMongosProcessArguments) {
      return (ImmutableMongosProcessArguments) instance;
    }
    return ImmutableMongosProcessArguments.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongosProcessArguments ImmutableMongosProcessArguments}.
   * <pre>
   * ImmutableMongosProcessArguments.builder()
   *    .destination(de.flapdoodle.reverse.StateID&amp;lt;de.flapdoodle.embed.process.types.ProcessArguments&amp;gt;) // optional {@link MongosProcessArguments#destination() destination}
   *    .arguments(de.flapdoodle.reverse.StateID&amp;lt;de.flapdoodle.embed.mongo.commands.MongosArguments&amp;gt;) // optional {@link MongosProcessArguments#arguments() arguments}
   *    .platform(de.flapdoodle.reverse.StateID&amp;lt;de.flapdoodle.os.Platform&amp;gt;) // optional {@link MongosProcessArguments#platform() platform}
   *    .version(de.flapdoodle.reverse.StateID&amp;lt;de.flapdoodle.embed.process.distribution.Version&amp;gt;) // optional {@link MongosProcessArguments#version() version}
   *    .net(de.flapdoodle.reverse.StateID&amp;lt;de.flapdoodle.embed.mongo.config.Net&amp;gt;) // optional {@link MongosProcessArguments#net() net}
   *    .build();
   * </pre>
   * @return A new ImmutableMongosProcessArguments builder
   */
  public static ImmutableMongosProcessArguments.Builder builder() {
    return new ImmutableMongosProcessArguments.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongosProcessArguments ImmutableMongosProcessArguments}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongosProcessArguments", generator = "Immutables")
  public static final class Builder {
    private StateID<ProcessArguments> destination;
    private StateID<MongosArguments> arguments;
    private StateID<Platform> platform;
    private StateID<Version> version;
    private StateID<Net> net;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MongosProcessArguments} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongosProcessArguments instance) {
      Objects.requireNonNull(instance, "instance");
      destination(instance.destination());
      arguments(instance.arguments());
      platform(instance.platform());
      version(instance.version());
      net(instance.net());
      return this;
    }

    /**
     * Initializes the value for the {@link MongosProcessArguments#destination() destination} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongosProcessArguments#destination() destination}.</em>
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destination(StateID<ProcessArguments> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      return this;
    }

    /**
     * Initializes the value for the {@link MongosProcessArguments#arguments() arguments} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongosProcessArguments#arguments() arguments}.</em>
     * @param arguments The value for arguments 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder arguments(StateID<MongosArguments> arguments) {
      this.arguments = Objects.requireNonNull(arguments, "arguments");
      return this;
    }

    /**
     * Initializes the value for the {@link MongosProcessArguments#platform() platform} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongosProcessArguments#platform() platform}.</em>
     * @param platform The value for platform 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder platform(StateID<Platform> platform) {
      this.platform = Objects.requireNonNull(platform, "platform");
      return this;
    }

    /**
     * Initializes the value for the {@link MongosProcessArguments#version() version} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongosProcessArguments#version() version}.</em>
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(StateID<Version> version) {
      this.version = Objects.requireNonNull(version, "version");
      return this;
    }

    /**
     * Initializes the value for the {@link MongosProcessArguments#net() net} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongosProcessArguments#net() net}.</em>
     * @param net The value for net 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder net(StateID<Net> net) {
      this.net = Objects.requireNonNull(net, "net");
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongosProcessArguments ImmutableMongosProcessArguments}.
     * @return An immutable instance of MongosProcessArguments
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongosProcessArguments build() {
      return new ImmutableMongosProcessArguments(this);
    }
  }
}
