/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.embed.mongo.commands.MongosArguments;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.transitions.MongosProcessArguments;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.embed.process.types.ProcessArguments;
import de.flapdoodle.os.Platform;
import de.flapdoodle.reverse.StateID;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="MongosProcessArguments", generator="Immutables")
public final class ImmutableMongosProcessArguments
extends MongosProcessArguments {
    private final StateID<ProcessArguments> destination;
    private final StateID<MongosArguments> arguments;
    private final StateID<Platform> platform;
    private final StateID<Version> version;
    private final StateID<Net> net;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMongosProcessArguments(Builder builder) {
        if (builder.destination != null) {
            this.initShim.destination((StateID<ProcessArguments>)builder.destination);
        }
        if (builder.arguments != null) {
            this.initShim.arguments((StateID<MongosArguments>)builder.arguments);
        }
        if (builder.platform != null) {
            this.initShim.platform((StateID<Platform>)builder.platform);
        }
        if (builder.version != null) {
            this.initShim.version((StateID<Version>)builder.version);
        }
        if (builder.net != null) {
            this.initShim.net((StateID<Net>)builder.net);
        }
        this.destination = this.initShim.destination();
        this.arguments = this.initShim.arguments();
        this.platform = this.initShim.platform();
        this.version = this.initShim.version();
        this.net = this.initShim.net();
        this.initShim = null;
    }

    private ImmutableMongosProcessArguments(StateID<ProcessArguments> destination, StateID<MongosArguments> arguments, StateID<Platform> platform, StateID<Version> version, StateID<Net> net) {
        this.destination = destination;
        this.arguments = arguments;
        this.platform = platform;
        this.version = version;
        this.net = net;
        this.initShim = null;
    }

    @Override
    public StateID<ProcessArguments> destination() {
        InitShim shim = this.initShim;
        return shim != null ? shim.destination() : this.destination;
    }

    @Override
    public StateID<MongosArguments> arguments() {
        InitShim shim = this.initShim;
        return shim != null ? shim.arguments() : this.arguments;
    }

    @Override
    public StateID<Platform> platform() {
        InitShim shim = this.initShim;
        return shim != null ? shim.platform() : this.platform;
    }

    @Override
    public StateID<Version> version() {
        InitShim shim = this.initShim;
        return shim != null ? shim.version() : this.version;
    }

    @Override
    public StateID<Net> net() {
        InitShim shim = this.initShim;
        return shim != null ? shim.net() : this.net;
    }

    public final ImmutableMongosProcessArguments withDestination(StateID<ProcessArguments> value) {
        if (this.destination == value) {
            return this;
        }
        StateID<ProcessArguments> newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableMongosProcessArguments(newValue, this.arguments, this.platform, this.version, this.net);
    }

    public final ImmutableMongosProcessArguments withArguments(StateID<MongosArguments> value) {
        if (this.arguments == value) {
            return this;
        }
        StateID<MongosArguments> newValue = Objects.requireNonNull(value, "arguments");
        return new ImmutableMongosProcessArguments(this.destination, newValue, this.platform, this.version, this.net);
    }

    public final ImmutableMongosProcessArguments withPlatform(StateID<Platform> value) {
        if (this.platform == value) {
            return this;
        }
        StateID<Platform> newValue = Objects.requireNonNull(value, "platform");
        return new ImmutableMongosProcessArguments(this.destination, this.arguments, newValue, this.version, this.net);
    }

    public final ImmutableMongosProcessArguments withVersion(StateID<Version> value) {
        if (this.version == value) {
            return this;
        }
        StateID<Version> newValue = Objects.requireNonNull(value, "version");
        return new ImmutableMongosProcessArguments(this.destination, this.arguments, this.platform, newValue, this.net);
    }

    public final ImmutableMongosProcessArguments withNet(StateID<Net> value) {
        if (this.net == value) {
            return this;
        }
        StateID<Net> newValue = Objects.requireNonNull(value, "net");
        return new ImmutableMongosProcessArguments(this.destination, this.arguments, this.platform, this.version, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongosProcessArguments && this.equalTo((ImmutableMongosProcessArguments)another);
    }

    private boolean equalTo(ImmutableMongosProcessArguments another) {
        return this.destination.equals(another.destination) && this.arguments.equals(another.arguments) && this.platform.equals(another.platform) && this.version.equals(another.version) && this.net.equals(another.net);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.arguments.hashCode();
        h += (h << 5) + this.platform.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.net.hashCode();
        return h;
    }

    public String toString() {
        return "MongosProcessArguments{destination=" + this.destination + ", arguments=" + this.arguments + ", platform=" + this.platform + ", version=" + this.version + ", net=" + this.net + "}";
    }

    public static ImmutableMongosProcessArguments copyOf(MongosProcessArguments instance) {
        if (instance instanceof ImmutableMongosProcessArguments) {
            return (ImmutableMongosProcessArguments)instance;
        }
        return ImmutableMongosProcessArguments.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MongosProcessArguments", generator="Immutables")
    public static final class Builder {
        private StateID<ProcessArguments> destination;
        private StateID<MongosArguments> arguments;
        private StateID<Platform> platform;
        private StateID<Version> version;
        private StateID<Net> net;

        private Builder() {
        }

        public final Builder from(MongosProcessArguments instance) {
            Objects.requireNonNull(instance, "instance");
            this.destination(instance.destination());
            this.arguments(instance.arguments());
            this.platform(instance.platform());
            this.version(instance.version());
            this.net(instance.net());
            return this;
        }

        public final Builder destination(StateID<ProcessArguments> destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            return this;
        }

        public final Builder arguments(StateID<MongosArguments> arguments) {
            this.arguments = Objects.requireNonNull(arguments, "arguments");
            return this;
        }

        public final Builder platform(StateID<Platform> platform) {
            this.platform = Objects.requireNonNull(platform, "platform");
            return this;
        }

        public final Builder version(StateID<Version> version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        public final Builder net(StateID<Net> net) {
            this.net = Objects.requireNonNull(net, "net");
            return this;
        }

        public ImmutableMongosProcessArguments build() {
            return new ImmutableMongosProcessArguments(this);
        }
    }

    @Generated(from="MongosProcessArguments", generator="Immutables")
    private final class InitShim {
        private byte destinationBuildStage = 0;
        private StateID<ProcessArguments> destination;
        private byte argumentsBuildStage = 0;
        private StateID<MongosArguments> arguments;
        private byte platformBuildStage = 0;
        private StateID<Platform> platform;
        private byte versionBuildStage = 0;
        private StateID<Version> version;
        private byte netBuildStage = 0;
        private StateID<Net> net;

        private InitShim() {
        }

        StateID<ProcessArguments> destination() {
            if (this.destinationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.destinationBuildStage == 0) {
                this.destinationBuildStage = (byte)-1;
                this.destination = Objects.requireNonNull(ImmutableMongosProcessArguments.super.destination(), "destination");
                this.destinationBuildStage = 1;
            }
            return this.destination;
        }

        void destination(StateID<ProcessArguments> destination) {
            this.destination = destination;
            this.destinationBuildStage = 1;
        }

        StateID<MongosArguments> arguments() {
            if (this.argumentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.argumentsBuildStage == 0) {
                this.argumentsBuildStage = (byte)-1;
                this.arguments = Objects.requireNonNull(ImmutableMongosProcessArguments.super.arguments(), "arguments");
                this.argumentsBuildStage = 1;
            }
            return this.arguments;
        }

        void arguments(StateID<MongosArguments> arguments) {
            this.arguments = arguments;
            this.argumentsBuildStage = 1;
        }

        StateID<Platform> platform() {
            if (this.platformBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.platformBuildStage == 0) {
                this.platformBuildStage = (byte)-1;
                this.platform = Objects.requireNonNull(ImmutableMongosProcessArguments.super.platform(), "platform");
                this.platformBuildStage = 1;
            }
            return this.platform;
        }

        void platform(StateID<Platform> platform) {
            this.platform = platform;
            this.platformBuildStage = 1;
        }

        StateID<Version> version() {
            if (this.versionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionBuildStage == 0) {
                this.versionBuildStage = (byte)-1;
                this.version = Objects.requireNonNull(ImmutableMongosProcessArguments.super.version(), "version");
                this.versionBuildStage = 1;
            }
            return this.version;
        }

        void version(StateID<Version> version) {
            this.version = version;
            this.versionBuildStage = 1;
        }

        StateID<Net> net() {
            if (this.netBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.netBuildStage == 0) {
                this.netBuildStage = (byte)-1;
                this.net = Objects.requireNonNull(ImmutableMongosProcessArguments.super.net(), "net");
                this.netBuildStage = 1;
            }
            return this.net;
        }

        void net(StateID<Net> net) {
            this.net = net;
            this.netBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.destinationBuildStage == -1) {
                attributes.add("destination");
            }
            if (this.argumentsBuildStage == -1) {
                attributes.add("arguments");
            }
            if (this.platformBuildStage == -1) {
                attributes.add("platform");
            }
            if (this.versionBuildStage == -1) {
                attributes.add("version");
            }
            if (this.netBuildStage == -1) {
                attributes.add("net");
            }
            return "Cannot build MongosProcessArguments, attribute initializers form cycle " + attributes;
        }
    }
}

