/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import com.mongodb.ServerAddress;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.runtime.Mongod;
import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.io.LogWatchStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.ReaderProcessor;
import de.flapdoodle.embed.process.io.StreamProcessor;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.process.runtime.Processes;
import de.flapdoodle.embed.process.types.RunningProcessFactory;
import de.flapdoodle.embed.process.types.RunningProcessImpl;
import de.flapdoodle.os.Platform;
import de.flapdoodle.types.Try;
import java.io.Reader;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningMongodProcess
extends RunningProcessImpl {
    private static Logger LOGGER = LoggerFactory.getLogger(RunningMongodProcess.class);
    private final SupportConfig supportConfig;
    private final Platform platform;
    private final Net net;
    private final StreamProcessor commandOutput;
    private final int mongodProcessId;

    public RunningMongodProcess(ProcessControl process, Path pidFile, long timeout, Runnable onStop, SupportConfig supportConfig, Platform platform, Net net, StreamProcessor commandOutput, int mongodProcessId) {
        super(process, pidFile, timeout, onStop);
        this.supportConfig = supportConfig;
        this.platform = platform;
        this.commandOutput = commandOutput;
        this.net = net;
        this.mongodProcessId = mongodProcessId;
    }

    public ServerAddress getServerAddress() throws UnknownHostException {
        return new ServerAddress(this.net.getServerAddress(), this.net.getPort());
    }

    public int stop() {
        try {
            this.stopInternal();
        }
        finally {
            return super.stop();
        }
    }

    private void stopInternal() {
        LOGGER.debug("try to stop mongod");
        if (!this.sendStopToMongoInstance()) {
            LOGGER.warn("could not stop mongod with db command, try next");
            if (!this.sendKillToProcess()) {
                LOGGER.warn("could not stop mongod, try next");
                if (!this.sendTermToProcess()) {
                    LOGGER.warn("could not stop mongod, try next");
                    if (!this.tryKillToProcess()) {
                        LOGGER.warn("could not stop mongod the second time, try one last thing");
                    }
                }
            }
        }
    }

    private long getProcessId() {
        return this.mongodProcessId;
    }

    protected boolean sendKillToProcess() {
        return this.getProcessId() > 0L && Processes.killProcess((SupportConfig)this.supportConfig, (Platform)this.platform, (StreamProcessor)StreamToLineProcessor.wrap((StreamProcessor)this.commandOutput), (long)this.getProcessId());
    }

    protected boolean sendTermToProcess() {
        return this.getProcessId() > 0L && Processes.termProcess((SupportConfig)this.supportConfig, (Platform)this.platform, (StreamProcessor)StreamToLineProcessor.wrap((StreamProcessor)this.commandOutput), (long)this.getProcessId());
    }

    protected boolean tryKillToProcess() {
        return this.getProcessId() > 0L && Processes.tryKillProcess((SupportConfig)this.supportConfig, (Platform)this.platform, (StreamProcessor)StreamToLineProcessor.wrap((StreamProcessor)this.commandOutput), (long)this.getProcessId());
    }

    protected final boolean sendStopToMongoInstance() {
        try {
            return Mongod.sendShutdown(this.net.getServerAddress(), this.net.getPort());
        }
        catch (UnknownHostException e) {
            LOGGER.error("sendStop", (Throwable)e);
            return false;
        }
    }

    public static RunningProcessFactory<RunningMongodProcess> factory(long startupTimeout, SupportConfig supportConfig, Platform platform, Net net) {
        return (process, processOutput, pidFile, timeout) -> {
            LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor(RunningMongodProcess.successMessage(), RunningMongodProcess.knownFailureMessages(), StreamToLineProcessor.wrap((StreamProcessor)processOutput.output()));
            ReaderProcessor output = Processors.connect((Reader)process.getReader(), (StreamProcessor)logWatch);
            ReaderProcessor error = Processors.connect((Reader)process.getError(), (StreamProcessor)StreamToLineProcessor.wrap((StreamProcessor)processOutput.error()));
            Runnable closeAllOutputs = () -> ReaderProcessor.abortAll((ReaderProcessor[])new ReaderProcessor[]{output, error});
            logWatch.waitForResult(startupTimeout);
            if (logWatch.isInitWithSuccess()) {
                int pid = Mongod.getMongodProcessId(logWatch.getOutput(), -1);
                return new RunningMongodProcess(process, pidFile, timeout, closeAllOutputs, supportConfig, platform, net, processOutput.commands(), pid);
            }
            String failureFound = logWatch.getFailureFound() != null ? logWatch.getFailureFound() : "\n----------------------\nHmm.. no failure message.. \n...the cause must be somewhere in the process output\n----------------------\n" + logWatch.getOutput();
            return (RunningMongodProcess)((Object)((Object)Try.supplier(() -> {
                throw new RuntimeException("Could not start process: " + failureFound);
            }).andFinally(() -> process.stop(timeout)).andFinally(closeAllOutputs).get()));
        };
    }

    private static String successMessage() {
        return "aiting for connections";
    }

    private static Set<String> knownFailureMessages() {
        HashSet<String> ret = new HashSet<String>();
        ret.add("failed errno");
        ret.add("ERROR:");
        ret.add("error command line");
        return ret;
    }
}

