package de.flapdoodle.embed.mongo.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongoRestoreArguments}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongoRestoreArguments.builder()}.
 */
@Generated(from = "MongoRestoreArguments", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableMongoRestoreArguments
    extends MongoRestoreArguments {
  private final boolean verbose;
  private final String databaseName;
  private final String collectionName;
  private final Long oplogLimit;
  private final String archive;
  private final String dir;
  private final Integer numberOfParallelCollections;
  private final Integer numberOfInsertionWorkersPerCollection;
  private final String writeConcern;
  private final boolean objectCheck;
  private final boolean oplogReplay;
  private final boolean restoreDbUsersAndRoles;
  private final boolean gzip;
  private final boolean dropCollection;
  private final boolean noIndexRestore;
  private final boolean noOptionsRestore;
  private final boolean keepIndexVersion;
  private final boolean maintainInsertionOrder;
  private final boolean stopOnError;
  private final boolean bypassDocumentValidation;

  private ImmutableMongoRestoreArguments(ImmutableMongoRestoreArguments.Builder builder) {
    this.databaseName = builder.databaseName;
    this.collectionName = builder.collectionName;
    this.oplogLimit = builder.oplogLimit;
    this.archive = builder.archive;
    this.dir = builder.dir;
    this.numberOfParallelCollections = builder.numberOfParallelCollections;
    this.numberOfInsertionWorkersPerCollection = builder.numberOfInsertionWorkersPerCollection;
    this.writeConcern = builder.writeConcern;
    if (builder.verboseIsSet()) {
      initShim.verbose(builder.verbose);
    }
    if (builder.objectCheckIsSet()) {
      initShim.objectCheck(builder.objectCheck);
    }
    if (builder.oplogReplayIsSet()) {
      initShim.oplogReplay(builder.oplogReplay);
    }
    if (builder.restoreDbUsersAndRolesIsSet()) {
      initShim.restoreDbUsersAndRoles(builder.restoreDbUsersAndRoles);
    }
    if (builder.gzipIsSet()) {
      initShim.gzip(builder.gzip);
    }
    if (builder.dropCollectionIsSet()) {
      initShim.dropCollection(builder.dropCollection);
    }
    if (builder.noIndexRestoreIsSet()) {
      initShim.noIndexRestore(builder.noIndexRestore);
    }
    if (builder.noOptionsRestoreIsSet()) {
      initShim.noOptionsRestore(builder.noOptionsRestore);
    }
    if (builder.keepIndexVersionIsSet()) {
      initShim.keepIndexVersion(builder.keepIndexVersion);
    }
    if (builder.maintainInsertionOrderIsSet()) {
      initShim.maintainInsertionOrder(builder.maintainInsertionOrder);
    }
    if (builder.stopOnErrorIsSet()) {
      initShim.stopOnError(builder.stopOnError);
    }
    if (builder.bypassDocumentValidationIsSet()) {
      initShim.bypassDocumentValidation(builder.bypassDocumentValidation);
    }
    this.verbose = initShim.verbose();
    this.objectCheck = initShim.objectCheck();
    this.oplogReplay = initShim.oplogReplay();
    this.restoreDbUsersAndRoles = initShim.restoreDbUsersAndRoles();
    this.gzip = initShim.gzip();
    this.dropCollection = initShim.dropCollection();
    this.noIndexRestore = initShim.noIndexRestore();
    this.noOptionsRestore = initShim.noOptionsRestore();
    this.keepIndexVersion = initShim.keepIndexVersion();
    this.maintainInsertionOrder = initShim.maintainInsertionOrder();
    this.stopOnError = initShim.stopOnError();
    this.bypassDocumentValidation = initShim.bypassDocumentValidation();
    this.initShim = null;
  }

  private ImmutableMongoRestoreArguments(
      boolean verbose,
      String databaseName,
      String collectionName,
      Long oplogLimit,
      String archive,
      String dir,
      Integer numberOfParallelCollections,
      Integer numberOfInsertionWorkersPerCollection,
      String writeConcern,
      boolean objectCheck,
      boolean oplogReplay,
      boolean restoreDbUsersAndRoles,
      boolean gzip,
      boolean dropCollection,
      boolean noIndexRestore,
      boolean noOptionsRestore,
      boolean keepIndexVersion,
      boolean maintainInsertionOrder,
      boolean stopOnError,
      boolean bypassDocumentValidation) {
    this.verbose = verbose;
    this.databaseName = databaseName;
    this.collectionName = collectionName;
    this.oplogLimit = oplogLimit;
    this.archive = archive;
    this.dir = dir;
    this.numberOfParallelCollections = numberOfParallelCollections;
    this.numberOfInsertionWorkersPerCollection = numberOfInsertionWorkersPerCollection;
    this.writeConcern = writeConcern;
    this.objectCheck = objectCheck;
    this.oplogReplay = oplogReplay;
    this.restoreDbUsersAndRoles = restoreDbUsersAndRoles;
    this.gzip = gzip;
    this.dropCollection = dropCollection;
    this.noIndexRestore = noIndexRestore;
    this.noOptionsRestore = noOptionsRestore;
    this.keepIndexVersion = keepIndexVersion;
    this.maintainInsertionOrder = maintainInsertionOrder;
    this.stopOnError = stopOnError;
    this.bypassDocumentValidation = bypassDocumentValidation;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MongoRestoreArguments", generator = "Immutables")
  private final class InitShim {
    private byte verboseBuildStage = STAGE_UNINITIALIZED;
    private boolean verbose;

    boolean verbose() {
      if (verboseBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (verboseBuildStage == STAGE_UNINITIALIZED) {
        verboseBuildStage = STAGE_INITIALIZING;
        this.verbose = ImmutableMongoRestoreArguments.super.verbose();
        verboseBuildStage = STAGE_INITIALIZED;
      }
      return this.verbose;
    }

    void verbose(boolean verbose) {
      this.verbose = verbose;
      verboseBuildStage = STAGE_INITIALIZED;
    }

    private byte objectCheckBuildStage = STAGE_UNINITIALIZED;
    private boolean objectCheck;

    boolean objectCheck() {
      if (objectCheckBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (objectCheckBuildStage == STAGE_UNINITIALIZED) {
        objectCheckBuildStage = STAGE_INITIALIZING;
        this.objectCheck = ImmutableMongoRestoreArguments.super.objectCheck();
        objectCheckBuildStage = STAGE_INITIALIZED;
      }
      return this.objectCheck;
    }

    void objectCheck(boolean objectCheck) {
      this.objectCheck = objectCheck;
      objectCheckBuildStage = STAGE_INITIALIZED;
    }

    private byte oplogReplayBuildStage = STAGE_UNINITIALIZED;
    private boolean oplogReplay;

    boolean oplogReplay() {
      if (oplogReplayBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (oplogReplayBuildStage == STAGE_UNINITIALIZED) {
        oplogReplayBuildStage = STAGE_INITIALIZING;
        this.oplogReplay = ImmutableMongoRestoreArguments.super.oplogReplay();
        oplogReplayBuildStage = STAGE_INITIALIZED;
      }
      return this.oplogReplay;
    }

    void oplogReplay(boolean oplogReplay) {
      this.oplogReplay = oplogReplay;
      oplogReplayBuildStage = STAGE_INITIALIZED;
    }

    private byte restoreDbUsersAndRolesBuildStage = STAGE_UNINITIALIZED;
    private boolean restoreDbUsersAndRoles;

    boolean restoreDbUsersAndRoles() {
      if (restoreDbUsersAndRolesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (restoreDbUsersAndRolesBuildStage == STAGE_UNINITIALIZED) {
        restoreDbUsersAndRolesBuildStage = STAGE_INITIALIZING;
        this.restoreDbUsersAndRoles = ImmutableMongoRestoreArguments.super.restoreDbUsersAndRoles();
        restoreDbUsersAndRolesBuildStage = STAGE_INITIALIZED;
      }
      return this.restoreDbUsersAndRoles;
    }

    void restoreDbUsersAndRoles(boolean restoreDbUsersAndRoles) {
      this.restoreDbUsersAndRoles = restoreDbUsersAndRoles;
      restoreDbUsersAndRolesBuildStage = STAGE_INITIALIZED;
    }

    private byte gzipBuildStage = STAGE_UNINITIALIZED;
    private boolean gzip;

    boolean gzip() {
      if (gzipBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (gzipBuildStage == STAGE_UNINITIALIZED) {
        gzipBuildStage = STAGE_INITIALIZING;
        this.gzip = ImmutableMongoRestoreArguments.super.gzip();
        gzipBuildStage = STAGE_INITIALIZED;
      }
      return this.gzip;
    }

    void gzip(boolean gzip) {
      this.gzip = gzip;
      gzipBuildStage = STAGE_INITIALIZED;
    }

    private byte dropCollectionBuildStage = STAGE_UNINITIALIZED;
    private boolean dropCollection;

    boolean dropCollection() {
      if (dropCollectionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dropCollectionBuildStage == STAGE_UNINITIALIZED) {
        dropCollectionBuildStage = STAGE_INITIALIZING;
        this.dropCollection = ImmutableMongoRestoreArguments.super.dropCollection();
        dropCollectionBuildStage = STAGE_INITIALIZED;
      }
      return this.dropCollection;
    }

    void dropCollection(boolean dropCollection) {
      this.dropCollection = dropCollection;
      dropCollectionBuildStage = STAGE_INITIALIZED;
    }

    private byte noIndexRestoreBuildStage = STAGE_UNINITIALIZED;
    private boolean noIndexRestore;

    boolean noIndexRestore() {
      if (noIndexRestoreBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (noIndexRestoreBuildStage == STAGE_UNINITIALIZED) {
        noIndexRestoreBuildStage = STAGE_INITIALIZING;
        this.noIndexRestore = ImmutableMongoRestoreArguments.super.noIndexRestore();
        noIndexRestoreBuildStage = STAGE_INITIALIZED;
      }
      return this.noIndexRestore;
    }

    void noIndexRestore(boolean noIndexRestore) {
      this.noIndexRestore = noIndexRestore;
      noIndexRestoreBuildStage = STAGE_INITIALIZED;
    }

    private byte noOptionsRestoreBuildStage = STAGE_UNINITIALIZED;
    private boolean noOptionsRestore;

    boolean noOptionsRestore() {
      if (noOptionsRestoreBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (noOptionsRestoreBuildStage == STAGE_UNINITIALIZED) {
        noOptionsRestoreBuildStage = STAGE_INITIALIZING;
        this.noOptionsRestore = ImmutableMongoRestoreArguments.super.noOptionsRestore();
        noOptionsRestoreBuildStage = STAGE_INITIALIZED;
      }
      return this.noOptionsRestore;
    }

    void noOptionsRestore(boolean noOptionsRestore) {
      this.noOptionsRestore = noOptionsRestore;
      noOptionsRestoreBuildStage = STAGE_INITIALIZED;
    }

    private byte keepIndexVersionBuildStage = STAGE_UNINITIALIZED;
    private boolean keepIndexVersion;

    boolean keepIndexVersion() {
      if (keepIndexVersionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (keepIndexVersionBuildStage == STAGE_UNINITIALIZED) {
        keepIndexVersionBuildStage = STAGE_INITIALIZING;
        this.keepIndexVersion = ImmutableMongoRestoreArguments.super.keepIndexVersion();
        keepIndexVersionBuildStage = STAGE_INITIALIZED;
      }
      return this.keepIndexVersion;
    }

    void keepIndexVersion(boolean keepIndexVersion) {
      this.keepIndexVersion = keepIndexVersion;
      keepIndexVersionBuildStage = STAGE_INITIALIZED;
    }

    private byte maintainInsertionOrderBuildStage = STAGE_UNINITIALIZED;
    private boolean maintainInsertionOrder;

    boolean maintainInsertionOrder() {
      if (maintainInsertionOrderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maintainInsertionOrderBuildStage == STAGE_UNINITIALIZED) {
        maintainInsertionOrderBuildStage = STAGE_INITIALIZING;
        this.maintainInsertionOrder = ImmutableMongoRestoreArguments.super.maintainInsertionOrder();
        maintainInsertionOrderBuildStage = STAGE_INITIALIZED;
      }
      return this.maintainInsertionOrder;
    }

    void maintainInsertionOrder(boolean maintainInsertionOrder) {
      this.maintainInsertionOrder = maintainInsertionOrder;
      maintainInsertionOrderBuildStage = STAGE_INITIALIZED;
    }

    private byte stopOnErrorBuildStage = STAGE_UNINITIALIZED;
    private boolean stopOnError;

    boolean stopOnError() {
      if (stopOnErrorBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stopOnErrorBuildStage == STAGE_UNINITIALIZED) {
        stopOnErrorBuildStage = STAGE_INITIALIZING;
        this.stopOnError = ImmutableMongoRestoreArguments.super.stopOnError();
        stopOnErrorBuildStage = STAGE_INITIALIZED;
      }
      return this.stopOnError;
    }

    void stopOnError(boolean stopOnError) {
      this.stopOnError = stopOnError;
      stopOnErrorBuildStage = STAGE_INITIALIZED;
    }

    private byte bypassDocumentValidationBuildStage = STAGE_UNINITIALIZED;
    private boolean bypassDocumentValidation;

    boolean bypassDocumentValidation() {
      if (bypassDocumentValidationBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (bypassDocumentValidationBuildStage == STAGE_UNINITIALIZED) {
        bypassDocumentValidationBuildStage = STAGE_INITIALIZING;
        this.bypassDocumentValidation = ImmutableMongoRestoreArguments.super.bypassDocumentValidation();
        bypassDocumentValidationBuildStage = STAGE_INITIALIZED;
      }
      return this.bypassDocumentValidation;
    }

    void bypassDocumentValidation(boolean bypassDocumentValidation) {
      this.bypassDocumentValidation = bypassDocumentValidation;
      bypassDocumentValidationBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (verboseBuildStage == STAGE_INITIALIZING) attributes.add("verbose");
      if (objectCheckBuildStage == STAGE_INITIALIZING) attributes.add("objectCheck");
      if (oplogReplayBuildStage == STAGE_INITIALIZING) attributes.add("oplogReplay");
      if (restoreDbUsersAndRolesBuildStage == STAGE_INITIALIZING) attributes.add("restoreDbUsersAndRoles");
      if (gzipBuildStage == STAGE_INITIALIZING) attributes.add("gzip");
      if (dropCollectionBuildStage == STAGE_INITIALIZING) attributes.add("dropCollection");
      if (noIndexRestoreBuildStage == STAGE_INITIALIZING) attributes.add("noIndexRestore");
      if (noOptionsRestoreBuildStage == STAGE_INITIALIZING) attributes.add("noOptionsRestore");
      if (keepIndexVersionBuildStage == STAGE_INITIALIZING) attributes.add("keepIndexVersion");
      if (maintainInsertionOrderBuildStage == STAGE_INITIALIZING) attributes.add("maintainInsertionOrder");
      if (stopOnErrorBuildStage == STAGE_INITIALIZING) attributes.add("stopOnError");
      if (bypassDocumentValidationBuildStage == STAGE_INITIALIZING) attributes.add("bypassDocumentValidation");
      return "Cannot build MongoRestoreArguments, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code verbose} attribute
   */
  @Override
  public boolean verbose() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.verbose()
        : this.verbose;
  }

  /**
   * @return The value of the {@code databaseName} attribute
   */
  @Override
  public Optional<String> databaseName() {
    return Optional.ofNullable(databaseName);
  }

  /**
   * @return The value of the {@code collectionName} attribute
   */
  @Override
  public Optional<String> collectionName() {
    return Optional.ofNullable(collectionName);
  }

  /**
   * @return The value of the {@code oplogLimit} attribute
   */
  @Override
  public OptionalLong oplogLimit() {
    return oplogLimit != null
        ? OptionalLong.of(oplogLimit)
        : OptionalLong.empty();
  }

  /**
   * @return The value of the {@code archive} attribute
   */
  @Override
  public Optional<String> archive() {
    return Optional.ofNullable(archive);
  }

  /**
   * @return The value of the {@code dir} attribute
   */
  @Override
  public Optional<String> dir() {
    return Optional.ofNullable(dir);
  }

  /**
   * @return The value of the {@code numberOfParallelCollections} attribute
   */
  @Override
  public OptionalInt numberOfParallelCollections() {
    return numberOfParallelCollections != null
        ? OptionalInt.of(numberOfParallelCollections)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code numberOfInsertionWorkersPerCollection} attribute
   */
  @Override
  public OptionalInt numberOfInsertionWorkersPerCollection() {
    return numberOfInsertionWorkersPerCollection != null
        ? OptionalInt.of(numberOfInsertionWorkersPerCollection)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code writeConcern} attribute
   */
  @Override
  public Optional<String> writeConcern() {
    return Optional.ofNullable(writeConcern);
  }

  /**
   * @return The value of the {@code objectCheck} attribute
   */
  @Override
  public boolean objectCheck() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.objectCheck()
        : this.objectCheck;
  }

  /**
   * @return The value of the {@code oplogReplay} attribute
   */
  @Override
  public boolean oplogReplay() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.oplogReplay()
        : this.oplogReplay;
  }

  /**
   * @return The value of the {@code restoreDbUsersAndRoles} attribute
   */
  @Override
  public boolean restoreDbUsersAndRoles() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.restoreDbUsersAndRoles()
        : this.restoreDbUsersAndRoles;
  }

  /**
   * @return The value of the {@code gzip} attribute
   */
  @Override
  public boolean gzip() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.gzip()
        : this.gzip;
  }

  /**
   * @return The value of the {@code dropCollection} attribute
   */
  @Override
  public boolean dropCollection() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.dropCollection()
        : this.dropCollection;
  }

  /**
   * @return The value of the {@code noIndexRestore} attribute
   */
  @Override
  public boolean noIndexRestore() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.noIndexRestore()
        : this.noIndexRestore;
  }

  /**
   * @return The value of the {@code noOptionsRestore} attribute
   */
  @Override
  public boolean noOptionsRestore() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.noOptionsRestore()
        : this.noOptionsRestore;
  }

  /**
   * @return The value of the {@code keepIndexVersion} attribute
   */
  @Override
  public boolean keepIndexVersion() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.keepIndexVersion()
        : this.keepIndexVersion;
  }

  /**
   * @return The value of the {@code maintainInsertionOrder} attribute
   */
  @Override
  public boolean maintainInsertionOrder() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.maintainInsertionOrder()
        : this.maintainInsertionOrder;
  }

  /**
   * @return The value of the {@code stopOnError} attribute
   */
  @Override
  public boolean stopOnError() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.stopOnError()
        : this.stopOnError;
  }

  /**
   * @return The value of the {@code bypassDocumentValidation} attribute
   */
  @Override
  public boolean bypassDocumentValidation() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.bypassDocumentValidation()
        : this.bypassDocumentValidation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreArguments#verbose() verbose} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verbose
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreArguments withVerbose(boolean value) {
    if (this.verbose == value) return this;
    return new ImmutableMongoRestoreArguments(
        value,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreArguments#databaseName() databaseName} attribute.
   * @param value The value for databaseName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withDatabaseName(String value) {
    String newValue = Objects.requireNonNull(value, "databaseName");
    if (Objects.equals(this.databaseName, newValue)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        newValue,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreArguments#databaseName() databaseName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for databaseName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withDatabaseName(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.databaseName, value)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        value,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreArguments#collectionName() collectionName} attribute.
   * @param value The value for collectionName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withCollectionName(String value) {
    String newValue = Objects.requireNonNull(value, "collectionName");
    if (Objects.equals(this.collectionName, newValue)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        newValue,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreArguments#collectionName() collectionName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for collectionName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withCollectionName(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.collectionName, value)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        value,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreArguments#oplogLimit() oplogLimit} attribute.
   * @param value The value for oplogLimit
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withOplogLimit(long value) {
    Long newValue = value;
    if (Objects.equals(this.oplogLimit, newValue)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        newValue,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreArguments#oplogLimit() oplogLimit} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for oplogLimit
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withOplogLimit(OptionalLong optional) {
    Long value = optional.isPresent() ? optional.getAsLong() : null;
    if (Objects.equals(this.oplogLimit, value)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        value,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreArguments#archive() archive} attribute.
   * @param value The value for archive
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withArchive(String value) {
    String newValue = Objects.requireNonNull(value, "archive");
    if (Objects.equals(this.archive, newValue)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        newValue,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreArguments#archive() archive} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for archive
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withArchive(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.archive, value)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        value,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreArguments#dir() dir} attribute.
   * @param value The value for dir
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withDir(String value) {
    String newValue = Objects.requireNonNull(value, "dir");
    if (Objects.equals(this.dir, newValue)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        newValue,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreArguments#dir() dir} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dir
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withDir(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.dir, value)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        value,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreArguments#numberOfParallelCollections() numberOfParallelCollections} attribute.
   * @param value The value for numberOfParallelCollections
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withNumberOfParallelCollections(int value) {
    Integer newValue = value;
    if (Objects.equals(this.numberOfParallelCollections, newValue)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        newValue,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreArguments#numberOfParallelCollections() numberOfParallelCollections} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for numberOfParallelCollections
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withNumberOfParallelCollections(OptionalInt optional) {
    Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.numberOfParallelCollections, value)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        value,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreArguments#numberOfInsertionWorkersPerCollection() numberOfInsertionWorkersPerCollection} attribute.
   * @param value The value for numberOfInsertionWorkersPerCollection
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withNumberOfInsertionWorkersPerCollection(int value) {
    Integer newValue = value;
    if (Objects.equals(this.numberOfInsertionWorkersPerCollection, newValue)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        newValue,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreArguments#numberOfInsertionWorkersPerCollection() numberOfInsertionWorkersPerCollection} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for numberOfInsertionWorkersPerCollection
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withNumberOfInsertionWorkersPerCollection(OptionalInt optional) {
    Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.numberOfInsertionWorkersPerCollection, value)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        value,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoRestoreArguments#writeConcern() writeConcern} attribute.
   * @param value The value for writeConcern
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withWriteConcern(String value) {
    String newValue = Objects.requireNonNull(value, "writeConcern");
    if (Objects.equals(this.writeConcern, newValue)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        newValue,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoRestoreArguments#writeConcern() writeConcern} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for writeConcern
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoRestoreArguments withWriteConcern(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.writeConcern, value)) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        value,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreArguments#objectCheck() objectCheck} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for objectCheck
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreArguments withObjectCheck(boolean value) {
    if (this.objectCheck == value) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        value,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreArguments#oplogReplay() oplogReplay} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for oplogReplay
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreArguments withOplogReplay(boolean value) {
    if (this.oplogReplay == value) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        value,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreArguments#restoreDbUsersAndRoles() restoreDbUsersAndRoles} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for restoreDbUsersAndRoles
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreArguments withRestoreDbUsersAndRoles(boolean value) {
    if (this.restoreDbUsersAndRoles == value) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        value,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreArguments#gzip() gzip} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gzip
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreArguments withGzip(boolean value) {
    if (this.gzip == value) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        value,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreArguments#dropCollection() dropCollection} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dropCollection
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreArguments withDropCollection(boolean value) {
    if (this.dropCollection == value) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        value,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreArguments#noIndexRestore() noIndexRestore} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for noIndexRestore
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreArguments withNoIndexRestore(boolean value) {
    if (this.noIndexRestore == value) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        value,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreArguments#noOptionsRestore() noOptionsRestore} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for noOptionsRestore
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreArguments withNoOptionsRestore(boolean value) {
    if (this.noOptionsRestore == value) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        value,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreArguments#keepIndexVersion() keepIndexVersion} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keepIndexVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreArguments withKeepIndexVersion(boolean value) {
    if (this.keepIndexVersion == value) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        value,
        this.maintainInsertionOrder,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreArguments#maintainInsertionOrder() maintainInsertionOrder} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maintainInsertionOrder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreArguments withMaintainInsertionOrder(boolean value) {
    if (this.maintainInsertionOrder == value) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        value,
        this.stopOnError,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreArguments#stopOnError() stopOnError} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stopOnError
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreArguments withStopOnError(boolean value) {
    if (this.stopOnError == value) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        value,
        this.bypassDocumentValidation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoRestoreArguments#bypassDocumentValidation() bypassDocumentValidation} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bypassDocumentValidation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoRestoreArguments withBypassDocumentValidation(boolean value) {
    if (this.bypassDocumentValidation == value) return this;
    return new ImmutableMongoRestoreArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.oplogLimit,
        this.archive,
        this.dir,
        this.numberOfParallelCollections,
        this.numberOfInsertionWorkersPerCollection,
        this.writeConcern,
        this.objectCheck,
        this.oplogReplay,
        this.restoreDbUsersAndRoles,
        this.gzip,
        this.dropCollection,
        this.noIndexRestore,
        this.noOptionsRestore,
        this.keepIndexVersion,
        this.maintainInsertionOrder,
        this.stopOnError,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoRestoreArguments} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoRestoreArguments
        && equalTo((ImmutableMongoRestoreArguments) another);
  }

  private boolean equalTo(ImmutableMongoRestoreArguments another) {
    return verbose == another.verbose
        && Objects.equals(databaseName, another.databaseName)
        && Objects.equals(collectionName, another.collectionName)
        && Objects.equals(oplogLimit, another.oplogLimit)
        && Objects.equals(archive, another.archive)
        && Objects.equals(dir, another.dir)
        && Objects.equals(numberOfParallelCollections, another.numberOfParallelCollections)
        && Objects.equals(numberOfInsertionWorkersPerCollection, another.numberOfInsertionWorkersPerCollection)
        && Objects.equals(writeConcern, another.writeConcern)
        && objectCheck == another.objectCheck
        && oplogReplay == another.oplogReplay
        && restoreDbUsersAndRoles == another.restoreDbUsersAndRoles
        && gzip == another.gzip
        && dropCollection == another.dropCollection
        && noIndexRestore == another.noIndexRestore
        && noOptionsRestore == another.noOptionsRestore
        && keepIndexVersion == another.keepIndexVersion
        && maintainInsertionOrder == another.maintainInsertionOrder
        && stopOnError == another.stopOnError
        && bypassDocumentValidation == another.bypassDocumentValidation;
  }

  /**
   * Computes a hash code from attributes: {@code verbose}, {@code databaseName}, {@code collectionName}, {@code oplogLimit}, {@code archive}, {@code dir}, {@code numberOfParallelCollections}, {@code numberOfInsertionWorkersPerCollection}, {@code writeConcern}, {@code objectCheck}, {@code oplogReplay}, {@code restoreDbUsersAndRoles}, {@code gzip}, {@code dropCollection}, {@code noIndexRestore}, {@code noOptionsRestore}, {@code keepIndexVersion}, {@code maintainInsertionOrder}, {@code stopOnError}, {@code bypassDocumentValidation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Boolean.hashCode(verbose);
    h += (h << 5) + Objects.hashCode(databaseName);
    h += (h << 5) + Objects.hashCode(collectionName);
    h += (h << 5) + Objects.hashCode(oplogLimit);
    h += (h << 5) + Objects.hashCode(archive);
    h += (h << 5) + Objects.hashCode(dir);
    h += (h << 5) + Objects.hashCode(numberOfParallelCollections);
    h += (h << 5) + Objects.hashCode(numberOfInsertionWorkersPerCollection);
    h += (h << 5) + Objects.hashCode(writeConcern);
    h += (h << 5) + Boolean.hashCode(objectCheck);
    h += (h << 5) + Boolean.hashCode(oplogReplay);
    h += (h << 5) + Boolean.hashCode(restoreDbUsersAndRoles);
    h += (h << 5) + Boolean.hashCode(gzip);
    h += (h << 5) + Boolean.hashCode(dropCollection);
    h += (h << 5) + Boolean.hashCode(noIndexRestore);
    h += (h << 5) + Boolean.hashCode(noOptionsRestore);
    h += (h << 5) + Boolean.hashCode(keepIndexVersion);
    h += (h << 5) + Boolean.hashCode(maintainInsertionOrder);
    h += (h << 5) + Boolean.hashCode(stopOnError);
    h += (h << 5) + Boolean.hashCode(bypassDocumentValidation);
    return h;
  }

  /**
   * Prints the immutable value {@code MongoRestoreArguments} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("MongoRestoreArguments{");
    builder.append("verbose=").append(verbose);
    if (databaseName != null) {
      builder.append(", ");
      builder.append("databaseName=").append(databaseName);
    }
    if (collectionName != null) {
      builder.append(", ");
      builder.append("collectionName=").append(collectionName);
    }
    if (oplogLimit != null) {
      builder.append(", ");
      builder.append("oplogLimit=").append(oplogLimit);
    }
    if (archive != null) {
      builder.append(", ");
      builder.append("archive=").append(archive);
    }
    if (dir != null) {
      builder.append(", ");
      builder.append("dir=").append(dir);
    }
    if (numberOfParallelCollections != null) {
      builder.append(", ");
      builder.append("numberOfParallelCollections=").append(numberOfParallelCollections);
    }
    if (numberOfInsertionWorkersPerCollection != null) {
      builder.append(", ");
      builder.append("numberOfInsertionWorkersPerCollection=").append(numberOfInsertionWorkersPerCollection);
    }
    if (writeConcern != null) {
      builder.append(", ");
      builder.append("writeConcern=").append(writeConcern);
    }
    builder.append(", ");
    builder.append("objectCheck=").append(objectCheck);
    builder.append(", ");
    builder.append("oplogReplay=").append(oplogReplay);
    builder.append(", ");
    builder.append("restoreDbUsersAndRoles=").append(restoreDbUsersAndRoles);
    builder.append(", ");
    builder.append("gzip=").append(gzip);
    builder.append(", ");
    builder.append("dropCollection=").append(dropCollection);
    builder.append(", ");
    builder.append("noIndexRestore=").append(noIndexRestore);
    builder.append(", ");
    builder.append("noOptionsRestore=").append(noOptionsRestore);
    builder.append(", ");
    builder.append("keepIndexVersion=").append(keepIndexVersion);
    builder.append(", ");
    builder.append("maintainInsertionOrder=").append(maintainInsertionOrder);
    builder.append(", ");
    builder.append("stopOnError=").append(stopOnError);
    builder.append(", ");
    builder.append("bypassDocumentValidation=").append(bypassDocumentValidation);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link MongoRestoreArguments} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoRestoreArguments instance
   */
  public static ImmutableMongoRestoreArguments copyOf(MongoRestoreArguments instance) {
    if (instance instanceof ImmutableMongoRestoreArguments) {
      return (ImmutableMongoRestoreArguments) instance;
    }
    return ImmutableMongoRestoreArguments.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongoRestoreArguments ImmutableMongoRestoreArguments}.
   * <pre>
   * ImmutableMongoRestoreArguments.builder()
   *    .verbose(boolean) // optional {@link MongoRestoreArguments#verbose() verbose}
   *    .databaseName(String) // optional {@link MongoRestoreArguments#databaseName() databaseName}
   *    .collectionName(String) // optional {@link MongoRestoreArguments#collectionName() collectionName}
   *    .oplogLimit(long) // optional {@link MongoRestoreArguments#oplogLimit() oplogLimit}
   *    .archive(String) // optional {@link MongoRestoreArguments#archive() archive}
   *    .dir(String) // optional {@link MongoRestoreArguments#dir() dir}
   *    .numberOfParallelCollections(int) // optional {@link MongoRestoreArguments#numberOfParallelCollections() numberOfParallelCollections}
   *    .numberOfInsertionWorkersPerCollection(int) // optional {@link MongoRestoreArguments#numberOfInsertionWorkersPerCollection() numberOfInsertionWorkersPerCollection}
   *    .writeConcern(String) // optional {@link MongoRestoreArguments#writeConcern() writeConcern}
   *    .objectCheck(boolean) // optional {@link MongoRestoreArguments#objectCheck() objectCheck}
   *    .oplogReplay(boolean) // optional {@link MongoRestoreArguments#oplogReplay() oplogReplay}
   *    .restoreDbUsersAndRoles(boolean) // optional {@link MongoRestoreArguments#restoreDbUsersAndRoles() restoreDbUsersAndRoles}
   *    .gzip(boolean) // optional {@link MongoRestoreArguments#gzip() gzip}
   *    .dropCollection(boolean) // optional {@link MongoRestoreArguments#dropCollection() dropCollection}
   *    .noIndexRestore(boolean) // optional {@link MongoRestoreArguments#noIndexRestore() noIndexRestore}
   *    .noOptionsRestore(boolean) // optional {@link MongoRestoreArguments#noOptionsRestore() noOptionsRestore}
   *    .keepIndexVersion(boolean) // optional {@link MongoRestoreArguments#keepIndexVersion() keepIndexVersion}
   *    .maintainInsertionOrder(boolean) // optional {@link MongoRestoreArguments#maintainInsertionOrder() maintainInsertionOrder}
   *    .stopOnError(boolean) // optional {@link MongoRestoreArguments#stopOnError() stopOnError}
   *    .bypassDocumentValidation(boolean) // optional {@link MongoRestoreArguments#bypassDocumentValidation() bypassDocumentValidation}
   *    .build();
   * </pre>
   * @return A new ImmutableMongoRestoreArguments builder
   */
  public static ImmutableMongoRestoreArguments.Builder builder() {
    return new ImmutableMongoRestoreArguments.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongoRestoreArguments ImmutableMongoRestoreArguments}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongoRestoreArguments", generator = "Immutables")
  public static final class Builder {
    private static final long OPT_BIT_VERBOSE = 0x1L;
    private static final long OPT_BIT_OBJECT_CHECK = 0x2L;
    private static final long OPT_BIT_OPLOG_REPLAY = 0x4L;
    private static final long OPT_BIT_RESTORE_DB_USERS_AND_ROLES = 0x8L;
    private static final long OPT_BIT_GZIP = 0x10L;
    private static final long OPT_BIT_DROP_COLLECTION = 0x20L;
    private static final long OPT_BIT_NO_INDEX_RESTORE = 0x40L;
    private static final long OPT_BIT_NO_OPTIONS_RESTORE = 0x80L;
    private static final long OPT_BIT_KEEP_INDEX_VERSION = 0x100L;
    private static final long OPT_BIT_MAINTAIN_INSERTION_ORDER = 0x200L;
    private static final long OPT_BIT_STOP_ON_ERROR = 0x400L;
    private static final long OPT_BIT_BYPASS_DOCUMENT_VALIDATION = 0x800L;
    private long optBits;

    private boolean verbose;
    private String databaseName;
    private String collectionName;
    private Long oplogLimit;
    private String archive;
    private String dir;
    private Integer numberOfParallelCollections;
    private Integer numberOfInsertionWorkersPerCollection;
    private String writeConcern;
    private boolean objectCheck;
    private boolean oplogReplay;
    private boolean restoreDbUsersAndRoles;
    private boolean gzip;
    private boolean dropCollection;
    private boolean noIndexRestore;
    private boolean noOptionsRestore;
    private boolean keepIndexVersion;
    private boolean maintainInsertionOrder;
    private boolean stopOnError;
    private boolean bypassDocumentValidation;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MongoRestoreArguments} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoRestoreArguments instance) {
      Objects.requireNonNull(instance, "instance");
      verbose(instance.verbose());
      Optional<String> databaseNameOptional = instance.databaseName();
      if (databaseNameOptional.isPresent()) {
        databaseName(databaseNameOptional);
      }
      Optional<String> collectionNameOptional = instance.collectionName();
      if (collectionNameOptional.isPresent()) {
        collectionName(collectionNameOptional);
      }
      OptionalLong oplogLimitOptional = instance.oplogLimit();
      if (oplogLimitOptional.isPresent()) {
        oplogLimit(oplogLimitOptional);
      }
      Optional<String> archiveOptional = instance.archive();
      if (archiveOptional.isPresent()) {
        archive(archiveOptional);
      }
      Optional<String> dirOptional = instance.dir();
      if (dirOptional.isPresent()) {
        dir(dirOptional);
      }
      OptionalInt numberOfParallelCollectionsOptional = instance.numberOfParallelCollections();
      if (numberOfParallelCollectionsOptional.isPresent()) {
        numberOfParallelCollections(numberOfParallelCollectionsOptional);
      }
      OptionalInt numberOfInsertionWorkersPerCollectionOptional = instance.numberOfInsertionWorkersPerCollection();
      if (numberOfInsertionWorkersPerCollectionOptional.isPresent()) {
        numberOfInsertionWorkersPerCollection(numberOfInsertionWorkersPerCollectionOptional);
      }
      Optional<String> writeConcernOptional = instance.writeConcern();
      if (writeConcernOptional.isPresent()) {
        writeConcern(writeConcernOptional);
      }
      objectCheck(instance.objectCheck());
      oplogReplay(instance.oplogReplay());
      restoreDbUsersAndRoles(instance.restoreDbUsersAndRoles());
      gzip(instance.gzip());
      dropCollection(instance.dropCollection());
      noIndexRestore(instance.noIndexRestore());
      noOptionsRestore(instance.noOptionsRestore());
      keepIndexVersion(instance.keepIndexVersion());
      maintainInsertionOrder(instance.maintainInsertionOrder());
      stopOnError(instance.stopOnError());
      bypassDocumentValidation(instance.bypassDocumentValidation());
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreArguments#verbose() verbose} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreArguments#verbose() verbose}.</em>
     * @param verbose The value for verbose 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder verbose(boolean verbose) {
      this.verbose = verbose;
      optBits |= OPT_BIT_VERBOSE;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#databaseName() databaseName} to databaseName.
     * @param databaseName The value for databaseName
     * @return {@code this} builder for chained invocation
     */
    public final Builder databaseName(String databaseName) {
      this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#databaseName() databaseName} to databaseName.
     * @param databaseName The value for databaseName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder databaseName(Optional<String> databaseName) {
      this.databaseName = databaseName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#collectionName() collectionName} to collectionName.
     * @param collectionName The value for collectionName
     * @return {@code this} builder for chained invocation
     */
    public final Builder collectionName(String collectionName) {
      this.collectionName = Objects.requireNonNull(collectionName, "collectionName");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#collectionName() collectionName} to collectionName.
     * @param collectionName The value for collectionName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder collectionName(Optional<String> collectionName) {
      this.collectionName = collectionName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#oplogLimit() oplogLimit} to oplogLimit.
     * @param oplogLimit The value for oplogLimit
     * @return {@code this} builder for chained invocation
     */
    public final Builder oplogLimit(long oplogLimit) {
      this.oplogLimit = oplogLimit;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#oplogLimit() oplogLimit} to oplogLimit.
     * @param oplogLimit The value for oplogLimit
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder oplogLimit(OptionalLong oplogLimit) {
      this.oplogLimit = oplogLimit.isPresent() ? oplogLimit.getAsLong() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#archive() archive} to archive.
     * @param archive The value for archive
     * @return {@code this} builder for chained invocation
     */
    public final Builder archive(String archive) {
      this.archive = Objects.requireNonNull(archive, "archive");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#archive() archive} to archive.
     * @param archive The value for archive
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder archive(Optional<String> archive) {
      this.archive = archive.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#dir() dir} to dir.
     * @param dir The value for dir
     * @return {@code this} builder for chained invocation
     */
    public final Builder dir(String dir) {
      this.dir = Objects.requireNonNull(dir, "dir");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#dir() dir} to dir.
     * @param dir The value for dir
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dir(Optional<String> dir) {
      this.dir = dir.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#numberOfParallelCollections() numberOfParallelCollections} to numberOfParallelCollections.
     * @param numberOfParallelCollections The value for numberOfParallelCollections
     * @return {@code this} builder for chained invocation
     */
    public final Builder numberOfParallelCollections(int numberOfParallelCollections) {
      this.numberOfParallelCollections = numberOfParallelCollections;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#numberOfParallelCollections() numberOfParallelCollections} to numberOfParallelCollections.
     * @param numberOfParallelCollections The value for numberOfParallelCollections
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder numberOfParallelCollections(OptionalInt numberOfParallelCollections) {
      this.numberOfParallelCollections = numberOfParallelCollections.isPresent() ? numberOfParallelCollections.getAsInt() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#numberOfInsertionWorkersPerCollection() numberOfInsertionWorkersPerCollection} to numberOfInsertionWorkersPerCollection.
     * @param numberOfInsertionWorkersPerCollection The value for numberOfInsertionWorkersPerCollection
     * @return {@code this} builder for chained invocation
     */
    public final Builder numberOfInsertionWorkersPerCollection(int numberOfInsertionWorkersPerCollection) {
      this.numberOfInsertionWorkersPerCollection = numberOfInsertionWorkersPerCollection;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#numberOfInsertionWorkersPerCollection() numberOfInsertionWorkersPerCollection} to numberOfInsertionWorkersPerCollection.
     * @param numberOfInsertionWorkersPerCollection The value for numberOfInsertionWorkersPerCollection
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder numberOfInsertionWorkersPerCollection(OptionalInt numberOfInsertionWorkersPerCollection) {
      this.numberOfInsertionWorkersPerCollection = numberOfInsertionWorkersPerCollection.isPresent() ? numberOfInsertionWorkersPerCollection.getAsInt() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#writeConcern() writeConcern} to writeConcern.
     * @param writeConcern The value for writeConcern
     * @return {@code this} builder for chained invocation
     */
    public final Builder writeConcern(String writeConcern) {
      this.writeConcern = Objects.requireNonNull(writeConcern, "writeConcern");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoRestoreArguments#writeConcern() writeConcern} to writeConcern.
     * @param writeConcern The value for writeConcern
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder writeConcern(Optional<String> writeConcern) {
      this.writeConcern = writeConcern.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreArguments#objectCheck() objectCheck} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreArguments#objectCheck() objectCheck}.</em>
     * @param objectCheck The value for objectCheck 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder objectCheck(boolean objectCheck) {
      this.objectCheck = objectCheck;
      optBits |= OPT_BIT_OBJECT_CHECK;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreArguments#oplogReplay() oplogReplay} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreArguments#oplogReplay() oplogReplay}.</em>
     * @param oplogReplay The value for oplogReplay 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder oplogReplay(boolean oplogReplay) {
      this.oplogReplay = oplogReplay;
      optBits |= OPT_BIT_OPLOG_REPLAY;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreArguments#restoreDbUsersAndRoles() restoreDbUsersAndRoles} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreArguments#restoreDbUsersAndRoles() restoreDbUsersAndRoles}.</em>
     * @param restoreDbUsersAndRoles The value for restoreDbUsersAndRoles 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder restoreDbUsersAndRoles(boolean restoreDbUsersAndRoles) {
      this.restoreDbUsersAndRoles = restoreDbUsersAndRoles;
      optBits |= OPT_BIT_RESTORE_DB_USERS_AND_ROLES;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreArguments#gzip() gzip} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreArguments#gzip() gzip}.</em>
     * @param gzip The value for gzip 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder gzip(boolean gzip) {
      this.gzip = gzip;
      optBits |= OPT_BIT_GZIP;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreArguments#dropCollection() dropCollection} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreArguments#dropCollection() dropCollection}.</em>
     * @param dropCollection The value for dropCollection 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropCollection(boolean dropCollection) {
      this.dropCollection = dropCollection;
      optBits |= OPT_BIT_DROP_COLLECTION;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreArguments#noIndexRestore() noIndexRestore} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreArguments#noIndexRestore() noIndexRestore}.</em>
     * @param noIndexRestore The value for noIndexRestore 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder noIndexRestore(boolean noIndexRestore) {
      this.noIndexRestore = noIndexRestore;
      optBits |= OPT_BIT_NO_INDEX_RESTORE;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreArguments#noOptionsRestore() noOptionsRestore} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreArguments#noOptionsRestore() noOptionsRestore}.</em>
     * @param noOptionsRestore The value for noOptionsRestore 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder noOptionsRestore(boolean noOptionsRestore) {
      this.noOptionsRestore = noOptionsRestore;
      optBits |= OPT_BIT_NO_OPTIONS_RESTORE;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreArguments#keepIndexVersion() keepIndexVersion} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreArguments#keepIndexVersion() keepIndexVersion}.</em>
     * @param keepIndexVersion The value for keepIndexVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder keepIndexVersion(boolean keepIndexVersion) {
      this.keepIndexVersion = keepIndexVersion;
      optBits |= OPT_BIT_KEEP_INDEX_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreArguments#maintainInsertionOrder() maintainInsertionOrder} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreArguments#maintainInsertionOrder() maintainInsertionOrder}.</em>
     * @param maintainInsertionOrder The value for maintainInsertionOrder 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maintainInsertionOrder(boolean maintainInsertionOrder) {
      this.maintainInsertionOrder = maintainInsertionOrder;
      optBits |= OPT_BIT_MAINTAIN_INSERTION_ORDER;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreArguments#stopOnError() stopOnError} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreArguments#stopOnError() stopOnError}.</em>
     * @param stopOnError The value for stopOnError 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stopOnError(boolean stopOnError) {
      this.stopOnError = stopOnError;
      optBits |= OPT_BIT_STOP_ON_ERROR;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoRestoreArguments#bypassDocumentValidation() bypassDocumentValidation} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoRestoreArguments#bypassDocumentValidation() bypassDocumentValidation}.</em>
     * @param bypassDocumentValidation The value for bypassDocumentValidation 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bypassDocumentValidation(boolean bypassDocumentValidation) {
      this.bypassDocumentValidation = bypassDocumentValidation;
      optBits |= OPT_BIT_BYPASS_DOCUMENT_VALIDATION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongoRestoreArguments ImmutableMongoRestoreArguments}.
     * @return An immutable instance of MongoRestoreArguments
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoRestoreArguments build() {
      return new ImmutableMongoRestoreArguments(this);
    }

    private boolean verboseIsSet() {
      return (optBits & OPT_BIT_VERBOSE) != 0;
    }

    private boolean objectCheckIsSet() {
      return (optBits & OPT_BIT_OBJECT_CHECK) != 0;
    }

    private boolean oplogReplayIsSet() {
      return (optBits & OPT_BIT_OPLOG_REPLAY) != 0;
    }

    private boolean restoreDbUsersAndRolesIsSet() {
      return (optBits & OPT_BIT_RESTORE_DB_USERS_AND_ROLES) != 0;
    }

    private boolean gzipIsSet() {
      return (optBits & OPT_BIT_GZIP) != 0;
    }

    private boolean dropCollectionIsSet() {
      return (optBits & OPT_BIT_DROP_COLLECTION) != 0;
    }

    private boolean noIndexRestoreIsSet() {
      return (optBits & OPT_BIT_NO_INDEX_RESTORE) != 0;
    }

    private boolean noOptionsRestoreIsSet() {
      return (optBits & OPT_BIT_NO_OPTIONS_RESTORE) != 0;
    }

    private boolean keepIndexVersionIsSet() {
      return (optBits & OPT_BIT_KEEP_INDEX_VERSION) != 0;
    }

    private boolean maintainInsertionOrderIsSet() {
      return (optBits & OPT_BIT_MAINTAIN_INSERTION_ORDER) != 0;
    }

    private boolean stopOnErrorIsSet() {
      return (optBits & OPT_BIT_STOP_ON_ERROR) != 0;
    }

    private boolean bypassDocumentValidationIsSet() {
      return (optBits & OPT_BIT_BYPASS_DOCUMENT_VALIDATION) != 0;
    }
  }
}
