/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.embed.mongo.transitions.PackageOfCommandDistribution;
import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.io.directories.PersistentDir;
import de.flapdoodle.embed.process.store.ContentHashExtractedFileSetStore;
import de.flapdoodle.embed.process.store.DownloadCache;
import de.flapdoodle.embed.process.store.ExtractedFileSetStore;
import de.flapdoodle.embed.process.store.LocalDownloadCache;
import de.flapdoodle.embed.process.transitions.DownloadPackage;
import de.flapdoodle.embed.process.transitions.ExtractPackage;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.Transitions;
import de.flapdoodle.reverse.transitions.Derive;
import de.flapdoodle.reverse.transitions.Start;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import org.immutables.value.Value;

public interface ExtractFileSet {
    @Value.Default
    default public Map<String, String> systemEnv() {
        return System.getenv();
    }

    @Value.Default
    default public Transition<PersistentDir> persistentBaseDir() {
        return Start.to(PersistentDir.class).providedBy(() -> Optional.ofNullable(this.systemEnv().get("EMBEDDED_MONGO_ARTIFACTS")).map(x$0 -> Paths.get(x$0, new String[0])).map(PersistentDir::of).orElseGet(PersistentDir.userHome((String)".embedmongo")));
    }

    @Value.Default
    default public Transition<DownloadCache> downloadCache() {
        return Derive.given(PersistentDir.class).state(DownloadCache.class).deriveBy(storeBaseDir -> new LocalDownloadCache(((Path)storeBaseDir.value()).resolve("archives"))).withTransitionLabel("downloadCache");
    }

    @Value.Default
    default public Transition<ExtractedFileSetStore> extractedFileSetStore() {
        return Derive.given(PersistentDir.class).state(ExtractedFileSetStore.class).deriveBy(baseDir -> new ContentHashExtractedFileSetStore(((Path)baseDir.value()).resolve("fileSets"))).withTransitionLabel("extractedFileSetStore");
    }

    @Value.Default
    default public DownloadPackage downloadPackage() {
        return DownloadPackage.withDefaults();
    }

    @Value.Default
    default public Transition<ExtractedFileSet> extractPackage() {
        return ExtractPackage.withDefaults().withExtractedFileSetStore(StateID.of(ExtractedFileSetStore.class));
    }

    @Value.Default
    default public Transition<Package> packageOfDistribution() {
        return PackageOfCommandDistribution.withDefaults();
    }

    @Value.Auxiliary
    default public Transitions extractFileSet() {
        return Transitions.from((Transition[])new Transition[]{this.persistentBaseDir(), this.downloadCache(), this.packageOfDistribution(), this.downloadPackage(), this.extractedFileSetStore(), this.extractPackage()});
    }
}

