/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import com.mongodb.ServerAddress;
import de.flapdoodle.embed.mongo.commands.MongoToolsArguments;
import de.flapdoodle.embed.mongo.transitions.CommandProcessArguments;
import de.flapdoodle.embed.process.types.ProcessArguments;
import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import java.util.List;
import java.util.Set;
import org.immutables.value.Value;

public abstract class MongoToolsProcessArguments<T extends MongoToolsArguments>
implements CommandProcessArguments<T> {
    @Value.Default
    public StateID<ProcessArguments> destination() {
        return StateID.of(ProcessArguments.class);
    }

    @Override
    public abstract StateID<T> arguments();

    @Value.Default
    public StateID<ServerAddress> serverAddress() {
        return StateID.of(ServerAddress.class);
    }

    @Value.Auxiliary
    public Set<StateID<?>> sources() {
        return StateID.setOf((StateID[])new StateID[]{this.arguments(), this.serverAddress()});
    }

    public State<ProcessArguments> result(StateLookup lookup) {
        MongoToolsArguments arguments = (MongoToolsArguments)lookup.of(this.arguments());
        ServerAddress serverAddress = (ServerAddress)lookup.of(this.serverAddress());
        List<String> commandLine = arguments.asArguments(serverAddress);
        return State.of((Object)ProcessArguments.of(commandLine), (TearDown[])new TearDown[0]);
    }
}

