/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import com.mongodb.ServerAddress;
import de.flapdoodle.embed.mongo.commands.MongoRestoreArguments;
import de.flapdoodle.embed.mongo.transitions.MongoRestoreProcessArguments;
import de.flapdoodle.embed.process.types.ProcessArguments;
import de.flapdoodle.reverse.StateID;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="MongoRestoreProcessArguments", generator="Immutables")
public final class ImmutableMongoRestoreProcessArguments
extends MongoRestoreProcessArguments {
    private final StateID<ProcessArguments> destination;
    private final StateID<ServerAddress> serverAddress;
    private final StateID<MongoRestoreArguments> arguments;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMongoRestoreProcessArguments(Builder builder) {
        if (builder.destination != null) {
            this.initShim.destination((StateID<ProcessArguments>)builder.destination);
        }
        if (builder.serverAddress != null) {
            this.initShim.serverAddress((StateID<ServerAddress>)builder.serverAddress);
        }
        if (builder.arguments != null) {
            this.initShim.arguments((StateID<MongoRestoreArguments>)builder.arguments);
        }
        this.destination = this.initShim.destination();
        this.serverAddress = this.initShim.serverAddress();
        this.arguments = this.initShim.arguments();
        this.initShim = null;
    }

    private ImmutableMongoRestoreProcessArguments(StateID<ProcessArguments> destination, StateID<ServerAddress> serverAddress, StateID<MongoRestoreArguments> arguments) {
        this.destination = destination;
        this.serverAddress = serverAddress;
        this.arguments = arguments;
        this.initShim = null;
    }

    @Override
    public StateID<ProcessArguments> destination() {
        InitShim shim = this.initShim;
        return shim != null ? shim.destination() : this.destination;
    }

    @Override
    public StateID<ServerAddress> serverAddress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.serverAddress() : this.serverAddress;
    }

    @Override
    public StateID<MongoRestoreArguments> arguments() {
        InitShim shim = this.initShim;
        return shim != null ? shim.arguments() : this.arguments;
    }

    public final ImmutableMongoRestoreProcessArguments withDestination(StateID<ProcessArguments> value) {
        if (this.destination == value) {
            return this;
        }
        StateID<ProcessArguments> newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableMongoRestoreProcessArguments(newValue, this.serverAddress, this.arguments);
    }

    public final ImmutableMongoRestoreProcessArguments withServerAddress(StateID<ServerAddress> value) {
        if (this.serverAddress == value) {
            return this;
        }
        StateID<ServerAddress> newValue = Objects.requireNonNull(value, "serverAddress");
        return new ImmutableMongoRestoreProcessArguments(this.destination, newValue, this.arguments);
    }

    public final ImmutableMongoRestoreProcessArguments withArguments(StateID<MongoRestoreArguments> value) {
        if (this.arguments == value) {
            return this;
        }
        StateID<MongoRestoreArguments> newValue = Objects.requireNonNull(value, "arguments");
        return new ImmutableMongoRestoreProcessArguments(this.destination, this.serverAddress, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoRestoreProcessArguments && this.equalTo(0, (ImmutableMongoRestoreProcessArguments)another);
    }

    private boolean equalTo(int synthetic, ImmutableMongoRestoreProcessArguments another) {
        return this.destination.equals(another.destination) && this.serverAddress.equals(another.serverAddress) && this.arguments.equals(another.arguments);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.serverAddress.hashCode();
        h += (h << 5) + this.arguments.hashCode();
        return h;
    }

    public String toString() {
        return "MongoRestoreProcessArguments{destination=" + this.destination + ", serverAddress=" + this.serverAddress + ", arguments=" + this.arguments + "}";
    }

    public static ImmutableMongoRestoreProcessArguments copyOf(MongoRestoreProcessArguments instance) {
        if (instance instanceof ImmutableMongoRestoreProcessArguments) {
            return (ImmutableMongoRestoreProcessArguments)instance;
        }
        return ImmutableMongoRestoreProcessArguments.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MongoRestoreProcessArguments", generator="Immutables")
    public static final class Builder {
        private StateID<ProcessArguments> destination;
        private StateID<ServerAddress> serverAddress;
        private StateID<MongoRestoreArguments> arguments;

        private Builder() {
        }

        public final Builder from(MongoRestoreProcessArguments instance) {
            Objects.requireNonNull(instance, "instance");
            this.destination(instance.destination());
            this.serverAddress(instance.serverAddress());
            this.arguments(instance.arguments());
            return this;
        }

        public final Builder destination(StateID<ProcessArguments> destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            return this;
        }

        public final Builder serverAddress(StateID<ServerAddress> serverAddress) {
            this.serverAddress = Objects.requireNonNull(serverAddress, "serverAddress");
            return this;
        }

        public final Builder arguments(StateID<MongoRestoreArguments> arguments) {
            this.arguments = Objects.requireNonNull(arguments, "arguments");
            return this;
        }

        public ImmutableMongoRestoreProcessArguments build() {
            return new ImmutableMongoRestoreProcessArguments(this);
        }
    }

    @Generated(from="MongoRestoreProcessArguments", generator="Immutables")
    private final class InitShim {
        private byte destinationBuildStage = 0;
        private StateID<ProcessArguments> destination;
        private byte serverAddressBuildStage = 0;
        private StateID<ServerAddress> serverAddress;
        private byte argumentsBuildStage = 0;
        private StateID<MongoRestoreArguments> arguments;

        private InitShim() {
        }

        StateID<ProcessArguments> destination() {
            if (this.destinationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.destinationBuildStage == 0) {
                this.destinationBuildStage = (byte)-1;
                this.destination = Objects.requireNonNull(ImmutableMongoRestoreProcessArguments.super.destination(), "destination");
                this.destinationBuildStage = 1;
            }
            return this.destination;
        }

        void destination(StateID<ProcessArguments> destination) {
            this.destination = destination;
            this.destinationBuildStage = 1;
        }

        StateID<ServerAddress> serverAddress() {
            if (this.serverAddressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.serverAddressBuildStage == 0) {
                this.serverAddressBuildStage = (byte)-1;
                this.serverAddress = Objects.requireNonNull(ImmutableMongoRestoreProcessArguments.super.serverAddress(), "serverAddress");
                this.serverAddressBuildStage = 1;
            }
            return this.serverAddress;
        }

        void serverAddress(StateID<ServerAddress> serverAddress) {
            this.serverAddress = serverAddress;
            this.serverAddressBuildStage = 1;
        }

        StateID<MongoRestoreArguments> arguments() {
            if (this.argumentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.argumentsBuildStage == 0) {
                this.argumentsBuildStage = (byte)-1;
                this.arguments = Objects.requireNonNull(ImmutableMongoRestoreProcessArguments.super.arguments(), "arguments");
                this.argumentsBuildStage = 1;
            }
            return this.arguments;
        }

        void arguments(StateID<MongoRestoreArguments> arguments) {
            this.arguments = arguments;
            this.argumentsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.destinationBuildStage == -1) {
                attributes.add("destination");
            }
            if (this.serverAddressBuildStage == -1) {
                attributes.add("serverAddress");
            }
            if (this.argumentsBuildStage == -1) {
                attributes.add("arguments");
            }
            return "Cannot build MongoRestoreProcessArguments, attribute initializers form cycle " + attributes;
        }
    }
}

