package de.flapdoodle.embed.mongo.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ServerAddress}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableServerAddress.builder()}.
 */
@Generated(from = "ServerAddress", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableServerAddress extends ServerAddress {
  private final String host;
  private final int port;

  private ImmutableServerAddress(ImmutableServerAddress.Builder builder) {
    if (builder.host != null) {
      initShim.host(builder.host);
    }
    if (builder.portIsSet()) {
      initShim.port(builder.port);
    }
    this.host = initShim.getHost();
    this.port = initShim.getPort();
    this.initShim = null;
  }

  private ImmutableServerAddress(String host, int port) {
    this.host = host;
    this.port = port;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ServerAddress", generator = "Immutables")
  private final class InitShim {
    private byte hostBuildStage = STAGE_UNINITIALIZED;
    private String host;

    String getHost() {
      if (hostBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (hostBuildStage == STAGE_UNINITIALIZED) {
        hostBuildStage = STAGE_INITIALIZING;
        this.host = Objects.requireNonNull(ImmutableServerAddress.super.getHost(), "host");
        hostBuildStage = STAGE_INITIALIZED;
      }
      return this.host;
    }

    void host(String host) {
      this.host = host;
      hostBuildStage = STAGE_INITIALIZED;
    }

    private byte portBuildStage = STAGE_UNINITIALIZED;
    private int port;

    int getPort() {
      if (portBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (portBuildStage == STAGE_UNINITIALIZED) {
        portBuildStage = STAGE_INITIALIZING;
        this.port = ImmutableServerAddress.super.getPort();
        portBuildStage = STAGE_INITIALIZED;
      }
      return this.port;
    }

    void port(int port) {
      this.port = port;
      portBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (hostBuildStage == STAGE_INITIALIZING) attributes.add("host");
      if (portBuildStage == STAGE_INITIALIZING) attributes.add("port");
      return "Cannot build ServerAddress, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code host} attribute
   */
  @Override
  public String getHost() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getHost()
        : this.host;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @Override
  public int getPort() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPort()
        : this.port;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServerAddress#getHost() host} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for host
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServerAddress withHost(String value) {
    String newValue = Objects.requireNonNull(value, "host");
    if (this.host.equals(newValue)) return this;
    return new ImmutableServerAddress(newValue, this.port);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServerAddress#getPort() port} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServerAddress withPort(int value) {
    if (this.port == value) return this;
    return new ImmutableServerAddress(this.host, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableServerAddress} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableServerAddress
        && equalTo(0, (ImmutableServerAddress) another);
  }

  private boolean equalTo(int synthetic, ImmutableServerAddress another) {
    return host.equals(another.host)
        && port == another.port;
  }

  /**
   * Computes a hash code from attributes: {@code host}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + host.hashCode();
    h += (h << 5) + port;
    return h;
  }

  /**
   * Creates an immutable copy of a {@link ServerAddress} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ServerAddress instance
   */
  public static ImmutableServerAddress copyOf(ServerAddress instance) {
    if (instance instanceof ImmutableServerAddress) {
      return (ImmutableServerAddress) instance;
    }
    return ImmutableServerAddress.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableServerAddress ImmutableServerAddress}.
   * <pre>
   * ImmutableServerAddress.builder()
   *    .host(String) // optional {@link ServerAddress#getHost() host}
   *    .port(int) // optional {@link ServerAddress#getPort() port}
   *    .build();
   * </pre>
   * @return A new ImmutableServerAddress builder
   */
  public static ImmutableServerAddress.Builder builder() {
    return new ImmutableServerAddress.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableServerAddress ImmutableServerAddress}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ServerAddress", generator = "Immutables")
  public static final class Builder {
    private static final long OPT_BIT_PORT = 0x1L;
    private long optBits;

    private String host;
    private int port;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServerAddress} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServerAddress instance) {
      Objects.requireNonNull(instance, "instance");
      host(instance.getHost());
      port(instance.getPort());
      return this;
    }

    /**
     * Initializes the value for the {@link ServerAddress#getHost() host} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ServerAddress#getHost() host}.</em>
     * @param host The value for host 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(String host) {
      this.host = Objects.requireNonNull(host, "host");
      return this;
    }

    /**
     * Initializes the value for the {@link ServerAddress#getPort() port} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ServerAddress#getPort() port}.</em>
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(int port) {
      this.port = port;
      optBits |= OPT_BIT_PORT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableServerAddress ImmutableServerAddress}.
     * @return An immutable instance of ServerAddress
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableServerAddress build() {
      return new ImmutableServerAddress(this);
    }

    private boolean portIsSet() {
      return (optBits & OPT_BIT_PORT) != 0;
    }
  }
}
